/*
 * Decompiled with CFR 0.152.
 */
package wardentools.misc;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class WardenLaserAttack {
    public void tick(ServerLevel level, Player player, long time, Vec3 startPosition, Vec3 direction, int laserLength) {
        for (Entity entity : level.getEntities((Entity)player, player.getBoundingBox().expandTowards(direction.scale((double)laserLength)).inflate(3.0))) {
            TamableAnimal tamableAnimal;
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity) == player || !(livingEntity instanceof TamableAnimal) || (tamableAnimal = (TamableAnimal)livingEntity).isTame() && tamableAnimal.getOwner() == player) continue;
            livingEntity.hurt(player.damageSources().sonicBoom((Entity)player), 38.0f);
            double knockbackResistance = 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            double knockbackHorizontal = 2.5 * knockbackResistance;
            double knockbackVertical = 0.5 * knockbackResistance;
            livingEntity.push(direction.x * knockbackHorizontal, direction.y * knockbackVertical, direction.z * knockbackHorizontal);
        }
    }
}

