/*
 * Decompiled with CFR 0.152.
 */
package wardentools.misc.wind;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.network.payloads.special_effects.WindWhisperSendToClient;

@EventBusSubscriber(modid="wardentools")
public class WhisperManager {
    public static final WhisperManager INSTANCE = new WhisperManager();
    private static final int MIN_TIME_BETWEEN_WHISPERS = 500;
    private int nextMinTime = 500;
    private int timeSinceLastWhisper = 0;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        INSTANCE.tick();
    }

    public void tick() {
        ++this.timeSinceLastWhisper;
    }

    public boolean sendRandomWhisperToAllPlayers(ServerLevel level, BlockPos pos) {
        if (this.timeSinceLastWhisper > this.nextMinTime) {
            this.timeSinceLastWhisper = 0;
            this.nextMinTime = 500 + level.random.nextInt(500);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)level.getChunkAt(pos).getPos(), (CustomPacketPayload)new WindWhisperSendToClient(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    public static void sendRandomWhisperToPlayer(@NotNull Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new WindWhisperSendToClient(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

