/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.biome;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import wardentools.entity.ModEntities;
import wardentools.particle.ParticleRegistry;
import wardentools.sounds.ModMusics;
import wardentools.worldgen.carvers.ModConfiguredCarver;
import wardentools.worldgen.features.ModPlacedFeatures;

public class ModBiomes {
    public static final int DEEP_FOREST_1 = 609089;
    public static final int DEEP_FOREST_2 = 338482;
    public static final int WHITE_FOREST_1 = 7844268;
    public static final int WHITE_FOREST_2 = 2706773;
    private static final int FOG_COLOR = 2844;
    private static final int WATER_COLOR = 674907;
    private static final GenerationStep.Decoration CRYSTAL_STEP = GenerationStep.Decoration.LOCAL_MODIFICATIONS;
    private static final GenerationStep.Decoration SCULK_STEP = GenerationStep.Decoration.UNDERGROUND_DECORATION;
    public static final ResourceKey<Biome> DEEP_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"deep_forest"));
    public static final ResourceKey<Biome> WASTE_LAND = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"waste_land"));
    public static final ResourceKey<Biome> WHITE_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"white_forest"));
    public static final ResourceKey<Biome> CRYSTAL_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"cristal_cave"));
    public static final ResourceKey<Biome> BLINDING_DEPTH = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"blinding_depth"));
    public static final ResourceKey<Biome> AMETHYST_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"amethyst_cave"));
    public static final ResourceKey<Biome> CITRINE_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"citrine_cave"));
    public static final ResourceKey<Biome> MALACHITE_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"malachite_cave"));
    public static final ResourceKey<Biome> RUBY_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"ruby_cave"));
    public static final ResourceKey<Biome> ECHO_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"echo_cave"));
    public static final ResourceKey<Biome> PALE_CAVE = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"pale_cave"));

    public static void bootstrap(BootstrapContext<Biome> context) {
        context.register(DEEP_FOREST, (Object)ModBiomes.deepForest(context));
        context.register(WASTE_LAND, (Object)ModBiomes.wasteLand(context));
        context.register(WHITE_FOREST, (Object)ModBiomes.whiteForest(context));
        context.register(CRYSTAL_CAVE, (Object)ModBiomes.cristalCave(context));
        context.register(BLINDING_DEPTH, (Object)ModBiomes.blindingDepth(context));
        context.register(AMETHYST_CAVE, (Object)ModBiomes.amethystCave(context));
        context.register(CITRINE_CAVE, (Object)ModBiomes.citrineCave(context));
        context.register(MALACHITE_CAVE, (Object)ModBiomes.malachiteCave(context));
        context.register(RUBY_CAVE, (Object)ModBiomes.rubyCave(context));
        context.register(ECHO_CAVE, (Object)ModBiomes.echoCave(context));
        context.register(PALE_CAVE, (Object)ModBiomes.paleCave(context));
    }

    public static Biome deepForest(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.DEEPLURKER.get(), 10, 1, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.NOCTILURE.get(), 1, 1, 1));
        spawnBuilder.creatureGenerationProbability(0.2f);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.defaultAbyssSculk(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.DARKTREE_PLACED_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.DARK_GRASS_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.BLUE_BUSH_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.DEEPFLOWER_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TALL_DARK_GRASS_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome wasteLand(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.DEEPLURKER.get(), 1, 1, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.NOCTILURE.get(), 5, 1, 1));
        spawnBuilder.creatureGenerationProbability(0.1f);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)biomeBuilder);
        ModBiomes.defaultAbyssSculk(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.SHARP_ROCK_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().build()).build();
    }

    public static Biome whiteForest(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.ALLAY, 10, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.PALE_WANDERER.get(), 40, 1, 1));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.NOCTILURE.get(), 1, 1, 1));
        spawnBuilder.creatureGenerationProbability(0.3f);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WHITETREE_PLACED_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WHITE_GRASS_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TALL_WHITE_GRASS_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.WHITE_TORCHFLOWER_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.7f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().grassColorOverride(7844268).foliageColorOverride(2706773).backgroundMusic(ModMusics.WHITE_FOREST).build()).build();
    }

    public static Biome cristalCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.DEEPLURKER.get(), 5, 1, 4));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.ALLAY, 1, 1, 1));
        spawnBuilder.creatureGenerationProbability(0.1f);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.allCrystalsOnCaveWalls(biomeBuilder);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.WHITE_FOREST).foliageColorOverride(5745514).grassColorOverride(5745514).build()).build();
    }

    public static Biome blindingDepth(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.defaultAbyssSculk(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TALL_DEPTH_VINES_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.CAVE_SCULK_TENDRILS_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.LIVING_SPROUT_EMERGENCE_KEY);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.SCULK_TENDRIL_EMERGENCE_DOWN_KEY);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome amethystCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.amethystOnCaveWalls(biomeBuilder);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome citrineCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.citrineOnCaveWalls(biomeBuilder);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome malachiteCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.malachiteOnCaveWalls(biomeBuilder);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome rubyCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.rubyOnCaveWalls(biomeBuilder);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome echoCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        spawnBuilder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.SHADOW.get(), 1, 1, 1));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.defaultAbyssSculk(biomeBuilder);
        ModBiomes.echoOnCaveWalls(biomeBuilder);
        biomeBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, ModPlacedFeatures.SCULK_TENDRIL_EMERGENCE_DOWN_KEY);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static Biome paleCave(BootstrapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.lookup(Registries.PLACED_FEATURE), context.lookup(Registries.CONFIGURED_CARVER));
        ModBiomes.globalAbyssGeneration(biomeBuilder);
        ModBiomes.defaultAbyssCaves(biomeBuilder);
        ModBiomes.defaultAbyssOres(biomeBuilder);
        ModBiomes.paleOnCaveWalls(biomeBuilder);
        ModBiomes.abyssLushVegetationFeatures(biomeBuilder);
        return new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.8f).temperature(0.2f).generationSettings(biomeBuilder.build()).mobSpawnSettings(spawnBuilder.build()).specialEffects(ModBiomes.commonBiomeSpecialEffects().backgroundMusic(ModMusics.DEEP_FOREST).build()).build();
    }

    public static void globalAbyssGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)builder);
        builder.addFeature(GenerationStep.Decoration.RAW_GENERATION, ModPlacedFeatures.LIQUID_CORRUPTION_LAKE_KEY);
    }

    public static void defaultAbyssCaves(BiomeGenerationSettings.Builder builder) {
        builder.addCarver(GenerationStep.Carving.AIR, ModConfiguredCarver.ABYSS_CAVE);
    }

    public static void defaultAbyssOres(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.COAL_ORE_KEY);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.LAPIS_ORE_KEY);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.DIAMOND_ORE_KEY);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.DEEP_ORE_KEY);
        builder.addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.REDSTONE_ORE_KEY);
    }

    public static void defaultAbyssSculk(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(SCULK_STEP, ModPlacedFeatures.ABYSS_SCULK_PATCH_KEY);
    }

    public static BiomeSpecialEffects.Builder commonBiomeSpecialEffects() {
        return new BiomeSpecialEffects.Builder().waterColor(674907).waterFogColor(2844).skyColor(2844).grassColorOverride(609089).foliageColorOverride(338482).fogColor(2844).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleRegistry.ABYSS_AMBIENT.get(), 0.0025f)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS);
    }

    public static void amethystOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.AMETHYST_CRISTAL_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.AMETHYST_CRISTAL_DW_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.AMETHYST_VEIN_KEY);
    }

    public static void citrineOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.CITRINE_CRISTAL_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.CITRINE_CRISTAL_DW_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.CITRINE_VEIN_KEY);
    }

    public static void malachiteOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.MALACHITE_CRISTAL_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.MALACHITE_CRISTAL_DW_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.MALACHITE_VEIN_KEY);
    }

    public static void rubyOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.RUBY_CRISTAL_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.RUBY_CRISTAL_DW_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.RUBY_VEIN_KEY);
    }

    public static void echoOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.ECHO_CRISTAL_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.ECHO_CRISTAL_DW_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.ECHO_VEIN_KEY);
    }

    public static void paleOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.PALE_CRISTAL_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.PALE_CRISTAL_DW_KEY);
        builder.addFeature(CRYSTAL_STEP, ModPlacedFeatures.PALE_CRISTAL_VEIN_KEY);
    }

    public static void allCrystalsOnCaveWalls(BiomeGenerationSettings.Builder builder) {
        ModBiomes.amethystOnCaveWalls(builder);
        ModBiomes.citrineOnCaveWalls(builder);
        ModBiomes.malachiteOnCaveWalls(builder);
        ModBiomes.rubyOnCaveWalls(builder);
        ModBiomes.echoOnCaveWalls(builder);
        ModBiomes.paleOnCaveWalls(builder);
    }

    public static void abyssLushVegetationFeatures(BiomeGenerationSettings.Builder p_176851_) {
        p_176851_.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TALL_DEPTH_VINES_KEY);
        p_176851_.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.CAVE_VINES);
        p_176851_.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.LUSH_CAVES_CLAY);
        p_176851_.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.LUSH_CAVES_VEGETATION);
        p_176851_.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.SPORE_BLOSSOM);
        p_176851_.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.CLASSIC_VINES);
    }
}

