/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.block.BlockRegistry;

public class DarkGrassBlock
extends Block {
    public DarkGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(@NotNull BlockState blockState, @NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        if (level.getBlockState(blockPos.above()).isCollisionShapeFullBlock((BlockGetter)level, blockPos.above())) {
            level.setBlockAndUpdate(blockPos, ((Block)BlockRegistry.DARKDIRT.get()).defaultBlockState());
        }
    }

    public static int getColor(@NotNull BlockState state, @Nullable BlockAndTintGetter getter, @Nullable BlockPos pos, int index) {
        if (getter != null && pos != null) {
            if (index == 0) {
                return BiomeColors.getAverageGrassColor((BlockAndTintGetter)getter, (BlockPos)pos);
            }
            if (index == 1) {
                return BiomeColors.getAverageFoliageColor((BlockAndTintGetter)getter, (BlockPos)pos);
            }
            return -1;
        }
        if (index == 0) {
            return 609089;
        }
        if (index == 1) {
            return 338482;
        }
        return -1;
    }
}

