/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.PaleWandererAnimation;
import wardentools.entity.custom.PaleWandererEntity;

@OnlyIn(value=Dist.CLIENT)
public class PaleWanderer
extends HierarchicalModel<PaleWandererEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"pale_wanderer"), "main");
    private final ModelParts parts;

    public PaleWanderer(ModelPart root) {
        ModelPart FULL = root.getChild("FULL");
        ModelPart BODY = FULL.getChild("BODY");
        ModelPart BODY_FRONT = BODY.getChild("BODY_FRONT");
        ModelPart NECK = BODY_FRONT.getChild("NECK");
        ModelPart LEG_FRONT_L = BODY_FRONT.getChild("LEG_FRONT_L");
        ModelPart LEG_FRONT_R = BODY_FRONT.getChild("LEG_FRONT_R");
        ModelPart BODY_BACK = BODY.getChild("BODY_BACK");
        ModelPart TAIL = BODY_BACK.getChild("TAIL");
        ModelPart TAIL_MAIN = TAIL.getChild("TAIL_MAIN");
        ModelPart TAIL_END = TAIL.getChild("TAIL_END");
        ModelPart LEG_BACK_L = BODY_BACK.getChild("LEG_BACK_L");
        ModelPart LEG_BACK_R = BODY_BACK.getChild("LEG_BACK_R");
        ModelPart BACK = BODY_BACK.getChild("BACK");
        ModelPart HEAD = FULL.getChild("HEAD");
        ModelPart EAR_R = HEAD.getChild("EAR_R");
        ModelPart EAR_L = HEAD.getChild("EAR_L");
        this.parts = new ModelParts(FULL, BODY, BODY_FRONT, NECK, LEG_FRONT_L, LEG_FRONT_R, BODY_BACK, TAIL, TAIL_MAIN, TAIL_END, LEG_BACK_L, LEG_BACK_R, BACK, HEAD, EAR_R, EAR_L);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition BODY = FULL.addOrReplaceChild("BODY", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)-3.0f));
        PartDefinition BODY_FRONT = BODY.addOrReplaceChild("BODY_FRONT", CubeListBuilder.create().texOffs(19, 17).addBox(-3.5f, -3.5f, -4.0f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition NECK = BODY_FRONT.addOrReplaceChild("NECK", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)-4.0f));
        PartDefinition neck_r1 = NECK.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(21, 7).addBox(-2.5f, -2.5f, -4.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LEG_FRONT_L = BODY_FRONT.addOrReplaceChild("LEG_FRONT_L", CubeListBuilder.create().texOffs(6, 30).addBox(0.0f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)-3.0f));
        PartDefinition LEG_FRONT_R = BODY_FRONT.addOrReplaceChild("LEG_FRONT_R", CubeListBuilder.create().texOffs(12, 30).addBox(0.0f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)-3.0f));
        PartDefinition BODY_BACK = BODY.addOrReplaceChild("BODY_BACK", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)3.0f));
        PartDefinition TAIL = BODY_BACK.addOrReplaceChild("TAIL", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)6.0f));
        PartDefinition TAIL_MAIN = TAIL.addOrReplaceChild("TAIL_MAIN", CubeListBuilder.create().texOffs(19, 0).addBox(-1.5f, -2.0f, -1.0f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)1.0f));
        PartDefinition TAIL_END = TAIL.addOrReplaceChild("TAIL_END", CubeListBuilder.create().texOffs(0, 22).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition LEG_BACK_L = BODY_BACK.addOrReplaceChild("LEG_BACK_L", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)4.0f));
        PartDefinition LEG_BACK_R = BODY_BACK.addOrReplaceChild("LEG_BACK_R", CubeListBuilder.create().texOffs(18, 30).addBox(-1.0f, -1.5f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)4.0f));
        PartDefinition BACK = BODY_BACK.addOrReplaceChild("BACK", CubeListBuilder.create().texOffs(0, 12).addBox(-3.5f, -4.5f, 0.0f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 27).addBox(-2.5f, -3.0f, 5.0f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition HEAD = FULL.addOrReplaceChild("HEAD", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(10, 24).addBox(-1.5f, 0.0f, -10.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-6.0f));
        PartDefinition EAR_R = HEAD.addOrReplaceChild("EAR_R", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, -1.5f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-3.0f, (float)0.0f));
        PartDefinition EAR_L = HEAD.addOrReplaceChild("EAR_L", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -1.5f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(PaleWandererEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.calmAnimationState, PaleWandererAnimation.sit, ageInTicks);
        this.animateWalk(PaleWandererAnimation.walking, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.parts.HEAD().xRot += headPitch * ((float)Math.PI / 180);
        this.parts.HEAD().yRot += netHeadYaw * ((float)Math.PI / 180);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.parts.FULL().render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    @NotNull
    public ModelPart root() {
        return this.parts.FULL();
    }

    private record ModelParts(ModelPart FULL, ModelPart BODY, ModelPart BODY_FRONT, ModelPart NECK, ModelPart LEG_FRONT_L, ModelPart LEG_FRONT_R, ModelPart BODY_BACK, ModelPart TAIL, ModelPart TAIL_MAIN, ModelPart TAIL_END, ModelPart LEG_BACK_L, ModelPart LEG_BACK_R, ModelPart BACK, ModelPart HEAD, ModelPart EAR_R, ModelPart EAR_L) {
    }
}

