/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import wardentools.items.ItemRegistry;
import wardentools.particle.ParticleRegistry;

public class ContagionIncarnationCorpseEntity
extends LivingEntity {
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private static final Predicate<Entity> RIDABLE_MINECARTS = entity -> entity instanceof AbstractMinecart && ((AbstractMinecart)entity).canBeRidden();
    public long lastHit;
    private static final int PARTICLE_EFFECT_DURATION = 200;

    public ContagionIncarnationCorpseEntity(EntityType<? extends LivingEntity> entity, Level level) {
        super(entity, level);
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.JUMP_STRENGTH, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            int particleCount = (int)((200.0f - (float)this.tickCount) / 2.0f);
            if (particleCount > 0) {
                this.renderParticles(particleCount);
            } else if (this.tickCount <= 1000) {
                this.renderParticles(1);
            }
        }
    }

    private void renderParticles(int particleCountMax) {
        double minX = this.getBoundingBox().minX - this.getX();
        double minY = this.getBoundingBox().minY;
        double minZ = this.getBoundingBox().minZ - this.getZ() - 2.0;
        double maxX = this.getBoundingBox().maxX - this.getX();
        double maxY = this.getBoundingBox().maxY;
        double maxZ = this.getBoundingBox().maxZ - this.getZ() + 1.0;
        float yawRad = (float)Math.toRadians(this.getYRot());
        int particleCount = this.getRandom().nextInt(0, particleCountMax);
        for (int j = 0; j <= particleCount; ++j) {
            double localX = minX + (maxX - minX) * this.getRandom().nextDouble();
            double y = minY + (maxY - minY) * this.getRandom().nextDouble();
            double localZ = minZ + (maxZ - minZ) * this.getRandom().nextDouble();
            double rotatedX = localX * Math.cos(yawRad) - localZ * Math.sin(yawRad);
            double rotatedZ = localX * Math.sin(yawRad) + localZ * Math.cos(yawRad);
            double x = this.getX() + rotatedX;
            double z = this.getZ() + rotatedZ;
            this.level().addParticle((ParticleOptions)ParticleRegistry.CORRUPTION.get(), x, y, z, 0.0, -0.1, 0.0);
        }
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot slot) {
        return (ItemStack)this.armorItems.get(slot.getIndex());
    }

    public void handleEntityEvent(byte b) {
        if (b == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(b);
        }
    }

    public boolean hurt(@NotNull DamageSource source, float damage) {
        if (!this.level().isClientSide && !this.isRemoved()) {
            if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.kill();
                return false;
            }
            if (!this.isInvulnerableTo(source)) {
                if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.brokenByAnything(source);
                    this.kill();
                    return false;
                }
                if (source.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                    if (this.isOnFire()) {
                        this.causeDamage(source, 0.15f);
                    }
                    return false;
                }
                if (source.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                    this.causeDamage(source, 4.0f);
                    return false;
                }
                boolean flag = source.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
                boolean flag1 = source.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
                if (!flag && !flag1) {
                    return false;
                }
                Entity entity = source.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.getAbilities().mayBuild) {
                        return false;
                    }
                }
                if (source.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.kill();
                } else {
                    long i = this.level().getGameTime();
                    if (i - this.lastHit > 5L && !flag1) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)32);
                        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
                        this.lastHit = i;
                    } else {
                        this.brokenByPlayer(source);
                        this.showBreakingParticles();
                        this.kill();
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void causeDamage(DamageSource damageSource, float damage) {
        float f = this.getHealth();
        if ((f -= damage) <= 0.5f) {
            this.brokenByAnything(damageSource);
            this.kill();
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
        }
    }

    private void brokenByPlayer(DamageSource damageSource) {
        ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.CONTAGION_INCARNATION_SKULL.get());
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack);
        this.brokenByAnything(damageSource);
    }

    private void showBreakingParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void brokenByAnything(DamageSource source) {
        this.playBrokenSound();
        if (this.level().isClientSide) {
            return;
        }
        this.dropAllDeathLoot((ServerLevel)this.level(), source);
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemStack = (ItemStack)this.armorItems.get(j);
            if (itemStack.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)itemStack);
            this.armorItems.set(j, (Object)ItemStack.EMPTY);
        }
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    public void setItemSlot(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        this.armorItems.set(slot.getIndex(), (Object)stack);
    }

    public boolean isPushable() {
        return false;
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void doPush(@NotNull Entity entity) {
    }

    protected void pushEntities() {
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox(), RIDABLE_MINECARTS)) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push((Entity)this);
        }
    }
}

