/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.interfaces;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import wardentools.misc.CustomDamageType;

public class CorruptionMonster
extends Monster {
    protected CorruptionMonster(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public boolean hurt(@NotNull DamageSource source, float v) {
        if (source.getMsgId().equals("corrupted")) {
            return false;
        }
        return super.hurt(source, v);
    }

    public boolean canAttack(@NotNull LivingEntity living) {
        return super.canAttack(living) && !(living instanceof CorruptionMonster);
    }

    public boolean doHurtTarget(Entity target) {
        boolean flag;
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        Level var5 = this.level();
        Holder.Reference corruptedDamageHolder = target.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(CustomDamageType.CORRUPTED_KEY);
        DamageSource damageSource = new DamageSource((Holder)corruptedDamageHolder, target, (Entity)this);
        if (var5 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var5;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)damageSource, (float)f);
        }
        if (flag = target.hurt(damageSource, f)) {
            Level var7;
            float f1 = this.getKnockback(target, damageSource);
            if (f1 > 0.0f && target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                livingentity.knockback((double)(f1 * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((var7 = this.level()) instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)var7;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)target, (DamageSource)damageSource);
            }
            this.setLastHurtMob(target);
            this.playAttackSound();
        }
        return flag;
    }
}

