/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import wardentools.entity.custom.NoctilureEntity;

public class LandGoal
extends Goal {
    private int tickCount = 0;
    private static final int maxTickCount = 1000;
    private static final float heightToSuccessLanding = 3.0f;
    private static final int maxLandingRange = 100;
    private final NoctilureEntity noctilure;
    private Vec3 targetOnLanding;

    public LandGoal(NoctilureEntity noctilure) {
        this.noctilure = noctilure;
    }

    public void start() {
        this.tickCount = 0;
        this.setLandingTargetOrCancel();
    }

    public boolean canUse() {
        return this.noctilure.getWantsToLand() && this.noctilure.getIsFlying();
    }

    public void tick() {
        ++this.tickCount;
        if (this.noctilure.getHeightAboveGround() <= 3.0) {
            this.noctilure.land();
        }
        if (this.targetOnLanding == null) {
            this.setLandingTargetOrCancel();
        }
    }

    private void setLandingTargetOrCancel() {
        BlockPos landingTarget = this.findValidGround();
        if (landingTarget != null) {
            this.targetOnLanding = landingTarget.getCenter().add(0.0, -0.5, 0.0);
            if (!this.noctilure.getNavigation().moveTo(this.targetOnLanding.x, this.targetOnLanding.y, this.targetOnLanding.z, (double)0.2f)) {
                this.noctilure.setWantsToLand(false);
            }
        } else {
            this.noctilure.setWantsToLand(false);
        }
    }

    private BlockPos findValidGround() {
        int i;
        BlockPos entityPos = this.noctilure.blockPosition();
        for (i = 0; i < 100 && this.noctilure.level().getBlockState(entityPos.offset(0, -i, 0)).isAir(); ++i) {
        }
        return i == 100 ? null : entityPos.offset(0, -i, 0);
    }

    public boolean canContinueToUse() {
        return this.noctilure.getWantsToLand() && this.tickCount < 1000;
    }

    public void stop() {
        this.tickCount = 0;
        super.stop();
    }
}

