/*
 * Decompiled with CFR 0.152.
 */
package wardentools.misc.wind;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.misc.wind.ContextualWind;
import wardentools.misc.wind.Whisper;
import wardentools.misc.wind.WhisperTags;
import wardentools.network.payloads.datasync.SyncKnownWhisperToServer;
import wardentools.playerdata.ModDataAttachments;
import wardentools.playerdata.serializables.KnownWindWhispers;
import wardentools.sounds.ModSounds;

@OnlyIn(value=Dist.CLIENT)
public class WindWhispers {
    private final Map<Integer, Whisper> whispers = new HashMap<Integer, Whisper>();
    public final WhisperTags whisperTags = new WhisperTags();
    public static final WindWhispers INSTANCE = new WindWhispers();

    public WindWhispers() {
        int globalId = 0;
        for (WhisperTags.Tag tag : WhisperTags.Tag.values()) {
            for (int i = 1; i <= tag.getNumberOfWhispers(); ++i) {
                Whisper whisper = new Whisper(tag, i, globalId);
                this.whispers.put(++globalId, whisper);
                this.whisperTags.addTag(tag, whisper);
            }
        }
        this.whisperTags.initUnContextualWhispers();
    }

    public static void sendRandomWhisperToPlayer(@NotNull Player player) {
        INSTANCE.sendRandomWhisperToPlayerLocal(player);
    }

    public void sendRandomWhisperToPlayerLocal(@NotNull Player player) {
        player.playSound(ModSounds.WIND_WHISPERS.get(), 5.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
        Holder biomeHolder = player.level().getBiome(player.blockPosition());
        Component whisper = this.getContextualWhisper((Holder<Biome>)biomeHolder);
        MutableComponent windName = Component.translatable((String)"message.wardentools.windname");
        WindWhispers.sendMessage(player, windName.getString() + " " + whisper.getString());
    }

    private static void sendMessage(Player player, String message) {
        player.sendSystemMessage((Component)Component.literal((String)message));
    }

    @Nullable
    public Whisper getNewRandomContextualWhisper(WhisperTags.Tag tag) {
        Whisper whisper2;
        if (Minecraft.getInstance().player == null) {
            return null;
        }
        ArrayList<Whisper> availableWhispers = new ArrayList<Whisper>();
        KnownWindWhispers data = (KnownWindWhispers)Minecraft.getInstance().player.getData(ModDataAttachments.KNOWN_WIND_WHISPERS);
        for (Whisper whisper2 : this.whisperTags.getContextualWhispers(tag)) {
            if (data.whisperKnown(whisper2.globalId())) continue;
            availableWhispers.add(whisper2);
        }
        if (availableWhispers.isEmpty()) {
            return null;
        }
        Random rand = new Random();
        whisper2 = (Whisper)availableWhispers.get(rand.nextInt(availableWhispers.size()));
        WindWhispers.addWhisperIdToPlayer(whisper2);
        return whisper2;
    }

    public Whisper getRandomWhisper() {
        List<Whisper> whisperList = this.whispers.values().stream().toList();
        Random rand = new Random();
        Whisper whisper = whisperList.get(rand.nextInt(whisperList.size()));
        WindWhispers.addWhisperIdToPlayer(whisper);
        return whisper;
    }

    public static void addWhisperIdToPlayer(Whisper whisper) {
        KnownWindWhispers data;
        if (Minecraft.getInstance().player != null && !(data = (KnownWindWhispers)Minecraft.getInstance().player.getData(ModDataAttachments.KNOWN_WIND_WHISPERS)).whisperKnown(whisper.globalId())) {
            data.addKnownWhisper(whisper.globalId());
            Minecraft.getInstance().player.setData(ModDataAttachments.KNOWN_WIND_WHISPERS, (Object)data);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncKnownWhisperToServer(whisper.globalId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public Component getContextualWhisper(Holder<Biome> biomeHolder) {
        Whisper whisper = this.getNewRandomContextualWhisper(ContextualWind.getTagForBiome(biomeHolder));
        return whisper == null ? this.getRandomWhisper().whisper() : whisper.whisper();
    }

    public static String getLockedString() {
        return Component.translatable((String)"message.wardentools.locked").getString();
    }
}

