/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import wardentools.block.BlockRegistry;
import wardentools.tags.ModTags;
import wardentools.worldgen.features.ModConfiguredFeatures;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> DARKTREE_PLACED_KEY = ModPlacedFeatures.registerKey("darktree_placed");
    public static final ResourceKey<PlacedFeature> WHITETREE_PLACED_KEY = ModPlacedFeatures.registerKey("whitetree_placed");
    public static final ResourceKey<PlacedFeature> WHITE_GRASS_KEY = ModPlacedFeatures.registerKey("white_grass");
    public static final ResourceKey<PlacedFeature> TALL_WHITE_GRASS_KEY = ModPlacedFeatures.registerKey("tall_white_grass");
    public static final ResourceKey<PlacedFeature> WHITE_TORCHFLOWER_KEY = ModPlacedFeatures.registerKey("white_torchflower");
    public static final ResourceKey<PlacedFeature> DEEPFLOWER_KEY = ModPlacedFeatures.registerKey("deepflower");
    public static final ResourceKey<PlacedFeature> BLUE_BUSH_KEY = ModPlacedFeatures.registerKey("blue_bush");
    public static final ResourceKey<PlacedFeature> TALL_DARK_GRASS_KEY = ModPlacedFeatures.registerKey("tall_dark_grass");
    public static final ResourceKey<PlacedFeature> DARK_GRASS_KEY = ModPlacedFeatures.registerKey("dark_grass");
    public static final ResourceKey<PlacedFeature> COAL_ORE_KEY = ModPlacedFeatures.registerKey("coal_ore");
    public static final ResourceKey<PlacedFeature> LAPIS_ORE_KEY = ModPlacedFeatures.registerKey("lapis_ore");
    public static final ResourceKey<PlacedFeature> DIAMOND_ORE_KEY = ModPlacedFeatures.registerKey("diamond_ore");
    public static final ResourceKey<PlacedFeature> DEEP_ORE_KEY = ModPlacedFeatures.registerKey("deep_ore");
    public static final ResourceKey<PlacedFeature> REDSTONE_ORE_KEY = ModPlacedFeatures.registerKey("redstone_ore");
    public static final ResourceKey<PlacedFeature> LIQUID_CORRUPTION_LAKE_KEY = ModPlacedFeatures.registerKey("liquid_corruption_lake");
    public static final ResourceKey<PlacedFeature> SHARP_ROCK_KEY = ModPlacedFeatures.registerKey("sharp_rock");
    public static final ResourceKey<PlacedFeature> MALACHITE_CRISTAL_KEY = ModPlacedFeatures.registerKey("malachite_cristal_key");
    public static final ResourceKey<PlacedFeature> RUBY_CRISTAL_KEY = ModPlacedFeatures.registerKey("ruby_cristal_key");
    public static final ResourceKey<PlacedFeature> CITRINE_CRISTAL_KEY = ModPlacedFeatures.registerKey("citrine_cristal_key");
    public static final ResourceKey<PlacedFeature> ECHO_CRISTAL_KEY = ModPlacedFeatures.registerKey("echo_cristal_key");
    public static final ResourceKey<PlacedFeature> PALE_CRISTAL_KEY = ModPlacedFeatures.registerKey("pale_cristal_key");
    public static final ResourceKey<PlacedFeature> AMETHYST_CRISTAL_KEY = ModPlacedFeatures.registerKey("amethyst_cristal_key");
    public static final ResourceKey<PlacedFeature> MALACHITE_CRISTAL_DW_KEY = ModPlacedFeatures.registerKey("malachite_cristal_dw_key");
    public static final ResourceKey<PlacedFeature> RUBY_CRISTAL_DW_KEY = ModPlacedFeatures.registerKey("ruby_cristal_dw_key");
    public static final ResourceKey<PlacedFeature> CITRINE_CRISTAL_DW_KEY = ModPlacedFeatures.registerKey("citrine_cristal_dw_key");
    public static final ResourceKey<PlacedFeature> ECHO_CRISTAL_DW_KEY = ModPlacedFeatures.registerKey("echo_cristal_dw_key");
    public static final ResourceKey<PlacedFeature> PALE_CRISTAL_DW_KEY = ModPlacedFeatures.registerKey("pale_cristal_dw_key");
    public static final ResourceKey<PlacedFeature> AMETHYST_CRISTAL_DW_KEY = ModPlacedFeatures.registerKey("amethyst_cristal_dw_key");
    public static final ResourceKey<PlacedFeature> MALACHITE_VEIN_KEY = ModPlacedFeatures.registerKey("malachite_vein");
    public static final ResourceKey<PlacedFeature> RUBY_VEIN_KEY = ModPlacedFeatures.registerKey("ruby_vein");
    public static final ResourceKey<PlacedFeature> CITRINE_VEIN_KEY = ModPlacedFeatures.registerKey("citrine_vein");
    public static final ResourceKey<PlacedFeature> ECHO_VEIN_KEY = ModPlacedFeatures.registerKey("echo_vein");
    public static final ResourceKey<PlacedFeature> PALE_CRISTAL_VEIN_KEY = ModPlacedFeatures.registerKey("pale_vein");
    public static final ResourceKey<PlacedFeature> AMETHYST_VEIN_KEY = ModPlacedFeatures.registerKey("amethyst_vein");
    public static final ResourceKey<PlacedFeature> SCULK_TENDRIL_EMERGENCE_KEY = ModPlacedFeatures.registerKey("sculk_tendril_emergence");
    public static final ResourceKey<PlacedFeature> SCULK_TENDRIL_EMERGENCE_DOWN_KEY = ModPlacedFeatures.registerKey("sculk_tendril_emergence_down");
    public static final ResourceKey<PlacedFeature> ABYSS_SCULK_PATCH_KEY = ModPlacedFeatures.registerKey("abyss_sculk_patch");
    public static final ResourceKey<PlacedFeature> TALL_DEPTH_VINES_KEY = ModPlacedFeatures.registerKey("tall_depth_vines");
    public static final ResourceKey<PlacedFeature> CAVE_SCULK_TENDRILS_KEY = ModPlacedFeatures.registerKey("sculk_tendrils");
    public static final ResourceKey<PlacedFeature> LIVING_SPROUT_EMERGENCE_KEY = ModPlacedFeatures.registerKey("living_sprout_emergence");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, DARKTREE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.DARKTREE_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)3, (float)0.1f, (int)2), (Block)((Block)BlockRegistry.DARKTREE_SAPLING.get())));
        ModPlacedFeatures.register(context, WHITETREE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.WHITETREE_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)14, (float)0.1f, (int)2), (Block)((Block)BlockRegistry.WHITETREE_SAPLING.get())));
        ModPlacedFeatures.register(context, WHITE_GRASS_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.WHITE_GRASS), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, TALL_WHITE_GRASS_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.TALL_WHITE_GRASS), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, WHITE_TORCHFLOWER_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.WHITE_TORCHFLOWER), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, DEEPFLOWER_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.DEEPFLOWER), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, BLUE_BUSH_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.BLUE_BUSH), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, TALL_DARK_GRASS_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.TALL_DARK_GRASS), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, DARK_GRASS_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.DARK_GRASS), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP));
        ModPlacedFeatures.register(context, COAL_ORE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.COAL_ORE), ModPlacedFeatures.oreGeneration(20, -24, 192));
        ModPlacedFeatures.register(context, LAPIS_ORE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.LAPIS_ORE), ModPlacedFeatures.oreGeneration(10, -44, 54));
        ModPlacedFeatures.register(context, DIAMOND_ORE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.DIAMOND_ORE), ModPlacedFeatures.oreGeneration(9, -64, 32));
        ModPlacedFeatures.register(context, DEEP_ORE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.DEEP_ORE), ModPlacedFeatures.oreGeneration(6, -80, 10));
        ModPlacedFeatures.register(context, REDSTONE_ORE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.REDSTONE_ORE), ModPlacedFeatures.oreGeneration(10, -50, 50));
        ModPlacedFeatures.register(context, LIQUID_CORRUPTION_LAKE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.LIQUID_CORRUPTION_FLOOR), List.of(CountPlacement.of((int)1)));
        ModPlacedFeatures.register(context, SHARP_ROCK_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.SHARP_ROCK), List.of(CountPlacement.of((IntProvider)UniformInt.of((int)2, (int)4)), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, MALACHITE_CRISTAL_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.MALACHITE_CRISTAL), ModPlacedFeatures.onCaveWallUp(4, 8));
        ModPlacedFeatures.register(context, RUBY_CRISTAL_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.RUBY_CRISTAL), ModPlacedFeatures.onCaveWallUp(4, 8));
        ModPlacedFeatures.register(context, CITRINE_CRISTAL_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.CITRINE_CRISTAL), ModPlacedFeatures.onCaveWallUp(4, 8));
        ModPlacedFeatures.register(context, ECHO_CRISTAL_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.ECHO_CRISTAL), ModPlacedFeatures.onCaveWallUp(4, 8));
        ModPlacedFeatures.register(context, PALE_CRISTAL_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.PALE_CRISTAL), ModPlacedFeatures.onCaveWallUp(3, 7));
        ModPlacedFeatures.register(context, AMETHYST_CRISTAL_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.AMETHYST_CRISTAL), ModPlacedFeatures.onCaveWallUp(5, 9));
        ModPlacedFeatures.register(context, MALACHITE_CRISTAL_DW_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.MALACHITE_CRISTAL), ModPlacedFeatures.onCaveWallDown(4, 8));
        ModPlacedFeatures.register(context, RUBY_CRISTAL_DW_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.RUBY_CRISTAL), ModPlacedFeatures.onCaveWallDown(4, 8));
        ModPlacedFeatures.register(context, CITRINE_CRISTAL_DW_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.CITRINE_CRISTAL), ModPlacedFeatures.onCaveWallDown(4, 8));
        ModPlacedFeatures.register(context, ECHO_CRISTAL_DW_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.ECHO_CRISTAL), ModPlacedFeatures.onCaveWallDown(4, 8));
        ModPlacedFeatures.register(context, PALE_CRISTAL_DW_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.PALE_CRISTAL), ModPlacedFeatures.onCaveWallDown(3, 7));
        ModPlacedFeatures.register(context, AMETHYST_CRISTAL_DW_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.AMETHYST_CRISTAL), ModPlacedFeatures.onCaveWallDown(5, 9));
        ModPlacedFeatures.register(context, MALACHITE_VEIN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.MALACHITE_VEIN), ModPlacedFeatures.onCaveWallDown(3, 5));
        ModPlacedFeatures.register(context, RUBY_VEIN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.RUBY_VEIN), ModPlacedFeatures.onCaveWallDown(3, 5));
        ModPlacedFeatures.register(context, CITRINE_VEIN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.CITRINE_VEIN), ModPlacedFeatures.onCaveWallDown(3, 5));
        ModPlacedFeatures.register(context, ECHO_VEIN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.ECHO_VEIN), ModPlacedFeatures.onCaveWallDown(3, 5));
        ModPlacedFeatures.register(context, PALE_CRISTAL_VEIN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.PALE_CRISTAL_VEIN), ModPlacedFeatures.onCaveWallDown(3, 5));
        ModPlacedFeatures.register(context, AMETHYST_VEIN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.AMETHYST_VEIN), ModPlacedFeatures.onCaveWallDown(3, 5));
        ModPlacedFeatures.register(context, SCULK_TENDRIL_EMERGENCE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.SCULK_TENDRIL_EMERGENCE), List.of(CountPlacement.of((int)1)));
        ModPlacedFeatures.register(context, SCULK_TENDRIL_EMERGENCE_DOWN_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.SCULK_TENDRIL_EMERGENCE_DOWN), ModPlacedFeatures.onCaveWallUp(1, 3));
        ModPlacedFeatures.register(context, ABYSS_SCULK_PATCH_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.ABYSS_SCULK_PATCH), List.of(CountPlacement.of((IntProvider)ConstantInt.of((int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, TALL_DEPTH_VINES_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.TALL_DEPTH_VINE), List.of(CountPlacement.of((IntProvider)UniformInt.of((int)6, (int)12)), InSquarePlacement.spread(), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, CAVE_SCULK_TENDRILS_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.SCULK_TENDRIL_EMERGENCE), ModPlacedFeatures.onCaveWallDown(4, 8));
        ModPlacedFeatures.register(context, LIVING_SPROUT_EMERGENCE_KEY, context.lookup(Registries.CONFIGURED_FEATURE).getOrThrow(ModConfiguredFeatures.LIVING_SPROUT_EMERGENCE), ModPlacedFeatures.onCaveWallDown(6, 10));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static List<PlacementModifier> onCaveWallUp(int minPerChunk, int maxPerChunk) {
        return List.of(CountPlacement.of((IntProvider)UniformInt.of((int)minPerChunk, (int)maxPerChunk)), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)20), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesTag(ModTags.Blocks.CRISTAL_BLOCK))), BiomeFilter.biome());
    }

    private static List<PlacementModifier> onCaveWallDown(int minPerChunk, int maxPerChunk) {
        return List.of(CountPlacement.of((IntProvider)UniformInt.of((int)minPerChunk, (int)maxPerChunk)), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)20), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesTag(ModTags.Blocks.CRISTAL_BLOCK))), BiomeFilter.biome());
    }

    private static List<PlacementModifier> oreGeneration(int veinsPerChunk, int minHeight, int maxHeight) {
        return List.of(CountPlacement.of((int)veinsPerChunk), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)maxHeight)), BiomeFilter.biome());
    }
}

