/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SharpRock
extends Feature<NoneFeatureConfiguration> {
    private static final float INCLINATION = 1.5f;
    private static final float BASE_TO_LENGTH_RATIO = 5.0f;
    private static final int THICK_MAX = 5;
    private static final int THICK_MIN = 2;

    public SharpRock(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldGenLevel = context.level();
        BlockPos origin = context.origin();
        int base_radius = context.level().getRandom().nextInt(2, 5);
        int length = (int)((context.level().getRandom().nextFloat() + 0.5f) * 5.0f * (float)base_radius);
        float xoffset = (context.level().getRandom().nextFloat() - 0.5f) * 1.5f;
        float zoffset = (context.level().getRandom().nextFloat() - 0.5f) * 1.5f;
        for (int y = -3; y < length; ++y) {
            int x = (int)(xoffset * (float)y);
            int z = (int)(zoffset * (float)y);
            float radius = (float)base_radius * (float)(length - y) / (float)length;
            if (!((double)radius > 0.8)) continue;
            SharpRock.circle(context, worldGenLevel, origin.offset(x, y, z), radius);
        }
        return false;
    }

    private static void circle(FeaturePlaceContext<NoneFeatureConfiguration> context, WorldGenLevel worldGenLevel, BlockPos center, float radius) {
        float random_finition = radius > 2.0f ? context.level().getRandom().nextFloat() - 0.5f : 0.0f;
        int x = -((int)(radius + 0.5f));
        while ((float)x <= radius) {
            int z = -((int)(radius + 0.5f));
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) < radius * radius + random_finition) {
                    worldGenLevel.setBlock(center.offset(x, 0, z), Blocks.DEEPSLATE.defaultBlockState(), 3);
                }
                ++z;
            }
            ++x;
        }
    }
}

