/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;
import wardentools.worldgen.tree.ModTrunkPlacerTypes;

public class DarktreeTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<DarktreeTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(darktreeTrunkPlacerInstance -> DarktreeTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)darktreeTrunkPlacerInstance).apply((Applicative)darktreeTrunkPlacerInstance, DarktreeTrunkPlacer::new));

    public DarktreeTrunkPlacer(int baseHeight, int pHeightRandA, int pHeightRandB) {
        super(baseHeight, pHeightRandA, pHeightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> type() {
        return ModTrunkPlacerTypes.DARKTREE_TRUNK_PLACER.get();
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(@NotNull LevelSimulatedReader level, @NotNull BiConsumer<BlockPos, BlockState> setter, @NotNull RandomSource random, int freeTreeHeight, BlockPos pos, @NotNull TreeConfiguration config) {
        int z;
        int y;
        int x;
        DarktreeTrunkPlacer.setDirtAt((LevelSimulatedReader)level, setter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        int heightFirstBranch = freeTreeHeight + random.nextInt(-2, 2);
        ArrayList<BlockPos> listTrunk = new ArrayList<BlockPos>();
        ArrayList<FoliagePlacer.FoliageAttachment> foliagePositions = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int branchLength = this.heightRandA;
        if (branchLength < 3) {
            branchLength = 3;
        }
        int branchLengthVariation = 0;
        int branchPosVariation = 0;
        double branchCurvatureMean = 0.08;
        double branchCurvature = 0.0;
        if (heightFirstBranch < 5) {
            heightFirstBranch = 5;
        }
        for (int i = 0; i < heightFirstBranch - 3; ++i) {
            listTrunk.add(pos.above(i));
        }
        BlockPos startPoint = pos.above(heightFirstBranch);
        ArrayList<Integer> actualBranchStart = new ArrayList<Integer>();
        branchCurvature = branchCurvatureMean * random.nextDouble() * 2.0;
        branchLengthVariation = random.nextInt(-3, 3);
        branchPosVariation = random.nextInt(-4, 0);
        actualBranchStart.add(branchPosVariation);
        for (x = 0; x <= branchLength + branchLengthVariation; ++x) {
            y = (int)Math.round(branchCurvature * (double)x * (double)x) + branchPosVariation;
            if (y - ((BlockPos)listTrunk.getLast()).getY() + startPoint.getY() > 1) {
                listTrunk.add(startPoint.offset(-x, y - 1, 0));
            }
            listTrunk.add(startPoint.offset(-x, y, 0));
        }
        listTrunk.add(((BlockPos)listTrunk.getLast()).offset(0, 1, 0));
        foliagePositions.add(new FoliagePlacer.FoliageAttachment((BlockPos)listTrunk.getLast(), -2, false));
        branchCurvature = branchCurvatureMean * random.nextDouble() * 2.0;
        branchLengthVariation = random.nextInt(-3, 3);
        branchPosVariation = random.nextInt(-4, 0);
        actualBranchStart.add(branchPosVariation);
        for (z = 0; z <= branchLength + branchLengthVariation; ++z) {
            y = (int)Math.round(branchCurvature * (double)z * (double)z) + branchPosVariation;
            if (y - ((BlockPos)listTrunk.getLast()).getY() + startPoint.getY() > 1) {
                listTrunk.add(startPoint.offset(0, y - 1, z));
            }
            listTrunk.add(startPoint.offset(0, y, z));
        }
        listTrunk.add(((BlockPos)listTrunk.getLast()).offset(0, 1, 0));
        foliagePositions.add(new FoliagePlacer.FoliageAttachment((BlockPos)listTrunk.getLast(), -2, false));
        branchCurvature = branchCurvatureMean * random.nextDouble() * 2.0;
        branchLengthVariation = random.nextInt(-3, 3);
        branchPosVariation = random.nextInt(-4, 0);
        actualBranchStart.add(branchPosVariation);
        for (x = 0; x <= branchLength + branchLengthVariation; ++x) {
            y = (int)Math.round(branchCurvature * (double)x * (double)x) + branchPosVariation;
            if (y - ((BlockPos)listTrunk.getLast()).getY() + startPoint.getY() > 1) {
                listTrunk.add(startPoint.offset(x, y - 1, 0));
            }
            listTrunk.add(startPoint.offset(x, y, 0));
        }
        listTrunk.add(((BlockPos)listTrunk.getLast()).offset(0, 1, 0));
        foliagePositions.add(new FoliagePlacer.FoliageAttachment((BlockPos)listTrunk.getLast(), -2, false));
        branchCurvature = branchCurvatureMean * random.nextDouble() * 2.0;
        branchLengthVariation = random.nextInt(-3, 3);
        branchPosVariation = random.nextInt(-4, 0);
        actualBranchStart.add(branchPosVariation);
        for (z = 0; z <= branchLength + branchLengthVariation; ++z) {
            y = (int)Math.round(branchCurvature * (double)z * (double)z) + branchPosVariation;
            if (y - ((BlockPos)listTrunk.getLast()).getY() + startPoint.getY() > 1) {
                listTrunk.add(startPoint.offset(0, y - 1, -z));
            }
            listTrunk.add(startPoint.offset(0, y, -z));
        }
        listTrunk.add(((BlockPos)listTrunk.getLast()).offset(0, 1, 0));
        foliagePositions.add(new FoliagePlacer.FoliageAttachment((BlockPos)listTrunk.getLast(), -2, false));
        for (int i = heightFirstBranch - 4; i < heightFirstBranch + (Integer)Collections.max(actualBranchStart); ++i) {
            listTrunk.add(pos.above(i));
        }
        for (BlockPos blockPos : listTrunk) {
            this.placeLog(level, setter, random, blockPos, config);
        }
        return foliagePositions;
    }
}

