/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc;

import com.TBK.crc.Config;
import com.TBK.crc.client.renderer.BeamExplosionRenderer;
import com.TBK.crc.client.renderer.BoomChickenRenderer;
import com.TBK.crc.client.renderer.CoilChickenRenderer;
import com.TBK.crc.client.renderer.CyborgRobotChickenRenderer;
import com.TBK.crc.client.renderer.DroneChickenRenderer;
import com.TBK.crc.client.renderer.ElectroProjectileRenderer;
import com.TBK.crc.client.renderer.GanchoRenderer;
import com.TBK.crc.client.renderer.GlowingBlockRenderer;
import com.TBK.crc.client.renderer.PortalRenderer;
import com.TBK.crc.client.renderer.PunchChickenRenderer;
import com.TBK.crc.client.renderer.ResidualRenderer;
import com.TBK.crc.client.renderer.RexChickenRenderer;
import com.TBK.crc.client.renderer.TeleportRenderer;
import com.TBK.crc.common.Util;
import com.TBK.crc.common.block.CyborgTableBlock;
import com.TBK.crc.common.registry.BKBlocks;
import com.TBK.crc.common.registry.BKContainers;
import com.TBK.crc.common.registry.BKCreativeModeTab;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKItems;
import com.TBK.crc.common.registry.BKParticles;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.capability.CRCCapability;
import com.TBK.crc.server.network.PacketHandler;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="crc")
public class CRC {
    public static final String MODID = "crc";
    public static double x = 0.0;
    public static double y = 0.0;
    public static double z = 0.0;
    public static double xq = 0.0;
    public static double yq = 0.0;
    public static double zq = 0.0;
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_119253_ -> new ResourceLocation(MODID, "groundeffect/destroy_stage_" + p_119253_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_119371_ -> new ResourceLocation(MODID, "textures/" + p_119371_.m_135815_() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::m_110494_).collect(Collectors.toList());
    public static final List<ResourceLocation> GUI_STAGES = IntStream.range(0, 155).mapToObj(p_119253_ -> new ResourceLocation(MODID, "gui/cyborg_table/cyborg_table_gui_" + p_119253_)).collect(Collectors.toList());
    public static final List<ResourceLocation> GUI_LOCATIONS = GUI_STAGES.stream().map(p_119371_ -> new ResourceLocation(MODID, "textures/" + p_119371_.m_135815_() + ".png")).collect(Collectors.toList());
    public static final List<ResourceLocation> GUI_IMPLANT_STAGES = IntStream.range(0, 73).mapToObj(p_119253_ -> new ResourceLocation(MODID, "gui/upgrade_table/cyborg_upgrade_table_gui_" + p_119253_)).collect(Collectors.toList());
    public static final List<ResourceLocation> GUI_IMPLANT_LOCATIONS = GUI_IMPLANT_STAGES.stream().map(p_119371_ -> new ResourceLocation(MODID, "textures/" + p_119371_.m_135815_() + ".png")).collect(Collectors.toList());
    public static final List<ResourceLocation> NIGHT_VISION_STAGES = IntStream.range(0, 95).mapToObj(p_119253_ -> new ResourceLocation(MODID, "gui/window_effect/night_eye_overlay_" + p_119253_)).collect(Collectors.toList());
    public static final List<ResourceLocation> NIGHT_VISION_LOCATIONS = NIGHT_VISION_STAGES.stream().map(p_119371_ -> new ResourceLocation(MODID, "textures/" + p_119371_.m_135815_() + ".png")).collect(Collectors.toList());

    public CRC() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        BKEntityType.ENTITY_TYPES.register(modEventBus);
        BKParticles.PARTICLE_TYPES.register(modEventBus);
        BKItems.ITEMS.register(modEventBus);
        BKBlocks.BLOCKS.register(modEventBus);
        BKCreativeModeTab.TABS.register(modEventBus);
        BKContainers.CONTAINERS.register(modEventBus);
        BKSounds.register(modEventBus);
        PacketHandler.registerMessages();
        modEventBus.addListener(CRCCapability::registerCapabilities);
        Util.initUpgrades();
        MinecraftForge.EVENT_BUS.addListener(this::sleepLocationCheck);
        MinecraftForge.EVENT_BUS.addListener(this::sleepTimeCheck);
        MinecraftForge.EVENT_BUS.addListener(this::sleepTimeFinish);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::registerRenderers));
    }

    public void startServer(ServerStartedEvent event) {
    }

    public void sleepLocationCheck(@NotNull SleepingLocationCheckEvent event) {
        if (event.getEntity().m_9236_().m_8055_(event.getSleepingLocation()).m_60734_() instanceof CyborgTableBlock) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    public void sleepTimeCheck(@NotNull SleepingTimeCheckEvent event) {
        event.getSleepingLocation().ifPresent(blockPos -> {
            if (event.getEntity().m_9236_().m_8055_(blockPos).m_60734_() instanceof CyborgTableBlock) {
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    public void sleepTimeFinish(@NotNull SleepFinishedTimeEvent event) {
        boolean sleepingInCoffin;
        if (event.getLevel() instanceof ServerLevel && (sleepingInCoffin = event.getLevel().m_6907_().stream().anyMatch(player -> {
            Optional pos = player.m_21257_();
            return pos.isPresent() && event.getLevel().m_8055_((BlockPos)pos.get()).m_60734_() instanceof CyborgTableBlock;
        }))) {
            event.setTimeAddition(0L);
        }
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerRenderers(FMLCommonSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.TELEPORT.get()), TeleportRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.PORTAL.get()), PortalRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.REX_CHICKEN.get()), RexChickenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.CRACKING_BEAM.get()), BeamExplosionRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.GANCHO.get()), GanchoRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.ELECTRO.get()), ElectroProjectileRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.RESIDUAL.get()), ResidualRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.BOOM_CHICKEN.get()), BoomChickenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.COIL_CHICKEN.get()), CoilChickenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.DRONE_CHICKEN.get()), DroneChickenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.PUNCH_CHICKEN.get()), PunchChickenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BKEntityType.CYBORG_ROBOT_CHICKEN.get()), CyborgRobotChickenRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)BlockEntityType.f_58918_, GlowingBlockRenderer::new);
    }
}

