/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.client.renderer;

import com.TBK.crc.CRC;
import com.TBK.crc.server.entity.BeamExplosionEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public class BeamExplosionRenderer<T extends BeamExplosionEntity>
extends NoopRenderer<T> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public BeamExplosionRenderer(EntityRendererProvider.Context p_174326_) {
        super(p_174326_);
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    public void render(T p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        super.m_7392_(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        for (Map.Entry<BlockPos, Integer> entry : ((BeamExplosionEntity)((Object)p_115455_)).crackingBlock.entrySet()) {
            p_115458_.m_85836_();
            float progressMining = 1.0f - ((float)((BeamExplosionEntity)((Object)p_115455_)).restoreCracking - (float)entry.getValue().intValue()) / 50.0f;
            if (progressMining >= 0.0f) {
                BlockPos miningPos = entry.getKey();
                double d0 = Mth.m_14139_((double)p_115457_, (double)((BeamExplosionEntity)((Object)p_115455_)).f_19790_, (double)p_115455_.m_20185_());
                double d1 = Mth.m_14139_((double)p_115457_, (double)((BeamExplosionEntity)((Object)p_115455_)).f_19791_, (double)p_115455_.m_20186_());
                double d2 = Mth.m_14139_((double)p_115457_, (double)((BeamExplosionEntity)((Object)p_115455_)).f_19856_, (double)p_115455_.m_20189_());
                p_115458_.m_85837_((double)miningPos.m_123341_() - d0, (double)miningPos.m_123342_() - d1, (double)miningPos.m_123343_() - d2);
                PoseStack.Pose posestack$pose = p_115458_.m_85850_();
                int progress = Math.round((float)(CRC.DESTROY_TYPES.size() - 1) * Mth.m_14036_((float)progressMining, (float)0.0f, (float)1.0f));
                SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(Minecraft.m_91087_().m_91269_().m_110108_().m_6299_(CRC.DESTROY_TYPES.get(progress)), posestack$pose.m_252922_(), posestack$pose.m_252943_(), 1.0f);
                ModelData modelData = p_115455_.m_9236_().getModelDataManager().getAt(miningPos);
                Minecraft.m_91087_().m_91289_().renderBreakingTexture(p_115455_.m_9236_().m_8055_(miningPos), miningPos, (BlockAndTintGetter)p_115455_.m_9236_(), p_115458_, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
            }
            p_115458_.m_85849_();
        }
        float f5 = 1.0f - (float)((BeamExplosionEntity)((Object)p_115455_)).restoreCracking / 50.0f;
        float f7 = Math.min(f5 > 0.65f ? (f5 - 0.65f) / 0.45f : 0.0f, 1.0f);
        float secondCirclePercent = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
        RandomSource randomsource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexconsumer2 = p_115459_.m_6299_(RenderType.m_110502_());
        p_115458_.m_85836_();
        this.renderLight(p_115458_, vertexconsumer2, 0.0f, 0.0f, 0.0f, f7, 0.0f);
        p_115458_.m_85849_();
    }

    private void renderLight(PoseStack stack, VertexConsumer vertexConsumer, float x, float y, float z, float percent, float rotX) {
        stack.m_252880_(x, y, z);
        int i = 0;
        while ((float)i < 1.0f + 3.0f * percent) {
            stack.m_252781_(Axis.f_252529_.m_252977_(30.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_((float)(15 + 15 * i)));
            float f3 = percent * 5.0f;
            float f4 = 0.5f;
            Matrix4f matrix4f = stack.m_85850_().m_252922_();
            int j = (int)(255.0f * (1.0f - percent));
            BeamExplosionRenderer.vertex01(vertexConsumer, matrix4f, j);
            BeamExplosionRenderer.vertex2(vertexConsumer, matrix4f, f3, f4);
            BeamExplosionRenderer.vertex3(vertexConsumer, matrix4f, f3, f4);
            BeamExplosionRenderer.vertex01(vertexConsumer, matrix4f, j);
            BeamExplosionRenderer.vertex3(vertexConsumer, matrix4f, f3, f4);
            BeamExplosionRenderer.vertex4(vertexConsumer, matrix4f, f3, f4);
            BeamExplosionRenderer.vertex01(vertexConsumer, matrix4f, j);
            BeamExplosionRenderer.vertex4(vertexConsumer, matrix4f, f3, f4);
            BeamExplosionRenderer.vertex2(vertexConsumer, matrix4f, f3, f4);
            ++i;
        }
    }

    private static void vertex01(VertexConsumer p_254498_, Matrix4f p_253891_, int p_254278_) {
        p_254498_.m_252986_(p_253891_, 0.0f, 0.0f, 0.0f).m_6122_(79, 206, 245, p_254278_).m_5752_();
    }

    private static void vertex2(VertexConsumer p_253956_, Matrix4f p_254053_, float p_253704_, float p_253701_) {
        p_253956_.m_252986_(p_254053_, -HALF_SQRT_3 * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(79, 206, 245, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer p_253850_, Matrix4f p_254379_, float p_253729_, float p_254030_) {
        p_253850_.m_252986_(p_254379_, HALF_SQRT_3 * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(79, 206, 245, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer p_254184_, Matrix4f p_254082_, float p_253649_, float p_253694_) {
        p_254184_.m_252986_(p_254082_, 0.0f, p_253649_, p_253694_).m_6122_(79, 206, 255, 0).m_5752_();
    }
}

