/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.entity;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKParticles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BeamExplosionEntity
extends Entity {
    public Map<BlockPos, Integer> crackingBlock = new HashMap<BlockPos, Integer>();
    public int restoreCracking = 0;
    public boolean cracking = false;
    public LivingEntity source;

    public BeamExplosionEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.source = null;
    }

    public BeamExplosionEntity(EntityType<?> p_19870_, Level p_19871_, LivingEntity livingEntity) {
        super(p_19870_, p_19871_);
        this.source = livingEntity;
    }

    public void startCracking() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.restoreCracking > 0) {
            --this.restoreCracking;
        }
        if (this.m_9236_().f_46443_) {
            if (this.restoreCracking > 0) {
                if (this.restoreCracking % 5 == 0) {
                    for (BlockPos pos : this.crackingBlock.keySet()) {
                        Minecraft.m_91087_().f_91061_.m_107367_(pos, Direction.UP);
                    }
                }
                if (this.restoreCracking == 1) {
                    for (int i = 0; i < 3; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)BKParticles.ELECTRO_EXPLOSION_PARTICLES.get(), this.m_20185_() + (double)this.f_19796_.m_216339_(-2, 2), this.m_20186_() + (double)this.f_19796_.m_216339_(0, 2), this.m_20189_() + (double)this.f_19796_.m_216339_(-2, 2), 0.0, 0.0, 0.0);
                    }
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, 1.0f, false);
                }
            }
        } else if (this.crackingBlock.isEmpty() && !this.cracking) {
            this.startCracking();
            this.cracking = true;
            this.restoreCracking = 50;
        } else if (this.restoreCracking == 0) {
            float f2 = 4.0f;
            int k1 = Mth.m_14107_((double)(this.m_20185_() - (double)f2 - 1.0));
            int l1 = Mth.m_14107_((double)(this.m_20185_() + (double)f2 + 1.0));
            int i2 = Mth.m_14107_((double)(this.m_20186_() - (double)f2 - 1.0));
            int i1 = Mth.m_14107_((double)(this.m_20186_() + (double)f2 + 1.0));
            int j2 = Mth.m_14107_((double)(this.m_20189_() - (double)f2 - 1.0));
            int j1 = Mth.m_14107_((double)(this.m_20189_() + (double)f2 + 1.0));
            List list = this.m_9236_().m_45933_((Entity)this, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            for (int k2 = 0; k2 < list.size(); ++k2) {
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                Entity entity = (Entity)list.get(k2);
                if (entity.m_6128_() || this.source != null && this.source.m_7307_(entity) || !((d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - this.m_20185_()) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.m_20186_()) * d7 + (d9 = entity.m_20189_() - this.m_20189_()) * d9)) == 0.0) continue;
                double d14 = BeamExplosionEntity.getSeenPercent(vec3, entity);
                double d10 = (1.0 - d12) * d14;
                LivingEntity livingEntity = this.source;
                if (livingEntity instanceof Mob) {
                    Mob mob = (Mob)livingEntity;
                    entity.m_6469_(Util.electricDamageMob((ServerLevel)this.m_9236_(), mob), (float)((int)((d10 * d10 + d10) / 2.0 * 20.0 * (double)f2 + 4.0)));
                    continue;
                }
                livingEntity = this.source;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    entity.m_6469_(Util.electricDamage((ServerLevel)this.m_9236_(), player), (float)((int)((d10 * d10 + d10) / 2.0 * 20.0 * (double)f2 + 4.0)));
                    continue;
                }
                entity.m_6469_(this.m_269291_().m_269036_(null, null), (float)((int)((d10 * d10 + d10) / 2.0 * 20.0 * (double)f2 + 4.0)));
            }
            this.m_146870_();
        }
    }

    public static float getSeenPercent(Vec3 p_46065_, Entity p_46066_) {
        AABB aabb = p_46066_.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        double d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_);
                        double d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9, d10 + d4);
                        if (p_46066_.m_9236_().m_45547_(new ClipContext(vec3, p_46065_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_46066_)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }

    public void m_7822_(byte p_19882_) {
        if (p_19882_ == 4) {
            HashMap<BlockPos, Integer> posSet = new HashMap<BlockPos, Integer>();
            for (BlockPos pos2 : BlockPos.m_121940_((BlockPos)this.m_20097_().m_7918_(2, 1, 2), (BlockPos)this.m_20097_().m_7918_(-2, -1, -2))) {
                float entityHitDistance;
                if (this.m_9236_().m_8055_(pos2).m_60795_() || !((entityHitDistance = Math.max((float)Math.sqrt((pos2.m_123343_() - this.m_20097_().m_123343_()) * (pos2.m_123343_() - this.m_20097_().m_123343_()) + (pos2.m_123341_() - this.m_20097_().m_123341_()) * (pos2.m_123341_() - this.m_20097_().m_123341_())), 0.0f)) <= 2.0f)) continue;
                Random random1 = new Random();
                double distance = Math.ceil(entityHitDistance) + (double)random1.nextFloat(0.0f, 1.0f);
                BlockPos.MutableBlockPos pos1 = pos2.m_122032_();
                boolean canSummon = true;
                for (int i = 0; i < Mth.m_14165_((double)distance); ++i) {
                    if (!canSummon || this.m_9236_().m_8055_(pos1.m_7494_()).m_60795_()) continue;
                    canSummon = false;
                }
                if (!canSummon) continue;
                distance = Mth.m_14036_((float)(2.0f / entityHitDistance), (float)0.0f, (float)1.0f);
                posSet.put(new BlockPos(pos2.m_123341_(), pos2.m_123342_(), pos2.m_123343_()), (int)distance);
            }
            this.crackingBlock = posSet;
            this.restoreCracking = 50;
        }
        super.m_7822_(p_19882_);
    }
}

