/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.entity;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.entity.BoomChicken;
import com.TBK.crc.server.entity.RexChicken;
import com.TBK.crc.server.entity.TeleportEntity;
import com.TBK.crc.server.network.PacketHandler;
import com.TBK.crc.server.network.messager.PacketActionRex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.NetworkHooks;

public class RexPart<T extends RexChicken>
extends PartEntity<T> {
    public static final EntityDataAccessor<Boolean> BREAKING = SynchedEntityData.m_135353_(RexPart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final T parentMob;
    public final String name;
    private EntityDimensions size;
    public boolean isTower;
    public AnimationState prepareShoot = new AnimationState();
    public AnimationState towerShoot = new AnimationState();
    public AnimationState towerBreak = new AnimationState();
    public int hits = 0;
    public int prepareShootTimer = 0;
    public int nextShootTimer = 0;
    public int maxTimer = 0;
    public int explosionTimer = 0;

    public RexPart(T parent, String name, float sizeX, float sizeZ) {
        super(parent);
        this.parentMob = parent;
        this.name = name;
        this.size = EntityDimensions.m_20395_((float)sizeX, (float)sizeZ);
        this.setSize(this.size);
        this.isTower = false;
    }

    public RexPart(T parent, String name, float sizeX, float sizeZ, boolean isTower) {
        super(parent);
        this.parentMob = parent;
        this.name = name;
        this.size = EntityDimensions.m_20395_((float)sizeX, (float)sizeZ);
        this.setSize(this.size);
        this.isTower = isTower;
        if (isTower) {
            this.hits = 5;
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.isTower && this.parentMob.m_5448_() != null && !this.isBreaking() && this.m_9236_().m_45976_(BoomChicken.class, this.parentMob.m_20191_().m_82400_(100.0)).size() < 6) {
                if (this.prepareShootTimer > 0) {
                    --this.prepareShootTimer;
                    if (this.prepareShootTimer <= 0) {
                        this.shoot();
                        this.launchBoomChicken(this.parentMob.m_5448_(), this.parentMob.m_5448_().m_20183_());
                    }
                }
                if (this.nextShootTimer <= this.maxTimer) {
                    ++this.nextShootTimer;
                    if (this.nextShootTimer > this.maxTimer) {
                        this.startShoot();
                    }
                }
            }
        } else {
            if (this.isTower) {
                this.towerBreak.m_246184_(this.isBreaking(), ((RexChicken)((Object)this.parentMob)).f_19797_);
            }
            if (this.explosionTimer > 0) {
                float f = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
                float f1 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
                float f2 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
                --this.explosionTimer;
            }
        }
    }

    protected void setSize(EntityDimensions size) {
        this.size = size;
        this.m_6210_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BREAKING, (Object)false);
    }

    protected void m_7378_(CompoundTag p_31025_) {
        this.setBreaking(p_31025_.m_128471_("isBreaking"));
    }

    protected void m_7380_(CompoundTag p_31028_) {
        p_31028_.m_128379_("isBreaking", this.isBreaking());
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource p_31020_, float p_31021_) {
        if (!((RexChicken)((Object)this.parentMob)).m_7090_()) {
            if (this.isTower) {
                --this.hits;
                if (this.hits <= 0) {
                    this.destroy();
                }
            } else if (((RexChicken)((Object)this.parentMob)).stunnedTick > 0 && this.name.equals("head")) {
                float healtCurrent = this.parentMob.m_21223_() - 20.0f;
                if (healtCurrent <= 0.0f) {
                    this.parentMob.m_21153_(0.0f);
                    ((RexChicken)((Object)this.parentMob)).m_6667_(p_31020_);
                    return true;
                }
                this.parentMob.m_21153_(healtCurrent);
                ((RexChicken)((Object)this.parentMob)).regenerationShieldTimer = 0;
                ((RexChicken)((Object)this.parentMob)).setShieldAmount(50);
                ((RexChicken)((Object)this.parentMob)).stunnedTick = 0;
                if (!this.m_9236_().f_46443_) {
                    ((RexChicken)((Object)this.parentMob)).recoveryTimer = 21;
                    this.parentMob.m_9236_().m_7605_(this.parentMob, (byte)17);
                    this.callReinforcement(p_31020_.m_7639_());
                }
                return true;
            }
        }
        return ((RexChicken)((Object)this.parentMob)).m_6469_(p_31020_, p_31021_);
    }

    public void callReinforcement(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            for (int i = 0; i < 3; ++i) {
                TeleportEntity teleport = new TeleportEntity(this.m_9236_(), (EntityType)BKEntityType.DRONE_CHICKEN.get(), Util.findCaveSurfaceNearHeight(entity, 3, this.f_19796_), target, true);
                this.m_9236_().m_7967_((Entity)teleport);
            }
        }
    }

    public boolean m_7306_(Entity p_31031_) {
        return this == p_31031_ || this.parentMob.m_7306_(p_31031_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void shoot() {
        if (!this.m_9236_().f_46443_) {
            PacketHandler.sendToAllTracking(new PacketActionRex(this.parentMob.m_19879_(), this.m_19879_(), 4), this.parentMob);
            this.nextShootTimer = 0;
            this.maxTimer = 100 + this.m_9236_().f_46441_.m_188503_(200);
            this.prepareShootTimer = 0;
        }
    }

    public void startShoot() {
        if (!this.m_9236_().f_46443_) {
            this.prepareShootTimer = 21;
            PacketHandler.sendToAllTracking(new PacketActionRex(this.parentMob.m_19879_(), this.m_19879_(), 8), this.parentMob);
        }
    }

    public void destroy() {
        if (!this.m_9236_().f_46443_) {
            this.setBreaking(true);
            ((RexChicken)((Object)this.parentMob)).stunnedTick = 300;
            this.parentMob.m_9236_().m_7605_(this.parentMob, (byte)12);
            PacketHandler.sendToAllTracking(new PacketActionRex(this.parentMob.m_19879_(), this.m_19879_(), 12), this.parentMob);
        }
    }

    public void launchBoomChicken(LivingEntity living, BlockPos targetPos) {
        BoomChicken missile = new BoomChicken(this.m_9236_());
        missile.m_6710_(living);
        missile.setIsLaunch(true);
        missile.m_6034_(this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_());
        missile.calculateRotPosition(missile.m_20183_(), targetPos);
        missile.m_20256_(missile.calculateJumpVelocity(missile.m_20183_(), living.m_20183_()));
        this.m_9236_().m_7967_((Entity)missile);
    }

    public boolean isBreaking() {
        return (Boolean)this.f_19804_.m_135370_(BREAKING);
    }

    public void setBreaking(boolean isBreaking) {
        this.f_19804_.m_135381_(BREAKING, (Object)isBreaking);
    }

    public void m_7822_(byte p_19882_) {
        if (p_19882_ == 4) {
            this.prepareShoot.m_216973_();
            this.towerShoot.m_216977_(((RexChicken)((Object)this.parentMob)).f_19797_);
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BKSounds.REX_CANNON_SHOOT.get(), SoundSource.HOSTILE, 3.0f, 1.0f, false);
        } else if (p_19882_ == 8) {
            this.towerShoot.m_216973_();
            this.prepareShoot.m_216977_(((RexChicken)((Object)this.parentMob)).f_19797_);
        } else if (p_19882_ == 12) {
            this.prepareShoot.m_216973_();
            this.towerShoot.m_216973_();
            this.towerBreak.m_216977_(((RexChicken)((Object)this.parentMob)).f_19797_);
            this.setBreaking(true);
            this.explosionTimer = 10;
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 4.0f, 1.0f, false);
        }
        super.m_7822_(p_19882_);
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        return this.size;
    }
}

