/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.network.messager;

import com.TBK.crc.CRC;
import com.TBK.crc.common.Util;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.manager.UpgradeInstance;
import com.TBK.crc.server.upgrade.Upgrade;
import com.TBK.crc.server.upgrade.Upgrades;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncSkill
implements Packet<PacketListener> {
    private final Map<Integer, UpgradeInstance> upgradesPassive;
    private final Map<Integer, UpgradeInstance> upgrades;

    public PacketSyncSkill(FriendlyByteBuf buf) {
        this.upgrades = buf.m_236847_(PacketSyncSkill::readUpgradeIndex, PacketSyncSkill::readUpgradeInstance);
        this.upgradesPassive = buf.m_236847_(PacketSyncSkill::readUpgradeIndex, PacketSyncSkill::readUpgradeInstance);
    }

    public PacketSyncSkill(Map<Integer, UpgradeInstance> upgrade, Map<Integer, UpgradeInstance> passives) {
        this.upgrades = upgrade;
        this.upgradesPassive = passives;
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.m_236831_(this.upgrades, PacketSyncSkill::writePowerId, PacketSyncSkill::writeCoolDownInstance);
        buf.m_236831_(this.upgradesPassive, PacketSyncSkill::writePowerId, PacketSyncSkill::writeCoolDownInstance);
    }

    public static Integer readUpgradeIndex(FriendlyByteBuf buffer) {
        return buffer.readInt();
    }

    public static UpgradeInstance readUpgradeInstance(FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        Upgrade upgrade = Util.getTypeSkillForName(name);
        upgrade.refinements = buffer.m_236845_(FriendlyByteBuf::m_130277_);
        return new UpgradeInstance(upgrade, 0);
    }

    public static void writePowerId(FriendlyByteBuf buf, Integer powerId) {
        buf.writeInt(powerId.intValue());
    }

    public static void writeCoolDownInstance(FriendlyByteBuf buf, UpgradeInstance cooldownInstance) {
        buf.m_130070_(cooldownInstance.getUpgrade().name);
        buf.m_236828_(cooldownInstance.getUpgrade().refinements, FriendlyByteBuf::m_130070_);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(this::sync);
        supplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sync() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        MultiArmCapability cap = MultiArmCapability.get((Player)player);
        Upgrades upgrades = cap.skills;
        Upgrades passives = cap.passives;
        upgrades.upgrades.clear();
        passives.upgrades.clear();
        this.upgrades.forEach((k, v) -> upgrades.addMultiArmSkillAbstracts((int)k, v.getUpgrade()));
        this.upgradesPassive.forEach((k, v) -> passives.addMultiArmSkillAbstracts((int)k, v.getUpgrade()));
        for (int i = 0; i < 6; ++i) {
            CRC.LOGGER.debug("skill :" + cap.skills.get((int)i).name + " passive :" + cap.passives.get((int)i).name);
        }
    }

    public void m_5797_(PacketListener p_131342_) {
    }
}

