/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.upgrade;

import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.entity.GanchoEntity;
import com.TBK.crc.server.upgrade.Upgrade;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GanchoArm
extends Upgrade {
    public static final int MAX_RANGE = 22;
    public boolean hasGancho = true;
    public int ganchoId = -1;
    public float largoActual = 0.0f;
    public boolean atraction = false;

    public GanchoArm() {
        super("gancho_arm", 100, true, false);
    }

    @Override
    public void tick(MultiArmCapability multiArmCapability) {
        super.tick(multiArmCapability);
        Entity gancho = multiArmCapability.getPlayer().m_9236_().m_6815_(this.ganchoId);
        if (gancho instanceof GanchoEntity) {
            GanchoEntity ganchoEntity = (GanchoEntity)gancho;
            Player player = multiArmCapability.getPlayer();
            if (ganchoEntity.hit && gancho.m_20270_((Entity)player) > 33.0f) {
                multiArmCapability.getPlayer().m_9236_().m_245747_(multiArmCapability.getPlayer().m_20183_(), this.getStopSound(), SoundSource.PLAYERS, this.getVolumeStartAbility(), 1.0f, false);
                ganchoEntity.isBack = true;
                ganchoEntity.hit = false;
                ganchoEntity.m_9236_().m_7605_(gancho, (byte)5);
            } else if (!ganchoEntity.isBack && gancho.m_20270_((Entity)player) > 22.0f) {
                multiArmCapability.getPlayer().m_9236_().m_245747_(multiArmCapability.getPlayer().m_20183_(), this.getStopSound(), SoundSource.PLAYERS, this.getVolumeStartAbility(), 1.0f, false);
                ganchoEntity.isBack = true;
                ganchoEntity.m_9236_().m_7605_(gancho, (byte)5);
            }
        }
    }

    @Override
    public void swapArm(MultiArmCapability multiArmCapability, Upgrade otherArm) {
        this.hasGancho = true;
        if (this.ganchoId != -1) {
            Entity gancho = multiArmCapability.getPlayer().m_9236_().m_6815_(this.ganchoId);
            if (gancho instanceof GanchoEntity) {
                gancho.m_146870_();
            }
            this.ganchoId = -1;
        }
    }

    @Override
    public SoundEvent getStartSound() {
        return (SoundEvent)BKSounds.MULTIARM_HARPOON_SHOOT.get();
    }

    @Override
    public SoundEvent getStopSound() {
        return (SoundEvent)BKSounds.MULTIARM_HARPOON_COMEBACK.get();
    }

    @Override
    public void stopAbility(MultiArmCapability multiArmCapability) {
    }

    @Override
    public void startAbility(MultiArmCapability multiArmCapability) {
        if (this.hasGancho) {
            super.startAbility(multiArmCapability);
            GanchoEntity gancho = new GanchoEntity(multiArmCapability.getPlayer().m_9236_(), (Entity)multiArmCapability.getPlayer());
            gancho.m_6034_(multiArmCapability.getPlayer().m_20185_(), multiArmCapability.getPlayer().m_20188_() - (double)0.1f, multiArmCapability.getPlayer().m_20189_());
            gancho.m_37251_((Entity)multiArmCapability.getPlayer(), multiArmCapability.getPlayer().m_146909_(), multiArmCapability.getPlayer().f_20885_, 0.0f, 3.0f, 1.0f);
            multiArmCapability.getPlayer().m_9236_().m_7967_((Entity)gancho);
            this.hasGancho = false;
            this.ganchoId = gancho.m_19879_();
            this.largoActual = 0.0f;
            this.atraction = false;
        } else {
            multiArmCapability.getPlayer().f_19789_ = 0.0f;
            Entity gancho = multiArmCapability.getPlayer().m_9236_().m_6815_(this.ganchoId);
            if (gancho instanceof GanchoEntity) {
                GanchoEntity ganchoEntity = (GanchoEntity)gancho;
                if (!ganchoEntity.isBack) {
                    if (!multiArmCapability.getPlayer().m_6144_() && ganchoEntity.hit) {
                        Vec3 direction = gancho.m_20182_().m_82546_(multiArmCapability.getPlayer().m_20182_());
                        Vec3 pushDirection = direction.m_82541_().m_82490_(3.0 * Math.min(direction.m_82553_() / 6.0, 1.0));
                        multiArmCapability.getPlayer().m_20334_(pushDirection.f_82479_, Math.min(pushDirection.f_82480_, 1.5), pushDirection.f_82481_);
                        multiArmCapability.getPlayer().f_19864_ = true;
                    }
                    ganchoEntity.isBack = true;
                    ganchoEntity.m_9236_().m_7605_(gancho, (byte)5);
                }
            } else if (multiArmCapability.catchEntity != null) {
                Vec3 direction = multiArmCapability.getPlayer().m_20182_().m_82546_(multiArmCapability.getPlayer().m_20182_());
                Vec3 pushDirection = direction.m_82541_().m_82490_(3.0 * Math.min(direction.m_82553_() / 6.0, 1.0));
                multiArmCapability.catchEntity.m_20334_(pushDirection.f_82479_, Math.min(pushDirection.f_82480_, 1.5), pushDirection.f_82481_);
                multiArmCapability.catchEntity.f_19864_ = true;
                GanchoEntity gancho1 = new GanchoEntity(multiArmCapability.getPlayer().m_9236_(), (Entity)multiArmCapability.getPlayer(), true);
                gancho1.m_6034_(multiArmCapability.catchEntity.m_20185_(), multiArmCapability.catchEntity.m_20188_() - (double)0.1f, multiArmCapability.catchEntity.m_20189_());
                multiArmCapability.getPlayer().m_9236_().m_7967_((Entity)gancho1);
            }
            multiArmCapability.catchEntity = null;
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        super.save(nbt);
        nbt.m_128379_("has_gancho", this.hasGancho);
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.hasGancho = nbt.m_128471_("has_gancho");
    }
}

