/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.common;

import com.TBK.crc.common.registry.BKDimension;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKItems;
import com.TBK.crc.common.registry.BKParticles;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.entity.ElectroExplosionEntity;
import com.TBK.crc.server.entity.RexChicken;
import com.TBK.crc.server.manager.UpgradeInstance;
import com.TBK.crc.server.upgrade.CannonArm;
import com.TBK.crc.server.upgrade.ClawsArm;
import com.TBK.crc.server.upgrade.CoilFeet;
import com.TBK.crc.server.upgrade.ContraAttack;
import com.TBK.crc.server.upgrade.GanchoArm;
import com.TBK.crc.server.upgrade.HackerEye;
import com.TBK.crc.server.upgrade.HeartReflex;
import com.TBK.crc.server.upgrade.KneesHard;
import com.TBK.crc.server.upgrade.KneesSpiked;
import com.TBK.crc.server.upgrade.NightEye;
import com.TBK.crc.server.upgrade.Upgrade;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class Util {
    public static Map<String, Supplier<Upgrade>> upgrades = new HashMap<String, Supplier<Upgrade>>();
    public static ResourceKey<DamageType> ELECTRIC_DAMAGE_MOB = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("crc", "electric_damage_mob"));
    public static ResourceKey<DamageType> ELECTRIC_DAMAGE_PLAYER = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("crc", "electric_damage_player"));

    public static BlockPos findCaveSurfaceNearHeight(Entity entity, int radius, RandomSource random) {
        Level level = entity.m_9236_();
        BlockPos origin = entity.m_20183_();
        int targetY = origin.m_123342_();
        BlockPos closestPos = origin;
        int closestDifference = Integer.MAX_VALUE;
        for (int i = 0; i < 100; ++i) {
            int diff;
            int dz;
            int dy;
            int dx = random.m_216339_(-radius, radius + 1);
            BlockPos pos = origin.m_7918_(dx, dy = random.m_216339_(-radius, radius + 1), dz = random.m_216339_(-radius, radius + 1));
            if (!level.m_46859_(pos) || !level.m_46859_(pos.m_7494_()) || !level.m_46859_(pos.m_7495_()) || (diff = Math.abs(pos.m_123342_() - targetY)) >= closestDifference) continue;
            closestDifference = diff;
            closestPos = pos;
            if (diff != 0) continue;
            return closestPos;
        }
        return closestPos;
    }

    public static Map<Integer, UpgradeInstance> getMapEmpty() {
        HashMap<Integer, UpgradeInstance> map = new HashMap<Integer, UpgradeInstance>();
        map.put(0, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(1, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(2, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(3, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(4, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(5, new UpgradeInstance(Upgrade.NONE, 0));
        return map;
    }

    public static void spawnChargedParticle(Vec3 entity) {
        Random random = new Random();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            for (int i = 0; i < 2; ++i) {
                double box = 0.75;
                double d0 = random.nextDouble(-box, box);
                double d1 = random.nextDouble(0.0, 0.75);
                double d2 = random.nextDouble(-box, box);
                double xp = entity.f_82479_ + d0;
                double yp = entity.f_82480_ + d1;
                double zp = entity.f_82481_ + d2;
                Particle particle = mc.f_91061_.m_107370_((ParticleOptions)BKParticles.LIGHTNING_SPARK_PARTICLES.get(), xp, yp, zp, -d0 * (double)0.1f, -d1 * (double)0.1f, -d2 * (double)0.1f);
                if (particle == null) continue;
                particle.m_6569_(0.5f);
            }
        }
    }

    public static Map<Integer, UpgradeInstance> getMapArmEmpty() {
        HashMap<Integer, UpgradeInstance> map = new HashMap<Integer, UpgradeInstance>();
        map.put(0, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(1, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(2, new UpgradeInstance(Upgrade.NONE, 0));
        map.put(3, new UpgradeInstance(Upgrade.NONE, 0));
        return map;
    }

    public static boolean hasMultiArm(MultiArmCapability cap) {
        return !cap.implantStore.getImplant(0).m_41619_();
    }

    public static boolean hasSyntharm(MultiArmCapability cap) {
        return cap.implantStore.getImplant(0).m_150930_((Item)BKItems.CYBORG_SYNTHARM.get());
    }

    public static DamageSource electricDamage(ServerLevel level, Player player) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ELECTRIC_DAMAGE_PLAYER), (Entity)player);
    }

    public static DamageSource electricDamageMob(ServerLevel level, @NotNull Mob mob) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ELECTRIC_DAMAGE_MOB), (Entity)mob);
    }

    public static float getElapsedSeconds(AnimationDefinition p_232317_, long p_232318_) {
        float f = (float)p_232318_ / 1000.0f;
        return p_232317_.f_232256_() ? f % p_232317_.f_232255_() : f;
    }

    public static void refreshHackingChest(Player player, Level level) {
        MultiArmCapability cap = MultiArmCapability.get(player);
        if (cap != null && cap.passives.hasMultiArmSkillAbstract("hacker_eye")) {
            HackerEye eye = (HackerEye)cap.passives.getForName("hacker_eye");
            eye.refreshTarget(player, level);
        }
    }

    public static boolean isHackingChest(BlockPos pos) {
        Minecraft mc = Minecraft.m_91087_();
        MultiArmCapability cap = MultiArmCapability.get((Player)mc.f_91074_);
        if (cap != null && cap.passives.hasMultiArmSkillAbstract("hacker_eye")) {
            HackerEye eye = (HackerEye)cap.passives.getForName("hacker_eye");
            return eye.hackingBlock.contains(pos);
        }
        return false;
    }

    public static void initUpgrades() {
        upgrades.put("gancho_arm", GanchoArm::new);
        upgrades.put("cannon_arm", CannonArm::new);
        upgrades.put("claws_arm", ClawsArm::new);
        upgrades.put("heart_reflex", HeartReflex::new);
        upgrades.put("contra_attack", ContraAttack::new);
        upgrades.put("night_eye", NightEye::new);
        upgrades.put("hacker_eye", HackerEye::new);
        upgrades.put("coil_feet", CoilFeet::new);
        upgrades.put("knees_spiked", KneesSpiked::new);
        upgrades.put("knees_hard", KneesHard::new);
    }

    public static Upgrade getTypeSkillForName(String name) {
        if (upgrades.containsKey(name)) {
            return upgrades.get(name).get();
        }
        return Upgrade.NONE;
    }

    public static int getIndexForName(String name) {
        switch (name) {
            case "gancho_arm": {
                return 2;
            }
            case "cannon_arm": {
                return 1;
            }
            case "claws_arm": {
                return 0;
            }
        }
        return -1;
    }

    public static boolean isSafePosition(Level world, Vec3 pos) {
        BlockPos blockPos = BlockPos.m_274446_((Position)pos);
        BlockState head = world.m_8055_(blockPos.m_6630_(2));
        boolean headSafe = head.m_60795_() && head.m_60819_().m_76178_();
        BlockState feet = world.m_8055_(blockPos.m_7494_());
        boolean feetSafe = feet.m_60795_() && feet.m_60819_().m_76178_();
        return headSafe && feetSafe;
    }

    public static boolean isInFuture(LivingEntity entity) {
        return Util.isInDimension(entity, BKDimension.THE_FUTURE_LEVEL);
    }

    public static boolean isInDimension(LivingEntity entity, ResourceKey<Level> key) {
        return key.equals((Object)entity.m_9236_().m_46472_());
    }

    public static ElectroExplosionEntity createExplosion(Entity entity, Level level, BlockPos end, float radius) {
        ElectroExplosionEntity explosion = new ElectroExplosionEntity(level, entity, end.m_123341_(), end.m_123342_(), end.m_123343_(), radius, false);
        if (ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(false);
        return explosion;
    }

    public static List<? extends RexChicken> getRexChickens(ServerLevel level) {
        return level.m_143280_((EntityTypeTest)BKEntityType.REX_CHICKEN.get(), LivingEntity::m_6084_);
    }
}

