/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.entity;

import com.TBK.crc.server.entity.RobotChicken;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PunchChicken
extends RobotChicken {
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(PunchChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idle = new AnimationState();
    public AnimationState attack = new AnimationState();
    public int idleAnimationTimeout = 0;
    public int attackTimer = 0;

    public PunchChicken(EntityType<? extends RobotChicken> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.15).m_22268_(Attributes.f_22277_, 55.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 15.0).m_22265_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(this, 1.1, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isAttacking()) {
            --this.attackTimer;
            if (this.attackTimer <= 0) {
                if (this.m_5448_() != null) {
                    this.m_7327_((Entity)this.m_5448_());
                }
                this.setAttacking(false);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.attack.m_216973_();
            this.idleAnimationTimeout = 20;
            this.idle.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean flag) {
        this.f_19804_.m_135381_(ATTACKING, (Object)flag);
        this.attackTimer = flag ? 10 : 0;
    }

    public void playAttack() {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.idle.m_216973_();
            this.attack.m_216977_(this.f_19797_);
            this.idleAnimationTimeout = 10;
        }
        super.m_7822_(p_21375_);
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            super(p_25552_, p_25553_, p_25554_);
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.m_25565_() <= 0 && PunchChicken.this.attackTimer <= 0) {
                this.m_25563_();
                this.f_25540_.m_21573_().m_26573_();
            }
        }

        protected void m_25563_() {
            super.m_25563_();
            PunchChicken.this.setAttacking(true);
            if (!PunchChicken.this.m_9236_().f_46443_) {
                PunchChicken.this.playAttack();
            }
        }
    }
}

