/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.network.messager;

import com.TBK.crc.common.menu.CyborgTableMenu;
import com.TBK.crc.common.registry.BKParticles;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.entity.PortalEntity;
import com.TBK.crc.server.manager.UpgradeInstance;
import com.TBK.crc.server.upgrade.PassivePart;
import com.TBK.crc.server.upgrade.Upgrade;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketHandlerPowers
implements Packet<PacketListener> {
    private final int id;
    private final Entity newEntity;
    private final Entity oldEntity;

    public PacketHandlerPowers(FriendlyByteBuf buf) {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91073_ != null);
        this.id = buf.readInt();
        this.newEntity = mc.f_91073_.m_6815_(buf.readInt());
        this.oldEntity = mc.f_91073_.m_6815_(buf.readInt());
    }

    public PacketHandlerPowers(int id, Entity entity, Player player) {
        this.id = id;
        this.newEntity = entity;
        this.oldEntity = player;
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.newEntity != null ? this.newEntity.m_19879_() : -1);
        buf.writeInt(this.oldEntity != null ? this.oldEntity.m_19879_() : -1);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                this.handler();
            } else {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                MultiArmCapability cap = MultiArmCapability.get((Player)player);
                if (cap != null) {
                    switch (this.id) {
                        case 3: {
                            cap.clearAbilityStore();
                            break;
                        }
                        case 4: {
                            cap.clearForUpgradeStore();
                            break;
                        }
                        case 5: {
                            AbstractContainerMenu menu = ((NetworkEvent.Context)context.get()).getSender().f_36096_;
                            if (!(menu instanceof CyborgTableMenu)) break;
                            cap.dirty = true;
                            break;
                        }
                        case 6: {
                            cap.chickenEnemy = false;
                            cap.warningLevel = 0;
                            cap.wave = 0;
                            PortalEntity.onTeleport((Entity)player);
                        }
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handler() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        MultiArmCapability cap = MultiArmCapability.get((Player)player);
        if (cap != null) {
            switch (this.id) {
                case 0: {
                    this.start(cap, (Player)player);
                    break;
                }
                case 1: {
                    cap.catchEntity = this.newEntity;
                    break;
                }
                case 2: {
                    if (cap.getLastUsingSkill() != cap.getSelectSkill()) break;
                    cap.stopSkill(cap.getSelectSkill());
                    break;
                }
                case 5: {
                    for (UpgradeInstance instance : cap.getPassives().getSkills()) {
                        ((PassivePart)instance.getUpgrade()).onDie(cap, this.newEntity);
                    }
                    break;
                }
                case 6: {
                    Minecraft.m_91087_().f_91061_.m_107332_(this.newEntity, (ParticleOptions)BKParticles.LIGHTNING_SPARK_PARTICLES.get(), 5);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void start(MultiArmCapability cap, Player player) {
        if (cap.canUseSkill(cap.getSelectSkill())) {
            if (cap.getSelectSkill().isCasting) {
                cap.startCasting(cap.getSelectSkill(), player);
            } else if (cap.getSelectSkill().isCanReActive()) {
                Upgrade power = cap.getSelectSkill();
                cap.setLastUsingSkill(cap.getSelectSkill());
                cap.handledSkill(power);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stop(MultiArmCapability cap, Player player) {
        cap.stopCasting(player);
    }

    public void m_5797_(PacketListener p_131342_) {
    }
}

