/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.network.messager;

import com.TBK.crc.common.menu.ImplantMenu;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.upgrade.Upgrade;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketKeySync
implements Packet<PacketListener> {
    private final int key;
    private final int action;
    private final int idTarget;

    public PacketKeySync(FriendlyByteBuf buf) {
        this.key = buf.readInt();
        this.action = buf.readInt();
        this.idTarget = buf.readInt();
    }

    public PacketKeySync(int key, int action, int idTarget) {
        this.key = key;
        this.action = action;
        this.idTarget = idTarget;
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeInt(this.key);
        buf.writeInt(this.action);
        buf.writeInt(this.idTarget);
    }

    public void m_5797_(PacketListener p_131342_) {
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> this.handlerAnim(context));
        context.get().setPacketHandled(true);
    }

    private void handlerAnim(Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer player = contextSupplier.get().getSender();
        MultiArmCapability cap = MultiArmCapability.get((Player)player);
        assert (cap != null);
        switch (this.key) {
            case 82: {
                if (this.action == 0) {
                    cap.stopCasting((Player)player);
                }
                if (this.action != 1 || cap.cooldownUse > 0) break;
                cap.startCasting((Player)player);
                break;
            }
            case 18: {
                Upgrade skill = cap.getSelectSkill();
                cap.stopCasting((Player)player);
                skill.swapArm(cap, cap.getSkillForHotBar(this.action));
                cap.setPosSelectUpgrade(this.action);
                cap.getSelectSkill().swapArm(cap, skill);
                break;
            }
            case 86: {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new ImplantMenu(id, inventory, cap.implantStore.store), (Component)Component.m_237113_((String)"")), (BlockPos)player.m_20183_());
            }
        }
    }
}

