/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.network.messager;

import com.TBK.crc.server.capability.MultiArmCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncPlayerData
implements Packet<PacketListener> {
    public CompoundTag data;
    public boolean wasDeath;
    public int id;

    public PacketSyncPlayerData(CompoundTag data, boolean wasDeath, int id) {
        this.data = data;
        this.wasDeath = wasDeath;
        this.id = id;
    }

    public void m_5779_(FriendlyByteBuf buf) {
        buf.m_130079_(this.data);
        buf.writeBoolean(this.wasDeath);
        buf.writeInt(this.id);
    }

    public PacketSyncPlayerData(FriendlyByteBuf buf) {
        this.data = buf.m_130260_();
        this.wasDeath = buf.readBoolean();
        this.id = buf.readInt();
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> this.handlerAnim(context));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handlerAnim(Supplier<NetworkEvent.Context> context) {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91073_ != null && mc.f_91074_ != null);
        Entity entity = mc.f_91073_.m_6815_(this.id);
        assert (entity instanceof Player);
        Player player = (Player)entity;
        MultiArmCapability cap = MultiArmCapability.get(player);
        if (cap != null) {
            if (this.wasDeath) {
                cap.copyNbt(this.data);
            } else {
                cap.loadWarningLevel(this.data);
            }
        }
    }

    public void m_5797_(PacketListener p_131342_) {
    }
}

