/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.upgrade;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.entity.ElectroProjectile;
import com.TBK.crc.server.upgrade.Upgrade;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CannonArm
extends Upgrade {
    public int stopAiming = 0;
    public int chargeTime = 0;
    public boolean charge = false;
    public boolean canRechargeEnergy = true;

    public CannonArm() {
        super("cannon_arm", 100, false, true);
    }

    @Override
    public void swapArm(MultiArmCapability multiArmCapability, Upgrade otherArm) {
        this.charge = false;
        this.chargeTime = 0;
        this.stopAiming = 0;
        multiArmCapability.stopAimingAnim = 0;
        multiArmCapability.stopAimingAnim0 = 0;
        multiArmCapability.levelCharge = 0;
    }

    @Override
    public void tick(MultiArmCapability multiArmCapability) {
        super.tick(multiArmCapability);
        if (this.charge) {
            Player player = multiArmCapability.getPlayer();
            Level level = player.m_9236_();
            this.stopAiming = 20;
            int necessaryEnergy = 2 + multiArmCapability.levelCharge;
            if (this.chargeTime < 51) {
                ++this.chargeTime;
                if (multiArmCapability.levelCharge > 0 && (this.chargeTime - 10) % 20 == 0 && multiArmCapability.energy >= necessaryEnergy) {
                    multiArmCapability.levelCharge = Math.min(multiArmCapability.levelCharge + 1, 3);
                    level.m_5594_(player, player.m_20183_(), (SoundEvent)BKSounds.MULTIARM_CANNON_CHARGING.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
                }
                if (this.chargeTime > 10) {
                    player.m_20256_(player.m_20184_().m_82542_((double)0.05f, 1.0, (double)0.05f));
                    if (multiArmCapability.levelCharge == 0 && multiArmCapability.energy >= necessaryEnergy) {
                        level.m_5594_(player, player.m_20183_(), (SoundEvent)BKSounds.MULTIARM_CANNON_CHARGING.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
                        multiArmCapability.levelCharge = 1;
                    }
                }
            }
            if (multiArmCapability.levelCharge > 0 && player.m_9236_().f_46443_) {
                Util.spawnChargedParticle(this.getPos(player.m_146892_(), player));
            }
        } else {
            if (this.stopAiming > 0) {
                --this.stopAiming;
                if (this.stopAiming == 0) {
                    multiArmCapability.pose = MultiArmCapability.SkillPose.STOP_AIMING;
                    multiArmCapability.stopAimingAnim = 5;
                    multiArmCapability.stopAimingAnim0 = 5;
                }
            } else {
                this.canRechargeEnergy = true;
            }
            if (this.canRechargeEnergy && multiArmCapability.getPlayer().f_19797_ % 5 == 0) {
                multiArmCapability.energy = Math.min(multiArmCapability.energy + 1, 10);
            }
        }
    }

    @Override
    public SoundEvent getStopSound() {
        return this.chargeTime > 10 ? (SoundEvent)BKSounds.MULTIARM_CANNON_CHARGED_SHOT.get() : (SoundEvent)BKSounds.MULTIARM_CANNON_NORMAL_SHOT.get();
    }

    @Override
    public void startAbility(MultiArmCapability multiArmCapability) {
        if (this.canActiveAbility(multiArmCapability) && !this.charge) {
            super.startAbility(multiArmCapability);
            multiArmCapability.pose = MultiArmCapability.SkillPose.CHARGE_CANNON;
            this.charge = true;
            this.canRechargeEnergy = false;
        }
    }

    @Override
    public boolean canActiveAbility(MultiArmCapability multiArmCapability) {
        return multiArmCapability.energy > 0;
    }

    @Override
    public void stopAbility(MultiArmCapability multiArmCapability) {
        if (this.charge) {
            super.stopAbility(multiArmCapability);
            multiArmCapability.timeShoot = 10;
            multiArmCapability.timeShoot0 = 10;
            this.stopAiming = 20;
            this.charge = false;
            multiArmCapability.energy = Math.max(multiArmCapability.energy - (1 + multiArmCapability.levelCharge), 0);
            ElectroProjectile orb = new ElectroProjectile(multiArmCapability.getPlayer().m_9236_(), (LivingEntity)multiArmCapability.getPlayer(), this.chargeTime > 10 ? 10 + 20 * multiArmCapability.levelCharge - 1 : 0);
            orb.m_37251_((Entity)multiArmCapability.getPlayer(), multiArmCapability.getPlayer().m_146909_(), multiArmCapability.getPlayer().m_146908_(), 0.0f, 1.0f, 1.0f);
            orb.m_146884_(this.getPos(multiArmCapability.getPlayer().m_146892_(), multiArmCapability.getPlayer()));
            multiArmCapability.getPlayer().m_9236_().m_7967_((Entity)orb);
            multiArmCapability.levelCharge = 0;
            this.chargeTime = 0;
        }
    }

    public Vec3 getPos(Vec3 initialVec, Player player) {
        float f1 = player.m_6080_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14031_((float)f1);
        float f3 = Mth.m_14089_((float)f1);
        float f5 = player.m_5686_(1.0f);
        float f4 = (float)((double)(f5 + 90.0f) * 0.01745329238474369);
        if (f5 < 0.0f) {
            f5 = -f5;
        }
        float f6 = Mth.m_14179_((float)(f5 / 90.0f), (float)1.5f, (float)0.0f);
        f4 = Mth.m_14089_((float)f4);
        return initialVec.m_82520_((double)(-(f2 *= f6)), (double)(f4 - 0.35f), (double)(f3 *= f6));
    }
}

