/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.upgrade;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.entity.ResidualEntity;
import com.TBK.crc.server.upgrade.Upgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ClawsArm
extends Upgrade {
    public boolean dash = false;
    public boolean charge = false;
    public int dashTime = 0;

    public ClawsArm() {
        super("claws_arm", 175, false, true);
    }

    @Override
    public boolean canActiveAbility(MultiArmCapability multiArmCapability) {
        return !multiArmCapability.getPlayer().m_36335_().m_41519_(multiArmCapability.implantStore.getArmForSkill(this).m_41720_());
    }

    @Override
    public void swapArm(MultiArmCapability multiArmCapability, Upgrade otherArm) {
        this.charge = false;
        this.dash = false;
        this.dashTime = 0;
    }

    @Override
    public void tick(MultiArmCapability multiArmCapability) {
        super.tick(multiArmCapability);
        Player player = multiArmCapability.getPlayer();
        if (this.charge) {
            player.m_20334_(player.m_20184_().f_82479_ * (double)0.05f, player.m_20184_().f_82480_, player.m_20184_().f_82481_ * (double)0.05f);
        }
        if (this.dash) {
            player.f_19789_ = 0.0f;
            player.m_20256_(player.m_20184_().m_82542_(1.0, (double)0.89f, 1.0));
            if (!player.m_9236_().f_46443_) {
                for (Entity living : player.m_9236_().m_6443_(Entity.class, player.m_20191_().m_82400_(1.5), e -> e != player)) {
                    living.f_19802_ = 0;
                    living.m_6469_(Util.electricDamage((ServerLevel)player.m_9236_(), player), 5.0f);
                    living.f_19802_ = 0;
                }
            }
            if (this.dashTime > 0) {
                --this.dashTime;
                if (this.dashTime < 4 && !player.m_9236_().f_46443_) {
                    Vec3 delta = player.m_20184_();
                    ResidualEntity residual = new ResidualEntity(multiArmCapability.getPlayer().m_9236_(), BlockPos.f_121853_, player.m_20183_(), player, 1, MultiArmCapability.SkillPose.DASH_CLAWS, (float)Math.atan2(delta.f_82481_, delta.f_82479_) * 180.0f / (float)Math.PI, (float)Math.acos(delta.f_82480_) * 180.0f / (float)Math.PI);
                    residual.m_146884_(player.m_20182_());
                    player.m_9236_().m_7967_((Entity)residual);
                }
                if (this.dashTime == 0) {
                    this.dash = false;
                    multiArmCapability.pose = MultiArmCapability.SkillPose.NONE;
                    player.m_20256_(Vec3.f_82478_);
                }
            }
        }
    }

    @Override
    public void startCooldown(MultiArmCapability multiArmCapability) {
        ItemStack stack = multiArmCapability.implantStore.getArmForSkill(this);
        if (stack != null) {
            multiArmCapability.getPlayer().m_36335_().m_41524_(stack.m_41720_(), this.cd);
        }
    }

    @Override
    public void startAbility(MultiArmCapability multiArmCapability) {
        super.startAbility(multiArmCapability);
        if (this.canActiveAbility(multiArmCapability)) {
            this.startCooldown(multiArmCapability);
            if (!this.charge) {
                multiArmCapability.pose = MultiArmCapability.SkillPose.CHARGE_CLAWS;
                multiArmCapability.timeCharge = 10;
                multiArmCapability.timeCharge0 = 10;
                this.charge = true;
            }
        }
    }

    @Override
    public void onAttack(MultiArmCapability multiArmCapability, LivingHurtEvent event) {
        if (multiArmCapability.getPlayer().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_276093_(Util.ELECTRIC_DAMAGE_MOB) || event.getSource().m_276093_(Util.ELECTRIC_DAMAGE_PLAYER)) {
            return;
        }
        event.getEntity().f_19802_ = 0;
        event.getEntity().m_6469_(Util.electricDamage((ServerLevel)multiArmCapability.getPlayer().m_9236_(), multiArmCapability.getPlayer()), 10.0f * multiArmCapability.getPlayer().m_36403_(0.5f));
        event.setCanceled(true);
    }

    @Override
    public SoundEvent getStartSound() {
        return super.getStartSound();
    }

    @Override
    public SoundEvent getStopSound() {
        return (SoundEvent)BKSounds.MULTIARM_CLAW_DASH.get();
    }

    @Override
    public float getVolumeStopAbility() {
        return 15.0f;
    }

    @Override
    public void stopAbility(MultiArmCapability multiArmCapability) {
        if (this.charge) {
            super.stopAbility(multiArmCapability);
            Player player = multiArmCapability.getPlayer();
            Vec3 view = player.m_20252_(1.0f);
            view = view.m_82542_(1.0, player.m_20096_() || view.f_82480_ > 0.0 ? 0.0 : 1.0, 1.0);
            player.m_20256_(view.m_82490_(4.0));
            player.f_19812_ = true;
            this.charge = false;
            this.dash = true;
            this.dashTime = 5;
            multiArmCapability.pose = MultiArmCapability.SkillPose.DASH_CLAWS;
            if (!player.m_9236_().f_46443_) {
                ResidualEntity residual = new ResidualEntity(multiArmCapability.getPlayer().m_9236_(), BlockPos.f_121853_, player.m_20183_(), player, 1, MultiArmCapability.SkillPose.CHARGE_CLAWS, (float)Math.atan2(view.f_82481_, view.f_82479_) * 180.0f / (float)Math.PI, (float)Math.acos(view.f_82480_) * 180.0f / (float)Math.PI);
                residual.m_146884_(player.m_20182_());
                player.m_9236_().m_7967_((Entity)residual);
            }
        }
    }

    @Override
    public void onHurt(MultiArmCapability multiArmCapability, LivingHurtEvent event) {
        if (this.dash) {
            float damage = event.getAmount() * 0.5f;
            event.setAmount(damage);
        }
    }
}

