/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.upgrade;

import com.TBK.crc.common.Util;
import com.TBK.crc.server.manager.UpgradeInstance;
import com.TBK.crc.server.upgrade.Upgrade;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class Upgrades {
    public Map<Integer, UpgradeInstance> upgrades;

    public Upgrades(Map<Integer, UpgradeInstance> upgrades) {
        this.upgrades = upgrades;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236831_(this.upgrades, FriendlyByteBuf::writeInt, (buf1, multiArmSkillAbstractInstance) -> buf1.m_130070_(multiArmSkillAbstractInstance.getUpgrade().name));
    }

    public Upgrades(CompoundTag tag) {
        HashMap<Integer, UpgradeInstance> map = new HashMap<Integer, UpgradeInstance>();
        if (tag.m_128441_("upgrades")) {
            ListTag listTag = tag.m_128437_("upgrades", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag1 = listTag.m_128728_(i);
                if (!tag1.m_128441_("name")) continue;
                int pos = tag1.m_128451_("pos");
                Upgrade power = Util.getTypeSkillForName(tag1.m_128461_("name"));
                ListTag tags = tag1.m_128437_("refinements", 10);
                for (int j = 0; j < tags.size(); ++j) {
                    power.refinements.add(tags.m_128728_(j).m_128461_("name"));
                }
                map.put(pos, new UpgradeInstance(power, 0));
            }
        }
        this.upgrades = map;
    }

    public void save(CompoundTag tag) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            if (this.upgrades.get(i) == null) continue;
            Upgrade power = this.upgrades.get(i).getUpgrade();
            CompoundTag tag1 = new CompoundTag();
            power.save(tag1);
            tag1.m_128405_("pos", i);
            power.save(tag1);
            listtag.add((Object)tag1);
        }
        if (!listtag.isEmpty()) {
            tag.m_128365_("upgrades", (Tag)listtag);
        }
    }

    public Upgrade getForName(String name) {
        Upgrade power = Upgrade.NONE;
        for (UpgradeInstance powerInstance : this.getSkills()) {
            Upgrade power1 = powerInstance.getUpgrade();
            if (!power1.name.equals(name)) continue;
            power = power1;
        }
        return power;
    }

    public Map<Integer, UpgradeInstance> getUpgrades() {
        HashMap<Integer, UpgradeInstance> map = new HashMap<Integer, UpgradeInstance>();
        for (Map.Entry<Integer, UpgradeInstance> entry : this.upgrades.entrySet()) {
            if (entry.getValue().getUpgrade().name.equals("none")) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public boolean hasMultiArmSkillAbstract(String id) {
        return !this.getForName((String)id).name.equals("none");
    }

    public void addMultiArmSkillAbstracts(int pos, Upgrade power) {
        this.upgrades.put(pos, new UpgradeInstance(power, 0));
    }

    public Collection<UpgradeInstance> getSkills() {
        return this.upgrades.values();
    }

    public Upgrade get(int pos) {
        if (this.upgrades.containsKey(pos)) {
            return this.upgrades.get(pos).getUpgrade();
        }
        return Upgrade.NONE;
    }
}

