/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.client.gui;

import com.TBK.crc.CRC;
import com.TBK.crc.common.ForgeInputEvent;
import com.TBK.crc.common.Util;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.upgrade.Upgrade;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MultiArmOverlay
implements IGuiOverlay {
    protected static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("crc", "textures/gui/skill_hotbar.png");
    protected static final ResourceLocation AMMO_FULL_LOCATION = new ResourceLocation("crc", "textures/gui/cannon_ammo_full.png");
    protected static final ResourceLocation AMMO_EMPTY_LOCATION = new ResourceLocation("crc", "textures/gui/cannon_ammo_empty.png");
    protected static final ResourceLocation[] FRAMES = new ResourceLocation[]{new ResourceLocation("crc", "textures/gui/chicken_talk_0/cyborg_chicken_talk_0.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_0/cyborg_chicken_talk_1.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_0/cyborg_chicken_talk_2.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_0/cyborg_chicken_talk_3.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_1/cyborg_chicken1_talk_0.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_1/cyborg_chicken1_talk_1.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_1/cyborg_chicken1_talk_2.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_1/cyborg_chicken1_talk_3.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_2/cyborg_chicken2_talk_0.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_2/cyborg_chicken2_talk_1.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_2/cyborg_chicken2_talk_2.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_2/cyborg_chicken2_talk_3.png")};
    protected static final ResourceLocation[] STATICS_FRAMES = new ResourceLocation[]{new ResourceLocation("crc", "textures/gui/chicken_talk_0/cyborg_chicken_talk_static.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_1/cyborg_chicken1_talk_static.png"), new ResourceLocation("crc", "textures/gui/chicken_talk_2/cyborg_chicken2_talk_static.png")};
    private final Minecraft mc = Minecraft.m_91087_();

    public void render(ForgeGui gui, @NotNull GuiGraphics graphics, float partialTicks, int width, int height) {
        LocalPlayer player;
        MultiArmCapability cap;
        if (this.mc.f_91074_ != null && (cap = MultiArmCapability.get((Player)(player = this.mc.f_91074_))) != null) {
            graphics.m_280168_().m_85836_();
            float ageInTick = (float)player.f_19797_ + partialTicks;
            if (cap.passives.hasMultiArmSkillAbstract("night_eye") || cap.passives.hasMultiArmSkillAbstract("hacker_eye")) {
                Upgrade passive = cap.passives.get(1);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float[] color = passive.getWindowsColor(cap);
                if (color.length > 0) {
                    RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
                    if (passive.name.equals("night_eye")) {
                        int frame = (int)(1.25f * ageInTick % (float)CRC.NIGHT_VISION_STAGES.size());
                        ResourceLocation location = CRC.NIGHT_VISION_LOCATIONS.get(frame);
                        RenderSystem.disableDepthTest();
                        RenderSystem.depthMask((boolean)false);
                        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                        graphics.m_280398_(location, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
                        RenderSystem.depthMask((boolean)true);
                        RenderSystem.enableDepthTest();
                        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    int colorAlpha = passive.name.equals("night_eye") ? 0x4000FF00 : 0x400000FF;
                    graphics.m_280509_(0, 0, this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_(), colorAlpha);
                }
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            graphics.m_280168_().m_85836_();
            if (cap.warningLevel > 0) {
                ResourceLocation location;
                int warningLevel = cap.warningLevel - 1;
                int i = width / 2 - 140;
                int j1 = i + 101;
                int k1 = height - 58;
                float percent = cap.getAnimLevelWarning(partialTicks);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                float xExtra = 129.0f;
                float yExtra = 13.0f;
                if (cap.playChickenWarning) {
                    xExtra = cap.chickenSpoke ? Mth.m_14179_((float)percent, (float)129.0f, (float)-40.0f) : Mth.m_14179_((float)percent, (float)30.0f, (float)-40.0f);
                    yExtra = cap.chickenSpoke ? Mth.m_14179_((float)percent, (float)13.0f, (float)-155.0f) : Mth.m_14179_((float)percent, (float)-76.0f, (float)-155.0f);
                }
                float centerX = (float)j1 + xExtra;
                float centerY = (float)k1 + yExtra;
                ResourceLocation resourceLocation = location = cap.playChickenWarning ? STATICS_FRAMES[warningLevel] : new ResourceLocation("crc", "textures/mobeffect/location_tracking_" + warningLevel + ".png");
                if (cap.getChickenTalkAnim(partialTicks) > 0.0f) {
                    graphics.m_280168_().m_252880_(centerX, centerY, 0.0f);
                    graphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)(ageInTick * 0.5f)) * 30.0f));
                    graphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(ageInTick * 0.9f)) * 15.0f));
                    graphics.m_280168_().m_252880_(-centerX, -centerY, 0.0f);
                    location = FRAMES[(int)(ageInTick % 4.0f) + warningLevel * 4];
                }
                graphics.m_280163_(location, (int)centerX, (int)centerY, 0.0f, 0.0f, Mth.m_14167_((float)(18.0f + 128.0f * percent)), Mth.m_14167_((float)(18.0f + 128.0f * percent)), Mth.m_14167_((float)(18.0f + 128.0f * percent)), Mth.m_14167_((float)(18.0f + 128.0f * percent)));
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            graphics.m_280168_().m_85849_();
            graphics.m_280168_().m_85849_();
            if (Util.hasMultiArm(cap)) {
                int i = width / 2 - 140;
                graphics.m_280168_().m_85836_();
                if (cap.hotbarActive) {
                    graphics.m_280163_(WIDGETS_LOCATION, i + 66, height - 72, 0.0f, 0.0f, 146, 32, 256, 256);
                    for (int i1 = 0; i1 < cap.skills.upgrades.size(); ++i1) {
                        Upgrade skillAbstract = cap.getHotBarSkill().get(i1);
                        int j1 = i + 101 + i1 * 20;
                        int k1 = height - 58;
                        if (skillAbstract.equals(Upgrade.NONE)) continue;
                        graphics.m_280168_().m_85836_();
                        graphics.m_280163_(this.getIconsForSkill(skillAbstract), j1, k1, 0.0f, 0.0f, 16, 16, 16, 16);
                        graphics.m_280168_().m_85849_();
                    }
                    graphics.m_280163_(WIDGETS_LOCATION, i + 96 + ForgeInputEvent.selectActual * 20, height - 60, 20.0f, 32.0f, 24, 21, 256, 256);
                } else {
                    graphics.m_280163_(WIDGETS_LOCATION, i + 132, height - 74, 0.0f, 34.0f, 18, 32, 256, 256);
                }
                graphics.m_280168_().m_85849_();
                if (cap.skills.hasMultiArmSkillAbstract("cannon_arm")) {
                    graphics.m_280168_().m_85836_();
                    int j1 = i + 101;
                    int k1 = height - 58;
                    this.printAmmo(graphics, AMMO_EMPTY_LOCATION, j1 - 120, k1 + 25, 10);
                    this.printAmmo(graphics, AMMO_FULL_LOCATION, j1 - 120, k1 + 25, cap.energy);
                    graphics.m_280168_().m_85849_();
                }
            }
        }
    }

    public void printAmmo(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int ammo) {
        int spriteWidth = 16;
        int spriteHeight = 16;
        for (int i = 0; i < ammo; ++i) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(resourceLocation, x + 6 * i, y, 0.0f, 0.0f, spriteWidth, Mth.m_14167_((float)spriteHeight), spriteWidth, spriteHeight);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private ResourceLocation getIconsForSkill(Upgrade skillAbstract) {
        return new ResourceLocation("crc", "textures/gui/skill/" + skillAbstract.name + "_icon.png");
    }
}

