/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.client.renderer;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class GlowingBlockRenderer<T extends ChestBlockEntity>
implements BlockEntityRenderer<T> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean xmasTextures;

    public GlowingBlockRenderer(BlockEntityRendererProvider.Context p_173521_) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = p_173521_.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_(BOTTOM);
        this.lid = modelpart.m_171324_(LID);
        this.lock = modelpart.m_171324_(LOCK);
        ModelPart modelpart1 = p_173521_.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = modelpart1.m_171324_(BOTTOM);
        this.doubleLeftLid = modelpart1.m_171324_(LID);
        this.doubleLeftLock = modelpart1.m_171324_(LOCK);
        ModelPart modelpart2 = p_173521_.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = modelpart2.m_171324_(BOTTOM);
        this.doubleRightLid = modelpart2.m_171324_(LID);
        this.doubleRightLock = modelpart2.m_171324_(LOCK);
    }

    public void render(T p_112363_, float p_112364_, PoseStack p_112365_, MultiBufferSource p_112366_, int p_112367_, int p_112368_) {
        Level level = p_112363_.m_58904_();
        boolean flag = level != null;
        BlockState blockstate = flag ? p_112363_.m_58900_() : (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)blockstate.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            p_112365_.m_85836_();
            float f = ((Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_)).m_122435_();
            p_112365_.m_252880_(0.5f, 0.5f, 0.5f);
            p_112365_.m_252781_(Axis.f_252436_.m_252977_(-f));
            p_112365_.m_252880_(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.m_5641_(blockstate, level, p_112363_.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)neighborcombineresult.m_5649_(ChestBlock.m_51517_(p_112363_))).get(p_112364_);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(p_112367_);
            Material material = this.getMaterial(p_112363_, chesttype);
            VertexConsumer vertexconsumer = material.m_119194_(p_112366_, RenderType::m_110452_);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(p_112365_, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, p_112368_);
                } else {
                    this.render(p_112365_, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, p_112368_);
                }
            } else {
                this.render(p_112365_, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, p_112368_);
            }
            if (level != null) {
                int fullBright = 0xF000F0;
                boolean neverOpened = Util.isHackingChest(p_112363_.m_58899_());
                if (neverOpened) {
                    this.draw(p_112366_, p_112365_, 0.05f, 0.3176f, 0.83f, 0.96f, fullBright, System.currentTimeMillis());
                }
            }
            p_112365_.m_85849_();
        }
    }

    private void render(PoseStack p_112370_, VertexConsumer p_112371_, ModelPart p_112372_, ModelPart p_112373_, ModelPart p_112374_, float p_112375_, int p_112376_, int p_112377_) {
        p_112373_.f_104203_ = p_112372_.f_104203_ = -(p_112375_ * 1.5707964f);
        p_112372_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
        p_112373_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
        p_112374_.m_104301_(p_112370_, p_112371_, p_112376_, p_112377_);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        return Sheets.m_110767_(blockEntity, (ChestType)chestType, (boolean)this.xmasTextures);
    }

    private void putVertex(VertexConsumer vc, Matrix4f mat, Matrix3f normal, float x, float y, float z, float r, float g, float b, float a, int packedLight) {
        vc.m_252986_(mat, x, y, z).m_6122_((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f)).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void draw(MultiBufferSource bufferSource, PoseStack ps, float expand, float r, float g, float b, int light, long time) {
        int[][] edges;
        float brightness = 0.5f + 0.5f * (float)Math.sin((double)time * 0.005);
        float min = 0.0f - (expand -= 0.01f * brightness);
        float max = 1.0f + expand;
        PoseStack.Pose last = ps.m_85850_();
        Matrix4f mat = last.m_252922_();
        Matrix3f normal = last.m_252943_();
        VertexConsumer lines = bufferSource.m_6299_(BKRenderType.GLOW_LINES);
        float[][] v = new float[][]{{min, min, min}, {max, min, min}, {max, max, min}, {min, max, min}, {min, min, max}, {max, min, max}, {max, max, max}, {min, max, max}};
        for (int[] e : edges = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
            float[] a = v[e[0]];
            float[] bV = v[e[1]];
            this.putVertex(lines, mat, normal, a[0], a[1], a[2], r * brightness, g * brightness, b * brightness, 1.0f, light);
            this.putVertex(lines, mat, normal, bV[0], bV[1], bV[2], r * brightness, g * brightness, b * brightness, 1.0f, light);
        }
    }
}

