/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.client.renderer;

import com.TBK.crc.client.model.MultiArmModel;
import com.TBK.crc.common.Util;
import com.TBK.crc.server.capability.MultiArmCapability;
import com.TBK.crc.server.entity.ResidualEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ResidualRenderer<T extends ResidualEntity>
extends NoopRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("crc", "textures/hand/cyborgarm.png");
    public PlayerModel model;
    public MultiArmModel armModel;

    public ResidualRenderer(EntityRendererProvider.Context p_174326_) {
        super(p_174326_);
        this.model = new PlayerModel(p_174326_.m_174023_(ModelLayers.f_171162_), false);
        this.model.f_102610_ = false;
        this.armModel = new MultiArmModel(p_174326_.m_174023_(MultiArmModel.LAYER_LOCATION));
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    public void render(T p_114485_, float p_114486_, float partialTick, PoseStack stack, MultiBufferSource bufferSource, int p_114490_) {
        AbstractClientPlayer player;
        AbstractClientPlayer abstractClientPlayer = player = ((ResidualEntity)((Object)p_114485_)).getOwner() instanceof AbstractClientPlayer ? (AbstractClientPlayer)((ResidualEntity)((Object)p_114485_)).getOwner() : null;
        if (this.model == null || player == null) {
            return;
        }
        if (((ResidualEntity)((Object)p_114485_)).getOrigen() != null) {
            MultiArmCapability cap = MultiArmCapability.get((Player)player);
            float alpha = ((ResidualEntity)((Object)p_114485_)).getResidualTime(partialTick) / 20.0f;
            stack.m_85836_();
            stack.m_85837_(0.0, 1.5, 0.0);
            stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            this.model.m_6973_((LivingEntity)player, 50.0f, 0.5f, p_114486_, 0.0f, 0.0f);
            if (cap != null) {
                this.setPose(((ResidualEntity)((Object)p_114485_)).getSkillPose(), stack, (Player)player, p_114485_);
            }
            this.model.m_7695_(stack, bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)player.m_108560_())), p_114490_, OverlayTexture.f_118083_, 0.31f, 0.83f, 0.96f, alpha);
            if (cap != null && Util.hasMultiArm(cap)) {
                this.renderArm(cap, (Player)player, stack, bufferSource, p_114490_, alpha);
            }
            stack.m_85849_();
        }
        super.m_7392_(p_114485_, p_114486_, partialTick, stack, bufferSource, p_114490_);
    }

    public void renderArm(MultiArmCapability cap, Player owner, PoseStack stack, MultiBufferSource buffer, int light, float alpha) {
        stack.m_85836_();
        this.selectPoseArm(owner, cap.getSelectSkill().name);
        this.armModel.m_142109_().m_104315_(this.model.f_102811_);
        this.armModel.m_142109_().f_233553_ = 1.01f;
        this.armModel.m_142109_().f_233554_ = 1.01f;
        this.armModel.m_142109_().f_233555_ = 1.01f;
        this.armModel.selectArm(owner, cap.getSelectSkill().name, cap.getSelectSkill(), (float)owner.f_19797_ + Minecraft.m_91087_().getPartialTick());
        this.armModel.m_7695_(stack, buffer.m_6299_(RenderType.m_234338_((ResourceLocation)TEXTURE)), light, OverlayTexture.f_118083_, 0.31f, 0.83f, 0.96f, alpha);
        stack.m_85849_();
    }

    private void selectPoseArm(Player entity, String name) {
        switch (name) {
            case "cannon_arm": 
            case "gancho_arm": {
                this.model.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
        }
    }

    private void setPose(MultiArmCapability.SkillPose pose, PoseStack stack, Player player, T residual) {
        float rotX = residual.m_146909_();
        stack.m_252781_(Axis.f_252436_.m_252977_(residual.m_146908_() - 90.0f));
        switch (pose) {
            case DASH_CLAWS: {
                stack.m_252781_(Axis.f_252529_.m_252977_(rotX));
                this.model.f_102811_.f_104203_ = (float)(-Math.PI);
                break;
            }
            case CHARGE_CLAWS: {
                this.model.f_102811_.f_104203_ = -1.5707964f;
                this.model.f_102812_.f_104203_ = -1.3089969f;
                this.model.f_102812_.f_104204_ = 0.5235988f;
            }
        }
    }
}

