/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.client.renderer;

import com.TBK.crc.client.layer.RexGlowingLayer;
import com.TBK.crc.client.layer.ShieldLayer;
import com.TBK.crc.client.model.RexChickenModel;
import com.TBK.crc.common.registry.BKRenderType;
import com.TBK.crc.server.entity.RexChicken;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RexChickenRenderer<T extends RexChicken, M extends RexChickenModel<T>>
extends LivingEntityRenderer<T, M> {
    private static final ResourceLocation BEAM_INNER_LOCATION = new ResourceLocation("crc", "textures/entity/rex_chicken/beam/rex_beam_inner.png");
    private static final ResourceLocation BEAM_OUTER_LOCATION = new ResourceLocation("crc", "textures/entity/rex_chicken/beam/rex_beam_outer.png");

    public RexChickenRenderer(EntityRendererProvider.Context p_174289_) {
        super(p_174289_, new RexChickenModel(Minecraft.m_91087_().m_167973_().m_171103_(RexChickenModel.LAYER_LOCATION)), 1.0f);
        this.m_115326_(new RexGlowingLayer(this));
        this.m_115326_((RenderLayer)new ShieldLayer(this));
    }

    protected boolean shouldShowName(T p_115333_) {
        return false;
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    public void render(T p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        super.m_7392_(p_115308_, p_115309_, p_115310_, p_115311_, p_115312_, p_115313_);
        if (((RexChicken)((Object)p_115308_)).isLaser()) {
            this.render(p_115311_, p_115312_, p_115308_, p_115309_);
        }
    }

    public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, T jellyfish, float pPartialTicks) {
        float ageInTicks = (float)((RexChicken)((Object)jellyfish)).f_19797_ + pPartialTicks;
        float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.075f;
        float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.075f;
        float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.075f;
        Vec3 beamOrigin = ((RexChicken)((Object)jellyfish)).getHeadPos();
        Vec3 rawBeamPosition = ((RexChicken)((Object)jellyfish)).getBeamDirection();
        float length = (float)rawBeamPosition.m_82553_();
        Vec3 vec3 = rawBeamPosition.m_82541_();
        float xRot = (float)Math.acos(vec3.f_82480_);
        float yRot = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
        Vec3 offSet = beamOrigin.m_82546_(jellyfish.m_20182_());
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_((double)shakeByX + offSet.f_82479_, (double)shakeByY + offSet.f_82480_ - 1.0, (double)shakeByZ + offSet.f_82481_);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
        pMatrixStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
        pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        this.renderBeamInner(jellyfish, pMatrixStack, pBuffer, pPartialTicks, 1.5f, length);
        this.renderBeamOuter(jellyfish, pMatrixStack, pBuffer, pPartialTicks, 1.75f, length);
        pMatrixStack.m_85849_();
    }

    private void renderBeamInner(T entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float width, float length) {
        poseStack.m_85836_();
        int vertices = 4;
        VertexConsumer vertexconsumer = source.m_6299_(BKRenderType.getBeam(BEAM_INNER_LOCATION));
        float speed = 0.5f;
        float startAlpha = 1.0f;
        float endAlpha = 1.0f;
        float v = ((float)((RexChicken)((Object)entity)).f_19797_ + partialTicks) * -0.25f * speed;
        float v1 = v + length * 0.5f;
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f7 = Mth.m_14089_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = Mth.m_14031_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f6, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f6, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f9, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f9, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }

    private void renderBeamOuter(T entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float width, float length) {
        poseStack.m_85836_();
        int vertices = 8;
        VertexConsumer vertexconsumer = source.m_6299_(BKRenderType.getBeam(BEAM_OUTER_LOCATION));
        float speed = 1.0f;
        float startAlpha = 1.0f;
        float endAlpha = 0.0f;
        float v = ((float)((RexChicken)((Object)entity)).f_19797_ + partialTicks) * -0.25f * speed;
        float v1 = v + length * 0.15f;
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f7 = Mth.m_14089_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = Mth.m_14031_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f6, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f6, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f9, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f9, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return new ResourceLocation("crc", "textures/entity/rex_chicken/rex_chicken.png");
    }
}

