/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.common.item;

import com.TBK.crc.UpgradeableParts;
import com.TBK.crc.common.Util;
import com.TBK.crc.common.item.CyberRefinementItem;
import com.TBK.crc.common.item.ItemCyborg;
import com.TBK.crc.common.registry.BKItems;
import com.TBK.crc.server.upgrade.Upgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CyberImplantItem
extends ItemCyborg {
    public Upgrade skill;

    public CyberImplantItem(Item.Properties p_41383_, UpgradeableParts part, Upgrade skillAbstract) {
        super(p_41383_, part, 0);
        this.skill = skillAbstract;
    }

    public static boolean canAddUpgrade(CompoundTag tag, Upgrade upgrade) {
        ListTag list;
        if (tag.m_128441_("storeUpgrade") && !(list = tag.m_128437_("storeUpgrade", 10)).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.m_128728_(i);
                if (!nbt.m_128461_("nameUpgrade").equals(upgrade.name)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canAddRefinement(CompoundTag tag, CyberRefinementItem refinementItem, Upgrade upgrade) {
        ListTag list;
        if (!refinementItem.skill.name.equals(upgrade.name)) {
            return false;
        }
        if (tag.m_128441_("storeRefinement") && !(list = tag.m_128437_("storeRefinement", 10)).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.m_128728_(i);
                if (!nbt.m_128461_("nameRefinement").equals(refinementItem.name)) continue;
                return false;
            }
        }
        return true;
    }

    public static void addUpgrade(CompoundTag tag, Upgrade upgrade) {
        if (tag.m_128441_("storeUpgrade")) {
            ListTag list = tag.m_128437_("storeUpgrade", 10);
            if (!list.isEmpty()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("nameUpgrade", upgrade.name);
                list.add((Object)nbt);
            }
        } else {
            ListTag list = new ListTag();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("nameUpgrade", upgrade.name);
            list.add((Object)nbt);
            tag.m_128365_("storeUpgrade", (Tag)list);
        }
    }

    public static void addRefinement(CompoundTag tag, String refinement) {
        if (tag.m_128441_("storeRefinement")) {
            ListTag list = tag.m_128437_("storeRefinement", 10);
            if (!list.isEmpty()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("nameRefinement", refinement);
                list.add((Object)nbt);
            }
        } else {
            ListTag list = new ListTag();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("nameRefinement", refinement);
            list.add((Object)nbt);
            tag.m_128365_("storeRefinement", (Tag)list);
        }
    }

    public static List<String> getRefinement(CompoundTag tag) {
        ListTag list;
        ArrayList<String> upgrades = new ArrayList<String>();
        if (tag.m_128441_("storeRefinement") && !(list = tag.m_128437_("storeRefinement", 10)).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.m_128728_(i);
                if (nbt.m_128461_("nameRefinement").equals(Upgrade.NONE.name)) continue;
                upgrades.add(nbt.m_128461_("nameRefinement"));
            }
        }
        return upgrades;
    }

    public static List<Upgrade> getUpgrade(CyberImplantItem implantItem, CompoundTag tag) {
        ListTag list;
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        if (!implantItem.skill.name.equals("none")) {
            upgrades.add(Util.getTypeSkillForName(implantItem.skill.name));
        }
        if (tag.m_128441_("storeUpgrade") && !(list = tag.m_128437_("storeUpgrade", 10)).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag nbt = list.m_128728_(i);
                if (nbt.m_128461_("nameUpgrade").equals(Upgrade.NONE.name)) continue;
                Upgrade upgrade = Util.getTypeSkillForName(nbt.m_128461_("nameUpgrade"));
                upgrade.setRefinements(CyberImplantItem.getRefinement(tag));
                upgrades.add(upgrade);
            }
        }
        return upgrades;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        List<Upgrade> upgrades = CyberImplantItem.getUpgrade((CyberImplantItem)p_41421_.m_41720_(), p_41421_.m_41784_());
        List<String> refinements = CyberImplantItem.getRefinement(p_41421_.m_41784_());
        p_41423_.add((Component)Component.m_237115_((String)"tooltip.cyber_implant").m_130940_(ChatFormatting.DARK_AQUA));
        if (p_41421_.m_150930_((Item)BKItems.CYBORG_ARM.get())) {
            p_41423_.add((Component)Component.m_237115_((String)"upgrades.none").m_130940_(ChatFormatting.GRAY));
        }
        if (!upgrades.isEmpty()) {
            for (Upgrade upgrade : upgrades) {
                p_41423_.add((Component)Component.m_237115_((String)("upgrades." + upgrade.name)).m_130940_(ChatFormatting.GRAY));
            }
        }
        for (String name : refinements) {
            p_41423_.add((Component)Component.m_237115_((String)("refinement." + name)));
        }
    }
}

