/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.common.mixin;

import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.capability.MultiArmCapability;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"getJumpPower"}, at={@At(value="RETURN")}, cancellable=true)
    public void modifyJump(CallbackInfoReturnable<Float> cir) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && MultiArmCapability.hasEffect(MobEffects.f_19603_, player = (Player)livingEntityMixin)) {
            float original = ((Float)cir.getReturnValue()).floatValue();
            cir.setReturnValue((Object)Float.valueOf(original * MultiArmCapability.getJumpBoost(player)));
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    public void onJump(CallbackInfo ci) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && MultiArmCapability.hasEffect(MobEffects.f_19603_, player = (Player)livingEntityMixin)) {
            player.m_9236_().m_247517_(null, player.m_20183_(), player.m_9236_().f_46441_.m_188499_() ? (SoundEvent)BKSounds.CHICKEN_COIL_MOVE_1.get() : (SoundEvent)BKSounds.CHICKEN_COIL_MOVE_2.get(), SoundSource.PLAYERS);
        }
    }
}

