/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.capability;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.api.IMultiArmPlayer;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.capability.CRCCapability;
import com.TBK.crc.server.entity.TeleportEntity;
import com.TBK.crc.server.manager.ImplantStore;
import com.TBK.crc.server.manager.UpgradeInstance;
import com.TBK.crc.server.network.PacketHandler;
import com.TBK.crc.server.network.messager.PacketHandlerPowers;
import com.TBK.crc.server.network.messager.PacketSyncImplant;
import com.TBK.crc.server.network.messager.PacketSyncPlayerData;
import com.TBK.crc.server.network.messager.PacketSyncPosHotBar;
import com.TBK.crc.server.network.messager.PacketSyncSkill;
import com.TBK.crc.server.upgrade.CoilFeet;
import com.TBK.crc.server.upgrade.Upgrade;
import com.TBK.crc.server.upgrade.Upgrades;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiArmCapability
implements IMultiArmPlayer {
    public Upgrade lastUsingUpgrade = Upgrade.NONE;
    public boolean chickenEnemy = false;
    public int cooldownUse;
    Player player;
    Level level;
    int posSelectUpgrade = 0;
    public boolean hotbarActive = false;
    public int invokeTimer = 0;
    public int warningLevel = 0;
    public Entity catchEntity = null;
    public int timeLevelWarning = 0;
    public int timeLevelWarning0 = 0;
    public int chickenAnimTime = 0;
    public int chickenAnimTime0 = 0;
    public boolean chickenSpoke = false;
    public boolean playChickenWarning = false;
    public int timeShoot = 0;
    public int timeShoot0 = 0;
    public int timeCharge = 0;
    public int timeCharge0 = 0;
    public int stopAimingAnim = 0;
    public int stopAimingAnim0 = 0;
    public int levelCharge = 0;
    public int wave = 0;
    public int energy = 10;
    public float[] chanceLeaderSpawn = new float[]{0.05f, 0.5f, 1.0f};
    public Upgrades skills = new Upgrades(Util.getMapArmEmpty());
    public Upgrades passives = new Upgrades(Util.getMapEmpty());
    public ImplantStore implantStore = new ImplantStore();
    public boolean dirty = false;
    public SkillPose pose = SkillPose.NONE;
    ServerBossEvent event = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"chicken_attack.next_wave"), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true).m_7006_(false);

    public static MultiArmCapability get(Player player) {
        return CRCCapability.getEntityCap((Entity)player, MultiArmCapability.class);
    }

    public void setPosSelectUpgrade(int pos) {
        this.posSelectUpgrade = pos;
    }

    public int getPosSelectUpgrade() {
        return this.posSelectUpgrade;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isCatchedTarget(Entity entity) {
        return this.catchEntity == entity;
    }

    @Override
    public Upgrade getSelectSkill() {
        return this.getHotBarSkill().get(this.posSelectUpgrade);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimLevelWarning(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.timeLevelWarning0, (float)this.timeLevelWarning) / 10.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimShoot(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.timeShoot0, (float)this.timeShoot) / 10.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimChargeClaw(float partialTick) {
        return 1.0f - Mth.m_14179_((float)partialTick, (float)this.timeCharge0, (float)this.timeCharge) / 10.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStopAiming(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.stopAimingAnim0, (float)this.stopAimingAnim) / 5.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getChickenTalkAnim(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.chickenAnimTime0, (float)this.chickenAnimTime) / 30.0f;
    }

    @Override
    public Upgrade getSkillForHotBar(int pos) {
        return this.skills.get(pos);
    }

    @Override
    public Upgrade getLastUsingSkill() {
        return this.lastUsingUpgrade;
    }

    @Override
    public void setLastUsingSkill(Upgrade power) {
        this.lastUsingUpgrade = power;
    }

    public void syncNewPlayer(ServerPlayer player, MultiArmCapability cap, boolean wasDeath) {
        PacketHandler.sendToPlayer(new PacketSyncPlayerData(cap.serializeNBT(), wasDeath, player.m_19879_()), player);
    }

    public void copyNbt(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public void loadWarningLevel(CompoundTag tag) {
        this.warningLevel = tag.m_128451_("warningLevel");
        this.wave = tag.m_128451_("wave");
        this.timeLevelWarning = tag.m_128451_("timeLevelWarning");
        this.timeLevelWarning0 = tag.m_128451_("timeLevelWarning");
        this.playChickenWarning = tag.m_128471_("playAnim");
        this.invokeTimer = tag.m_128451_("invokeTime");
    }

    public void copyFrom(MultiArmCapability cap) {
        this.skills = cap.skills;
        this.passives = cap.passives;
        this.implantStore = cap.implantStore;
        this.setPosSelectUpgrade(cap.getPosSelectUpgrade());
        this.chickenEnemy = false;
        this.invokeTimer = 0;
        this.chickenSpoke = false;
        this.chickenAnimTime = 0;
        this.chickenAnimTime0 = 0;
        this.dirty = true;
        cap.event.m_8321_(false);
        cap.event.m_7706_();
        this.event.m_8321_(false);
        this.event.m_7706_();
    }

    public CompoundTag saveChickenEnemyData() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("warningLevel", this.warningLevel);
        tag.m_128405_("wave", this.wave);
        tag.m_128405_("timeLevelWarning", this.timeLevelWarning);
        tag.m_128379_("playAnim", this.playChickenWarning);
        tag.m_128405_("invokeTime", this.invokeTimer);
        return tag;
    }

    @Override
    public void tick(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.event.m_8321_(this.chickenEnemy);
            if (this.chickenEnemy) {
                if (!this.event.m_8324_().contains(serverPlayer)) {
                    this.event.m_6543_(serverPlayer);
                }
                MutableComponent component = this.warningLevel > 2 ? Component.m_237115_((String)"chicken_attack.infinite_wave") : Component.m_237115_((String)"chicken_attack.wave").m_130946_(" : " + (this.wave + 1));
                this.event.m_6456_((Component)component);
                BossEvent.BossBarColor color = this.getColorForWarningLevel();
                this.event.m_6451_(color);
                this.event.m_142711_(1.0f - (float)this.invokeTimer / 400.0f);
            } else {
                this.event.m_7706_();
            }
        } else if (this.cooldownUse > 0) {
            --this.cooldownUse;
        }
        if (this.level.f_46443_) {
            this.timeLevelWarning0 = this.timeLevelWarning;
            this.chickenAnimTime0 = this.chickenAnimTime;
            if (this.playChickenWarning) {
                if (this.chickenAnimTime <= 0) {
                    if (this.chickenSpoke) {
                        if (this.timeLevelWarning > 0) {
                            --this.timeLevelWarning;
                            if (this.timeLevelWarning == 0) {
                                this.playChickenWarning = false;
                                this.chickenSpoke = false;
                            }
                        }
                    } else if (this.timeLevelWarning < 10) {
                        ++this.timeLevelWarning;
                        if (this.timeLevelWarning == 10) {
                            this.chickenAnimTime = 30;
                            this.chickenAnimTime0 = 30;
                            this.level.m_245747_(player.m_20183_().m_6630_(1), (SoundEvent)BKSounds.CHICKEN_CYBORG_SPEECH.get(), SoundSource.AMBIENT, 10.0f, 1.0f, false);
                        }
                    }
                } else {
                    --this.chickenAnimTime;
                    if (this.chickenAnimTime == 10 || this.chickenAnimTime == 20) {
                        this.level.m_245747_(player.m_20183_().m_6630_(1), (SoundEvent)BKSounds.CHICKEN_CYBORG_SPEECH.get(), SoundSource.AMBIENT, 10.0f, 1.0f, false);
                    }
                    if (this.chickenAnimTime == 0) {
                        this.chickenSpoke = true;
                    }
                }
            }
        }
        if (this.chickenEnemy) {
            if (this.invokeTimer <= 0) {
                if (this.warningLevel > 0) {
                    this.teleportChicken();
                }
                this.invokeTimer = 400;
                ++this.wave;
                if (this.wave > 6 && this.warningLevel < 3) {
                    this.warningLevel = Math.min(this.warningLevel + 1, 3);
                    this.wave = 0;
                    this.playChickenWarning = true;
                } else {
                    this.playChickenWarning = false;
                }
                this.wave = Math.min(this.wave, 6);
                if (!this.level.f_46443_) {
                    PacketHandler.sendToPlayer(new PacketSyncPlayerData(this.saveChickenEnemyData(), false, player.m_19879_()), (ServerPlayer)player);
                }
            } else {
                --this.invokeTimer;
            }
        }
        if (player instanceof ServerPlayer) {
            if (this.dirty) {
                PacketHandler.sendToPlayer(new PacketSyncImplant(player.m_19879_(), this.implantStore.store), (ServerPlayer)player);
                PacketHandler.sendToPlayer(new PacketSyncSkill(this.skills.upgrades, this.passives.upgrades), (ServerPlayer)player);
                this.dirty = false;
            }
            PacketHandler.sendToPlayer(new PacketSyncPosHotBar(this.posSelectUpgrade), (ServerPlayer)player);
        }
        if (!this.getPassives().upgrades.isEmpty()) {
            this.getPassives().upgrades.forEach((i, passive) -> passive.getUpgrade().tick(this));
        }
        if (Util.hasMultiArm(this)) {
            if (!this.skills.getSkills().isEmpty()) {
                this.skills.getSkills().forEach(e -> e.getUpgrade().tick(this));
            }
            this.stopAimingAnim0 = this.stopAimingAnim;
            this.timeCharge0 = this.timeCharge;
            if (this.pose == SkillPose.STOP_AIMING && this.stopAimingAnim > 0) {
                --this.stopAimingAnim;
                if (this.stopAimingAnim == 0) {
                    this.pose = SkillPose.NONE;
                }
            }
            if (this.level.f_46443_) {
                this.timeShoot0 = this.timeShoot;
                if (this.timeShoot > 0) {
                    --this.timeShoot;
                }
                if (this.pose == SkillPose.CHARGE_CLAWS && this.timeCharge > 0) {
                    --this.timeCharge;
                }
            }
        }
    }

    private BossEvent.BossBarColor getColorForWarningLevel() {
        switch (this.warningLevel) {
            case 2: {
                return BossEvent.BossBarColor.YELLOW;
            }
            case 3: {
                return BossEvent.BossBarColor.RED;
            }
        }
        return BossEvent.BossBarColor.BLUE;
    }

    private void teleportChicken() {
        float chanceLeader = this.chanceLeaderSpawn[this.warningLevel - 1];
        for (EntityTypeWaves wave : EntityTypeWaves.values()) {
            int length;
            int n = length = wave.waves[this.wave] > 0 ? wave.waves[this.wave] + this.level.f_46441_.m_216339_(0, 2) : 0;
            boolean hasShield = this.warningLevel == 2 || wave.type.equals(BKEntityType.PUNCH_CHICKEN.get()) ? true : (this.warningLevel > 1 || this.wave == 6 ? this.level.f_46441_.m_188499_() : false);
            if (wave.type.equals(BKEntityType.PUNCH_CHICKEN.get())) {
                length = this.level.f_46441_.m_188501_() < chanceLeader ? 1 : 0;
            }
            for (int i = 0; i < length; ++i) {
                TeleportEntity tp = new TeleportEntity(this.level, wave.type, Util.findCaveSurfaceNearHeight((Entity)this.player, 10, this.level.f_46441_), (LivingEntity)this.player, hasShield);
                this.level.m_7967_((Entity)tp);
            }
        }
    }

    public static float getJumpBoost(Player player) {
        MultiArmCapability cap = MultiArmCapability.get(player);
        if (cap != null) {
            return cap.passives.getForName((String)"coil_feet").name != "none" ? ((CoilFeet)cap.passives.getForName("coil_feet")).getJumpBoost() : 1.0f;
        }
        return 1.0f;
    }

    public static boolean hasEffect(MobEffect effect, Player player) {
        MultiArmCapability cap = MultiArmCapability.get(player);
        if (cap != null) {
            return cap.passives.upgrades.values().stream().anyMatch(e -> e.getUpgrade().hasEffect(cap, effect));
        }
        return false;
    }

    public static boolean canEffect(MobEffect effect, Player player) {
        MultiArmCapability cap = MultiArmCapability.get(player);
        if (cap != null) {
            return cap.passives.upgrades.values().stream().allMatch(e -> e.getUpgrade().canEffect(cap, effect));
        }
        return false;
    }

    @Override
    public void onJoinGame(Player player, EntityJoinLevelEvent event) {
        this.dirty = true;
    }

    public void clearAbilityStore() {
        Upgrades map = new Upgrades(new HashMap<Integer, UpgradeInstance>());
        this.setSetHotbar(map);
        this.dirty = true;
    }

    public void clearForUpgradeStore() {
        this.passives = new Upgrades(new HashMap<Integer, UpgradeInstance>());
        this.dirty = true;
    }

    public void clearForIndex(int index) {
        Upgrades map = new Upgrades(this.passives.getUpgrades());
        map.upgrades.put(index, new UpgradeInstance(Upgrade.NONE, 0));
        this.passives = map;
        this.dirty = true;
    }

    public void addNewPassive(Upgrade skill, int index) {
        Upgrades map = new Upgrades(Util.getMapEmpty());
        for (Map.Entry<Integer, UpgradeInstance> entry : this.passives.getUpgrades().entrySet()) {
            map.addMultiArmSkillAbstracts(entry.getKey(), entry.getValue().getUpgrade());
        }
        map.addMultiArmSkillAbstracts(index, skill);
        this.passives = map;
        this.dirty = true;
    }

    public void addNewAbility(Upgrade skill) {
        Upgrades map = new Upgrades(this.getHotBarSkill().upgrades);
        int indexForUpgrade = Util.getIndexForName(skill.name);
        if (indexForUpgrade != -1) {
            map.addMultiArmSkillAbstracts(indexForUpgrade, skill);
            this.setSetHotbar(map);
            this.setPosSelectUpgrade(indexForUpgrade);
            this.dirty = true;
        }
    }

    public void setSetHotbar(Upgrades skillAbstracts) {
        this.skills = skillAbstracts;
    }

    @Override
    public void handledSkill(Upgrade power) {
        power.startAbility(this);
    }

    @Override
    public void stopSkill(Upgrade power) {
        this.setLastUsingSkill(Upgrade.NONE);
        power.stopAbility(this);
    }

    @Override
    public boolean canUseSkill(Upgrade skillAbstract) {
        return this.player.m_21205_().m_41619_() && !skillAbstract.name.equals("none");
    }

    @Override
    public Upgrades getPassives() {
        return this.passives;
    }

    @Override
    public Upgrades getHotBarSkill() {
        return this.skills;
    }

    @Override
    public void startCasting(Player player) {
        if (!this.level.f_46443_) {
            PacketHandler.sendToPlayer(new PacketHandlerPowers(0, (Entity)player, player), (ServerPlayer)player);
        }
        if (this.canUseSkill(this.getSelectSkill())) {
            if (this.getSelectSkill().isCasting) {
                this.startCasting(this.getSelectSkill(), this.player);
            } else if (this.getSelectSkill().isCanReActive()) {
                Upgrade power = this.getSelectSkill();
                this.setLastUsingSkill(this.getSelectSkill());
                this.handledSkill(power);
            }
        }
    }

    public void stopCasting(Player player) {
        if (!this.level.f_46443_) {
            PacketHandler.sendToPlayer(new PacketHandlerPowers(2, (Entity)player, player), (ServerPlayer)player);
        }
        if (this.getLastUsingSkill() == this.getSelectSkill()) {
            this.stopSkill(this.getSelectSkill());
        }
    }

    public void startCasting(Upgrade power, Player player) {
        this.setLastUsingSkill(this.getSelectSkill());
        this.handledSkill(power);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = this.saveChickenEnemyData();
        tag.m_128379_("publicEnemy", this.chickenEnemy);
        this.skills.save(tag);
        this.implantStore.save(tag);
        CompoundTag passiveTag = new CompoundTag();
        this.passives.save(passiveTag);
        tag.m_128365_("passives", (Tag)passiveTag);
        tag.m_128405_("select_power", this.posSelectUpgrade);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.skills = new Upgrades(nbt);
        this.passives = new Upgrades(nbt.m_128469_("passives"));
        this.posSelectUpgrade = nbt.m_128451_("select_power");
        this.chickenEnemy = nbt.m_128471_("publicEnemy");
        this.implantStore = new ImplantStore(nbt);
        this.warningLevel = nbt.m_128451_("warningLevel");
        this.wave = nbt.m_128451_("wave");
        this.timeLevelWarning = nbt.m_128451_("timeLevelWarning");
        this.timeLevelWarning0 = nbt.m_128451_("timeLevelWarning");
    }

    public void init(Player player) {
        this.setPlayer(player);
        this.level = player.m_9236_();
        this.playChickenWarning = false;
    }

    public static enum SkillPose {
        NONE,
        CHARGE_CLAWS,
        DASH_CLAWS,
        CHARGE_CANNON,
        STOP_AIMING;

    }

    public static enum EntityTypeWaves {
        CHICKEN_COIL((EntityType)BKEntityType.COIL_CHICKEN.get(), new int[]{1, 2, 2, 3, 3, 3, 4}),
        CHICKEN_BOOM((EntityType)BKEntityType.BOOM_CHICKEN.get(), new int[]{0, 1, 1, 2, 2, 2, 2}),
        CHICKEN_DRONE((EntityType)BKEntityType.DRONE_CHICKEN.get(), new int[]{0, 0, 0, 0, 1, 2, 3}),
        CHICKEN_PUNCH((EntityType)BKEntityType.PUNCH_CHICKEN.get(), new int[]{0, 0, 0, 0, 0, 0, 0});

        public final int[] waves;
        public final EntityType<?> type;

        private EntityTypeWaves(EntityType<?> type, int[] waves) {
            this.type = type;
            this.waves = waves;
        }
    }

    public static class SkillPlayerProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<IMultiArmPlayer> instance = LazyOptional.of(MultiArmCapability::new);

        public <T> @NonNull @NotNull LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CRCCapability.MULTIARM_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)((IMultiArmPlayer)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((IMultiArmPlayer)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
        }
    }
}

