/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.entity;

import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKParticles;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.entity.RobotChicken;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoomChicken
extends RobotChicken {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(BoomChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LAUNCH = SynchedEntityData.m_135353_(BoomChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idle = new AnimationState();
    public AnimationState air = new AnimationState();
    public AnimationState stand = new AnimationState();
    public int idleAnimationTimeout = 0;
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    public int standTimer = 0;

    public BoomChicken(Level p_21684_) {
        super((EntityType<? extends PathfinderMob>)((EntityType)BKEntityType.BOOM_CHICKEN.get()), p_21684_);
    }

    public BoomChicken(EntityType<BoomChicken> boomChickenEntityType, Level level) {
        super(boomChickenEntityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal(this, 1.0, false){

            public boolean m_8036_() {
                return super.m_8036_() && BoomChicken.this.m_20096_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_147223_() {
        return this.isLaunch();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(IS_LAUNCH, (Object)false);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 45.0).m_22268_(Attributes.f_22279_, 0.31).m_22265_();
    }

    public void calculateRotPosition(BlockPos from, BlockPos to) {
        double g = 0.08;
        double dx = (double)to.m_123341_() + 0.5 - ((double)from.m_123341_() + 0.5);
        double dy = to.m_123342_() - from.m_123342_();
        double dz = (double)to.m_123343_() + 0.5 - ((double)from.m_123343_() + 0.5);
        int ticks = 70;
        double vx = dx / (double)ticks;
        double vz = dz / (double)ticks;
        double vy = (dy + 0.5 * g * (double)ticks * (double)ticks) / (double)ticks;
        this.updateRot(new Vec3(vx, vy, vz), true);
    }

    private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
        float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
        float clampedDelta = Mth.m_14036_((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
        return currentYaw + clampedDelta;
    }

    public void updateRot(Vec3 vec3, boolean flag) {
        if (flag) {
            this.m_146922_((float)(Mth.m_14136_((double)(-vec3.f_82479_), (double)(-vec3.f_82481_)) * 57.2957763671875));
        } else {
            this.m_146922_(this.lerpRotation(this.m_146908_(), (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875), 5.0f));
        }
        this.m_146926_(this.lerpRotation(this.m_146909_(), (float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 57.2957763671875), 5.0f));
    }

    public Vec3 calculateJumpVelocity(BlockPos from, BlockPos to) {
        double g = 0.08;
        double dx = (double)to.m_123341_() + 0.5 - ((double)from.m_123341_() + 0.5);
        double dy = to.m_123342_() - from.m_123342_();
        double dz = (double)to.m_123343_() + 0.5 - ((double)from.m_123343_() + 0.5);
        int ticks = 40;
        double vx = dx / (double)ticks;
        double vz = dz / (double)ticks;
        double vy = (dy + 0.5 * g * (double)ticks * (double)ticks) / (double)ticks;
        return new Vec3(vx, vy, vz);
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
        if (!this.isLaunch()) {
            super.m_7840_(p_20990_, p_20991_, p_20992_, p_20993_);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.oldSwell = this.swell;
            int i = this.getSwellDir();
            if (i > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
            if (this.standTimer > 0) {
                --this.standTimer;
                this.m_20256_(Vec3.f_82478_);
                if (this.standTimer <= 0 && this.m_9236_().f_46443_) {
                    this.stand.m_216973_();
                }
            }
            if (this.isLaunch() && this.m_20096_()) {
                this.standTimer = 18;
                this.setIsLaunch(false);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)4);
                }
            }
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    private void explodeCreeper() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            Util.createExplosion((Entity)this, this.m_9236_(), this.m_20183_(), 3.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)8);
            this.m_146870_();
        }
    }

    public boolean isLaunch() {
        return (Boolean)this.f_19804_.m_135370_(IS_LAUNCH);
    }

    public void setIsLaunch(boolean isLaunch) {
        this.f_19804_.m_135381_(IS_LAUNCH, (Object)isLaunch);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 5;
            this.idle.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        this.air.m_246184_(!this.m_20096_(), this.f_19797_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)BKSounds.CHICKEN_BOMB_LOOP.get();
    }

    public boolean m_7327_(Entity p_21372_) {
        return false;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.idle.m_216973_();
            this.air.m_216973_();
            this.idleAnimationTimeout = 18;
            this.stand.m_216977_(this.f_19797_);
            this.standTimer = 18;
            this.setIsLaunch(false);
        } else if (p_21375_ == 8) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)BKParticles.ELECTRO_EXPLOSION_PARTICLES.get(), this.m_20185_() + (double)this.f_19796_.m_216339_(-2, 2), this.m_20186_() + (double)this.f_19796_.m_216339_(0, 2), this.m_20189_() + (double)this.f_19796_.m_216339_(-2, 2), 0.0, 0.0, 0.0);
            }
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, 1.0f, false);
        }
        super.m_7822_(p_21375_);
    }

    static class SwellGoal
    extends Goal {
        private final BoomChicken creeper;
        @javax.annotation.Nullable
        private LivingEntity target;

        public SwellGoal(BoomChicken p_25919_) {
            this.creeper = p_25919_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.creeper.m_5448_();
            return this.creeper.getSwellDir() > 0 || livingentity != null && this.creeper.m_20280_((Entity)livingentity) < 9.0;
        }

        public void m_8056_() {
            this.creeper.m_21573_().m_26573_();
            this.target = this.creeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.creeper.setSwellDir(-1);
            } else if (this.creeper.m_20280_((Entity)this.target) > 49.0) {
                this.creeper.setSwellDir(-1);
            } else if (!this.creeper.m_21574_().m_148306_((Entity)this.target)) {
                this.creeper.setSwellDir(-1);
            } else {
                this.creeper.setSwellDir(1);
            }
        }
    }
}

