/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.entity;

import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.entity.ElectroProjectile;
import com.TBK.crc.server.entity.RobotChicken;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class DroneChicken
extends RobotChicken {
    public AnimationState idle = new AnimationState();
    public AnimationState air = new AnimationState();
    public AnimationState stand = new AnimationState();
    public int idleAnimationTimeout = 0;
    public BlockPos blockTargetActually = null;

    public DroneChicken(Level p_21684_) {
        super((EntityType<? extends PathfinderMob>)((EntityType)BKEntityType.DRONE_CHICKEN.get()), p_21684_);
    }

    public DroneChicken(EntityType<DroneChicken> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.m_20242_(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new DroneAttack(this, 0.75, 7.0, 3, 7));
        this.f_21345_.m_25352_(4, (Goal)new DroneFlyGoal(this, 0.2f, 4, 10));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 45.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22280_, 0.24).m_22265_();
    }

    private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
        float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
        float clampedDelta = Mth.m_14036_((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
        return currentYaw + clampedDelta;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 20;
            this.idle.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        this.air.m_246184_(!this.m_20096_(), this.f_19797_);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.m_9236_().m_245747_(this.m_20183_().m_7494_(), (SoundEvent)BKSounds.MULTIARM_CANNON_NORMAL_SHOT.get(), SoundSource.HOSTILE, 5.0f, 1.0f, false);
        }
        super.m_7822_(p_21375_);
    }

    public boolean m_7327_(Entity p_21372_) {
        return true;
    }

    static class DroneAttack
    extends Goal {
        private final DroneChicken drone;
        private final double speed;
        private double circleRadius;
        private final Level world;
        private double circlingAngle;
        private final int minAltitude;
        private final int maxAltitude;
        private Vec3 circlingPosition;
        private int attackCooldown = 0;
        public boolean meleeAttack = false;
        public boolean rot = false;
        private Mode mode = Mode.ORBIT;
        private int ammo = 0;
        private int orbitTime = 0;

        public DroneAttack(DroneChicken drone, double speed, double circleRadius, int minAltitude, int maxAltitude) {
            this.drone = drone;
            this.speed = speed;
            this.circleRadius = circleRadius;
            this.minAltitude = minAltitude;
            this.maxAltitude = maxAltitude;
            this.world = drone.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.circlingAngle = 0.0;
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity potentialTarget = this.drone.m_5448_();
            if (potentialTarget instanceof Player && (player = (Player)potentialTarget).m_7500_()) {
                return false;
            }
            return potentialTarget != null && potentialTarget.m_6084_();
        }

        public void m_8056_() {
            this.circlingPosition = null;
            this.circlingAngle = 0.0;
            this.attackCooldown = 0;
            this.resetRot();
            this.drone.blockTargetActually = null;
            this.circleRadius = 7.0;
            this.orbitTime = 0;
        }

        public void resetRot() {
            this.rot = this.world.f_46441_.m_188499_();
        }

        public void startOrbit() {
            this.mode = Mode.ORBIT;
            this.orbitTime = 100 + (int)(this.drone.f_19796_.m_188501_() * 200.0f);
        }

        public boolean m_8045_() {
            Player playerEntity;
            LivingEntity livingEntity = this.drone.m_5448_();
            if (livingEntity instanceof Player && ((playerEntity = (Player)livingEntity).m_7500_() || playerEntity.m_20147_())) {
                return false;
            }
            return livingEntity != null && livingEntity.m_6084_();
        }

        public void m_8041_() {
            this.circlingPosition = null;
        }

        public void m_8037_() {
            LivingEntity target = this.drone.m_5448_();
            if (target != null) {
                boolean collision;
                if (this.drone.blockTargetActually == null) {
                    this.drone.blockTargetActually = new BlockPos((int)target.m_20185_(), (int)target.m_20186_(), (int)target.m_20189_());
                }
                double distanceToTarget = this.drone.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                int x = this.drone.blockTargetActually.m_123341_();
                int y = this.drone.blockTargetActually.m_123342_();
                int z = this.drone.blockTargetActually.m_123343_();
                double heightOffset = 6.0;
                boolean bl = collision = !this.drone.m_9236_().m_45756_((Entity)this.drone, this.drone.m_20191_().m_82400_((double)0.1f));
                if (collision) {
                    this.mode = Mode.ATTACK;
                }
                switch (this.mode) {
                    case ORBIT: {
                        double offsetX = Math.cos(this.circlingAngle) * this.circleRadius;
                        double offsetZ = Math.sin(this.circlingAngle) * this.circleRadius;
                        this.circlingPosition = new Vec3((double)x + offsetX, (double)y + heightOffset, (double)z + offsetZ);
                        Vec3 direction = this.circlingPosition.m_82546_(this.drone.m_20182_()).m_82541_().m_82490_((double)0.6f);
                        Vec3 currentMotion = this.drone.m_20184_();
                        Vec3 smoothedMotion = currentMotion.m_82549_(direction.m_82546_(currentMotion).m_82490_(0.25));
                        this.drone.m_20256_(smoothedMotion);
                        double distanceToCirclePoint = this.drone.m_20182_().m_82554_(this.circlingPosition);
                        if (distanceToCirclePoint < 1.5) {
                            this.circlingAngle += this.rot ? (double)0.05f : (double)-0.05f;
                        }
                        if (this.circlingAngle > Math.PI * 3 || this.circlingAngle < Math.PI * -3) {
                            this.circlingAngle = 0.0;
                            this.drone.blockTargetActually = new BlockPos((int)target.m_20185_(), (int)target.m_20186_(), (int)target.m_20189_());
                        }
                        this.rotateTowardsDelta();
                        if (this.orbitTime-- >= 0) break;
                        this.mode = Mode.ORBIT_ATTACK;
                        this.ammo = this.drone.f_19796_.m_216339_(3, 5);
                        break;
                    }
                    case ORBIT_ATTACK: {
                        this.drone.m_146884_(this.drone.m_20182_());
                        if (this.drone.m_20186_() > target.m_20186_() + 2.0) {
                            this.drone.m_20256_(new Vec3(0.0, -0.3, 0.0));
                        } else {
                            this.drone.m_20256_(Vec3.f_82478_);
                        }
                        this.rotateTowardsTarget(target);
                        Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() * 0.5f), target.m_20189_());
                        Vec3 toTarget = targetPos.m_82546_(this.drone.m_20182_());
                        double dist = Math.sqrt(distanceToTarget);
                        if (this.attackCooldown > 0) {
                            --this.attackCooldown;
                        } else if (dist <= 20.0) {
                            ElectroProjectile electro = new ElectroProjectile(this.drone.m_9236_(), (LivingEntity)this.drone, 0);
                            electro.m_146884_(this.drone.m_20182_());
                            electro.m_6686_(toTarget.f_82479_, toTarget.f_82480_, toTarget.f_82481_, 2.0f, 1.0f);
                            this.drone.m_9236_().m_7967_((Entity)electro);
                            this.drone.m_9236_().m_7605_((Entity)this.drone, (byte)4);
                            this.attackCooldown = 30;
                            --this.ammo;
                        } else {
                            this.startOrbit();
                        }
                        if (this.ammo > 0) break;
                        this.startOrbit();
                        break;
                    }
                    case ATTACK: {
                        double desiredDistance = 10.0;
                        double dist = Math.sqrt(distanceToTarget);
                        Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() * 0.5f), target.m_20189_());
                        Vec3 toTarget = targetPos.m_82546_(this.drone.m_20182_());
                        this.rotateTowardsTarget(target);
                        if (this.drone.m_20186_() > target.m_20186_() + 2.0) {
                            this.drone.m_20256_(new Vec3(0.0, -0.3, 0.0));
                        } else {
                            this.drone.m_20256_(Vec3.f_82478_);
                        }
                        Vec3 direction = dist > desiredDistance + 2.0 ? toTarget.m_82541_().m_82490_((double)0.8f) : (dist < desiredDistance - 1.0 ? toTarget.m_82541_().m_82490_((double)-0.1f) : Vec3.f_82478_);
                        this.drone.m_20256_(direction.m_82490_(0.5));
                        if (this.attackCooldown > 0) {
                            --this.attackCooldown;
                        } else if (dist <= 20.0) {
                            ElectroProjectile electro = new ElectroProjectile(this.drone.m_9236_(), (LivingEntity)this.drone, 0);
                            electro.m_146884_(this.drone.m_20182_());
                            electro.m_6686_(toTarget.f_82479_, toTarget.f_82480_, toTarget.f_82481_, 2.0f, 1.0f);
                            this.drone.m_9236_().m_7967_((Entity)electro);
                            this.drone.m_9236_().m_7605_((Entity)this.drone, (byte)4);
                            this.attackCooldown = 40;
                        }
                        if (collision || !(dist <= this.circleRadius * 1.5)) break;
                        this.startOrbit();
                    }
                }
            }
        }

        public boolean m_183429_() {
            return true;
        }

        private void rotateTowardsTarget(LivingEntity target) {
            Vec3 direction = target.m_20182_().m_82546_(this.drone.m_20182_());
            double dx = direction.f_82479_;
            double dy = direction.f_82480_;
            double dz = direction.f_82481_;
            double targetYaw = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
            double pitch = -Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)));
            this.drone.m_146922_(this.lerpRotation(this.drone.m_146908_(), (float)targetYaw, 30.0f));
            this.drone.m_146926_((float)pitch);
        }

        private void rotateTowardsDelta() {
            Vec3 direction = this.drone.m_20184_();
            double dx = direction.f_82479_;
            double dy = direction.f_82480_;
            double dz = direction.f_82481_;
            double targetYaw = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
            double pitch = -Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)));
            this.drone.m_146922_(this.lerpRotation(this.drone.m_146908_(), (float)targetYaw, 30.0f));
            this.drone.m_146926_((float)pitch);
        }

        private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
            float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
            float clampedDelta = Mth.m_14036_((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
            return currentYaw + clampedDelta;
        }

        static enum Mode {
            ORBIT,
            ORBIT_ATTACK,
            ATTACK;

        }
    }

    public static class DroneFlyGoal
    extends Goal {
        private final DroneChicken drone;
        private final double speed;
        private final int minAltitude;
        private final int maxAltitude;
        private Vec3 targetPos;
        private final double targetThreshold = 1.5;
        private int chargeTime = 0;
        private int idleTime = 0;
        private boolean isIdle = false;
        private int oldY = 0;

        public DroneFlyGoal(DroneChicken drone, double speed, int minAltitude, int maxAltitude) {
            this.drone = drone;
            this.speed = speed;
            this.minAltitude = minAltitude;
            this.maxAltitude = maxAltitude;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.drone.m_6084_() && !this.isIdle;
        }

        public void m_8056_() {
            if (!this.isIdle) {
                if (this.targetPos != null && this.drone.m_20182_().m_82554_(this.targetPos) < 1.5) {
                    this.targetPos = this.getRandomAirPosition();
                    if (this.targetPos == null || (double)this.drone.m_217043_().m_188501_() < 0.4) {
                        this.enterIdleMode();
                        return;
                    }
                }
                if (this.targetPos != null) {
                    Vec3 direction = this.targetPos.m_82546_(this.drone.m_20182_()).m_82541_().m_82490_(this.speed);
                    this.drone.m_20256_(direction);
                    this.oldY = this.drone.m_20183_().m_123342_();
                    this.drone.m_21563_().m_24946_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_);
                    this.rotateTowardsTarget();
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.isIdle) {
                return this.idleTime > 0;
            }
            if (!this.drone.m_6084_()) {
                return this.targetPos != null && !(this.drone.m_20182_().m_82554_(this.targetPos) >= 1.5);
            }
            return !this.drone.m_5912_();
        }

        public void m_8037_() {
            if (this.isIdle) {
                --this.idleTime;
                this.drone.m_20256_(Vec3.f_82478_);
                if (this.idleTime <= 0) {
                    this.isIdle = false;
                }
            } else {
                if (this.drone.m_20096_()) {
                    this.targetPos = this.getRandomAirPosition();
                }
                if (this.targetPos != null && this.oldY == this.drone.m_20183_().m_123342_()) {
                    this.chargeTime += 20;
                }
                if (this.chargeTime > 100) {
                    this.chargeTime = 0;
                    this.targetPos = this.getRandomAirPosition();
                }
                if (this.targetPos != null && this.drone.m_20182_().m_82554_(this.targetPos) < 1.5) {
                    this.targetPos = this.getRandomAirPosition();
                }
                if (this.targetPos != null) {
                    Vec3 direction = this.targetPos.m_82546_(this.drone.m_20182_()).m_82541_().m_82490_(this.speed);
                    this.drone.m_20256_(direction);
                    this.oldY = this.drone.m_20183_().m_123342_();
                    this.drone.m_21563_().m_24946_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_);
                    this.rotateTowardsTarget();
                }
            }
        }

        private void enterIdleMode() {
            this.idleTime = this.drone.m_217043_().m_188503_(41) + 20;
            this.isIdle = true;
            this.drone.m_20256_(Vec3.f_82478_);
        }

        private Vec3 getRandomAirPosition() {
            RandomSource random = this.drone.m_217043_();
            Level world = this.drone.m_9236_();
            BlockPos currentPos = this.drone.m_20183_();
            int groundHeight = world.m_6924_(Heightmap.Types.WORLD_SURFACE, currentPos.m_123341_(), currentPos.m_123343_());
            int altitudeRange = this.maxAltitude - this.minAltitude;
            Vec3 targetPos = null;
            for (int i = 0; i < 10; ++i) {
                double z;
                double newY = (double)(groundHeight + this.minAltitude) + random.m_188500_() * (double)altitudeRange;
                double x = this.drone.m_20185_() + (random.m_188500_() * 20.0 - 10.0);
                Vec3 targetPosAux = new Vec3(x, newY, z = this.drone.m_20189_() + (random.m_188500_() * 20.0 - 10.0));
                BlockPos targetBlockPos = BlockPos.m_274446_((Position)targetPosAux);
                if (!this.isValidFlyPosition(world, targetBlockPos)) continue;
                targetPos = targetPosAux;
            }
            return targetPos;
        }

        private boolean isValidFlyPosition(Level world, BlockPos pos) {
            if (world.m_46859_(pos) && world.m_46859_(pos.m_7494_())) {
                BlockPos belowPos = pos.m_7495_();
                if (world.m_8055_(belowPos).m_60734_().m_7705_().contains("leaves")) {
                    return false;
                }
                for (BlockPos adjacentPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                    if (!world.m_8055_(adjacentPos).m_60734_().m_7705_().contains("leaves")) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void rotateTowardsTarget() {
            Vec3 currentPosition = this.drone.m_20182_();
            Vec3 directionToTarget = this.targetPos.m_82546_(currentPosition).m_82541_();
            double yaw = Math.toDegrees(Math.atan2(directionToTarget.f_82481_, directionToTarget.f_82479_)) - 90.0;
            double pitch = -Math.toDegrees(Math.atan2(directionToTarget.f_82480_, Math.sqrt(directionToTarget.f_82479_ * directionToTarget.f_82479_ + directionToTarget.f_82481_ * directionToTarget.f_82481_)));
            this.drone.m_146922_((float)yaw);
            this.drone.m_146926_((float)pitch);
        }
    }
}

