/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.entity;

import com.TBK.crc.client.animacion.RexChickenAnim;
import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.common.registry.BKSounds;
import com.TBK.crc.server.StructureData;
import com.TBK.crc.server.entity.BeamExplosionEntity;
import com.TBK.crc.server.entity.RexPart;
import com.TBK.crc.server.entity.RobotChicken;
import com.TBK.crc.server.fight.CyberChickenFight;
import com.TBK.crc.server.network.PacketHandler;
import com.TBK.crc.server.network.messager.PacketActionRex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class RexChicken
extends PathfinderMob
implements PowerableMob {
    public static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(RexChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DEATH = SynchedEntityData.m_135353_(RexChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(RexChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LASER = SynchedEntityData.m_135353_(RexChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CIR_LASER = SynchedEntityData.m_135353_(RexChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> SHIELD_AMOUNT = SynchedEntityData.m_135353_(RexChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState idle = new AnimationState();
    public AnimationState attack = new AnimationState();
    public AnimationState charge = new AnimationState();
    public AnimationState prepareCharge = new AnimationState();
    public AnimationState stunned = new AnimationState();
    public AnimationState recovery = new AnimationState();
    public AnimationState idleDeath = new AnimationState();
    public AnimationState death = new AnimationState();
    public Vec3 chargeDirection = Vec3.f_82478_;
    public BlockPos lastBlockBeam = null;
    public BlockPos lastBlockPosBeamExplosion = null;
    public float rotHeadY = 0.0f;
    public float rotHeadY0 = 0.0f;
    public float rotHeadX = 0.0f;
    public float rotHeadX0 = 0.0f;
    public int idleAnimationTimeout = 0;
    public int attackTimer = 0;
    public int prepareChargeTimer = 0;
    public int chargeTimer = 0;
    public int cooldownCharge = 0;
    public int stunnedTick = 0;
    public int prepareLaser = 0;
    public int cooldownLaser = 0;
    public int restTime = 0;
    public int regenerationShieldTimer = 0;
    public float speedLaserModifier = 0.0f;
    public int deathAnimTime = 0;
    public int deathTime = 0;
    public int recoveryTimer = 0;
    public RexPart<?> head = new RexPart<RexChicken>(this, "head", 2.0f, 2.0f);
    public RexPart<?> body = new RexPart<RexChicken>(this, "body", 8.0f, 10.0f);
    public RexPart<?> towerMissile1 = new RexPart<RexChicken>(this, "towerMissile1", 4.0f, 4.0f, true);
    public RexPart<?> towerMissile2 = new RexPart<RexChicken>(this, "towerMissile2", 4.0f, 4.0f, true);
    public RexPart<?>[] towers;
    public RexPart<?>[] parts = new RexPart[]{this.head, this.body, this.towerMissile1, this.towerMissile2};
    public CyberChickenFight fight;
    public int hurtShield = 0;
    private boolean step1Played = false;
    private boolean step2Played = false;
    private boolean lift1Played = false;
    private boolean lift2Played = false;

    public RexChicken(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.towers = new RexPart[]{this.towerMissile1, this.towerMissile2};
        this.m_20234_(f_19843_.getAndAdd(this.parts.length + 1) + 1);
        this.setShieldAmount(0);
        this.fight = !this.m_9236_().f_46443_ ? StructureData.get().getCyberChickenFight() : null;
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 180.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 18.0).m_22265_();
    }

    public Entity getPartForId(int id) {
        return Arrays.stream(this.parts).filter(e -> e.m_19879_() == id).findFirst().orElse(null);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(this, 1.1, false));
        this.f_21345_.m_25352_(2, (Goal)new ChargedGoal(this, 2.5));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected void m_267689_(float p_268362_) {
        float f;
        if (this.m_20089_() == Pose.STANDING) {
            f = Math.min(p_268362_ * 6.0f, 1.0f);
        } else {
            this.idleAnimationTimeout = 1;
            this.idle.m_216973_();
            f = 0.0f;
        }
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public Vec3 getHeadPos() {
        Vec3 base = this.head.m_20182_();
        double x = base.f_82479_;
        double y = base.f_82480_;
        double z = base.f_82481_;
        return new Vec3(x, y, z);
    }

    public Vec3 getBeamDirection() {
        Vec3 direction = this.lastBlockBeam != null ? this.lastBlockBeam.m_252807_().m_82546_(this.getHeadPos()) : this.viewHeadY().m_82490_(100.0);
        return direction;
    }

    public Vec3 viewHeadY() {
        return this.m_20171_(this.rotHeadX, this.rotHeadY + this.m_146908_());
    }

    private void tickPart(RexPart<?> p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() + p_31117_, this.m_20186_() + p_31118_, this.m_20189_() + p_31119_);
        p_31116_.m_8119_();
    }

    public boolean m_7327_(Entity p_21372_) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            p_21372_.m_6469_(Util.electricDamageMob(serverLevel, (Mob)this), (float)this.m_21051_(Attributes.f_22281_).m_22115_());
        }
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isDeath() || this.deathAnimTime > 0) {
            if (this.deathAnimTime > 0) {
                --this.deathAnimTime;
                if (this.deathAnimTime == 0) {
                    if (this.fight != null) {
                        this.fight.setDragonKilled(this);
                    }
                    this.setDeath(true);
                }
            }
            float f = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
            if (this.isDeath() && this.m_9236_() instanceof ServerLevel && this.deathTime++ > 100) {
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)1395);
                this.m_146870_();
            }
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        } else {
            double f6;
            double f5;
            this.rotHeadY0 = this.rotHeadY;
            this.rotHeadX0 = this.rotHeadX;
            float yawRad = (float)Math.toRadians(this.m_146908_());
            float sin = (float)Math.sin(yawRad);
            float cos = (float)Math.cos(yawRad);
            double tower1X = -5.0f * cos + 4.0f * sin;
            double tower1Y = -5.0f * sin - 4.0f * cos;
            double tower2X = 5.0f * cos + 4.0f * sin;
            double tower2Y = 5.0f * sin - 4.0f * cos;
            double headX = this.stunnedTick > 0 ? (double)(-5.0f * sin) : (double)(-3.0f * sin);
            double headY = this.stunnedTick > 0 ? 2.0 : 7.0;
            double headZ = this.stunnedTick > 0 ? (double)(5.0f * cos) : (double)(-(-3.0f * cos));
            Vec3[] pos = new Vec3[this.parts.length];
            for (int j = 0; j < this.parts.length; ++j) {
                pos[j] = new Vec3(this.parts[j].m_20185_(), this.parts[j].m_20186_(), this.parts[j].m_20189_());
            }
            this.tickPart(this.body, 0.0, 0.0, 0.0);
            this.tickPart(this.head, headX, headY, headZ);
            this.tickPart(this.towerMissile1, tower1X, 8.0, tower1Y);
            this.tickPart(this.towerMissile2, tower2X, 8.0, tower2Y);
            for (int k = 0; k < this.parts.length; ++k) {
                this.parts[k].f_19854_ = pos[k].f_82479_;
                this.parts[k].f_19855_ = pos[k].f_82480_;
                this.parts[k].f_19856_ = pos[k].f_82481_;
                this.parts[k].f_19790_ = pos[k].f_82479_;
                this.parts[k].f_19791_ = pos[k].f_82480_;
                this.parts[k].f_19792_ = pos[k].f_82481_;
            }
            if (this.restTime > 0) {
                --this.restTime;
            }
            this.tickHead();
            if (this.prepareLaser > 0) {
                this.m_21573_().m_26573_();
                --this.prepareLaser;
                if (this.m_5448_() != null) {
                    Vec3 vec32 = this.m_5448_().m_146892_().m_82546_(this.getHeadPos());
                    f5 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
                    f6 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0;
                    this.f_20885_ = (float)f6;
                    this.m_5616_((float)f6);
                    this.f_20883_ = (float)f6;
                    this.m_146922_((float)f6);
                    this.m_146926_((float)f5);
                    this.m_19915_(this.m_146908_(), this.m_146909_());
                    if (this.isLaserSemiCir()) {
                        this.rotHeadX = (float)f5;
                        this.rotHeadY = -60.0f;
                    } else {
                        this.rotHeadX = 45.0f;
                        this.rotHeadY = (float)f6 - this.m_146908_();
                    }
                }
                if (this.prepareLaser <= 0 && !this.m_9236_().f_46443_) {
                    this.setLaser(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)18);
                }
            }
            if (this.recoveryTimer > 0) {
                --this.recoveryTimer;
                this.m_21573_().m_26573_();
                if (this.recoveryTimer <= 0 && !this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)16);
                }
            }
            if (this.stunnedTick > 0) {
                --this.stunnedTick;
                this.m_21573_().m_26573_();
                if (this.stunnedTick > 280) {
                    Vec3 vec32 = this.chargeDirection;
                    if (!this.m_9236_().f_46443_) {
                        f5 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
                        f6 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0;
                        this.f_20885_ = (float)f6;
                        this.m_5616_((float)f6);
                        this.f_20883_ = (float)f6;
                        this.m_146922_((float)f6);
                        this.m_146926_((float)f5);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                    this.m_20256_(this.chargeDirection.m_82542_(-1.0, 1.0, -1.0));
                    this.chargeDirection = this.chargeDirection.m_82490_(0.8);
                    boolean flag = false;
                    AABB aabb = this.body.m_20191_().m_82400_(0.4);
                    for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                        if (!blockstate.m_60713_(Blocks.f_50386_) && !blockstate.m_60713_(Blocks.f_152555_) && !blockstate.m_60713_(Blocks.f_50261_)) continue;
                        flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                    }
                } else {
                    if (this.m_7090_()) {
                        this.stunnedTick = 0;
                    }
                    this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                }
                if (this.stunnedTick <= 0 && !this.m_9236_().f_46443_) {
                    this.recoveryTimer = 21;
                    this.m_9236_().m_7605_((Entity)this, (byte)17);
                }
            } else if (this.regenerationShieldTimer > 0) {
                --this.regenerationShieldTimer;
                if (this.regenerationShieldTimer <= 0 && !this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.setShieldAmount(50);
                }
            }
            if (this.cooldownLaser > 0) {
                --this.cooldownLaser;
            }
            if (this.cooldownCharge > 0) {
                --this.cooldownCharge;
            }
            if (this.prepareChargeTimer > 0) {
                this.m_21573_().m_26573_();
                this.m_20256_(Vec3.f_82478_);
                --this.prepareChargeTimer;
                if (this.m_5448_() != null) {
                    this.chargeDirection = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82542_(1.0, 0.0, 1.0);
                    if (!this.m_9236_().f_46443_) {
                        Vec3 vec32 = this.chargeDirection;
                        double f52 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
                        double f62 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0;
                        this.f_20885_ = (float)f62;
                        this.m_5616_((float)f62);
                        this.f_20883_ = (float)f62;
                        this.m_146922_((float)f62);
                        this.m_146926_((float)f52);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                }
                if (this.prepareChargeTimer <= 0 && this.m_5448_() != null) {
                    this.setCharging(true);
                    if (this.m_9236_().f_46443_) {
                        this.charge.m_216977_(this.f_19797_);
                    }
                }
            }
            if (this.isCharging()) {
                ++this.chargeTimer;
                if (!this.m_9236_().f_46443_) {
                    Vec3 vec32 = this.chargeDirection;
                    double f53 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
                    double f63 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0;
                    this.f_20885_ = (float)f63;
                    this.m_5616_((float)f63);
                    this.f_20883_ = (float)f63;
                    this.m_146922_((float)f63);
                    this.m_146926_((float)f53);
                    this.m_19915_(this.m_146908_(), this.m_146909_());
                }
                this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(3.0), e -> !this.m_7306_((Entity)e) && !(e instanceof RobotChicken)).forEach(e -> {
                    this.m_7327_((Entity)e);
                    e.m_7334_((Entity)this);
                });
                if (this.chargeTimer > 40) {
                    this.setCharging(false);
                    if (this.m_9236_().f_46443_) {
                        this.charge.m_216973_();
                    } else if (this.m_9236_().f_46441_.m_188499_()) {
                        this.restTime = (int)(50.0f + 50.0f * this.m_9236_().f_46441_.m_188501_());
                    }
                    this.chargeTimer = 0;
                    this.cooldownCharge = 100;
                }
                if (!this.m_9236_().f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                    boolean flag = false;
                    AABB aabb = this.m_20191_().m_82400_(1.0);
                    for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                        if (!blockstate.m_60713_(Blocks.f_50386_) && !blockstate.m_60713_(Blocks.f_152555_) && !blockstate.m_60713_(Blocks.f_50261_)) continue;
                        flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                    }
                    if (!flag && this.f_19862_) {
                        this.stunnedTick = 300;
                        this.setCharging(false);
                        if (!this.m_9236_().f_46443_ && !this.m_7090_()) {
                            this.m_9236_().m_7605_((Entity)this, (byte)12);
                            this.m_5496_((SoundEvent)BKSounds.REX_CRASH.get(), 6.0f, 1.0f);
                        }
                        this.chargeTimer = 0;
                        this.cooldownCharge = 100;
                    }
                }
            }
            if (this.isAttacking()) {
                --this.attackTimer;
                if (this.attackTimer == 0) {
                    this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), e -> !this.m_7306_((Entity)e) && !(e instanceof RobotChicken)).forEach(this::m_7327_);
                    this.setAttacking(false);
                    this.m_5496_((SoundEvent)BKSounds.REX_STOMP.get(), 5.0f, 1.0f);
                    for (BlockPos pos2 : BlockPos.m_121940_((BlockPos)this.m_20097_().m_7918_(5, 1, 5), (BlockPos)this.m_20097_().m_7918_(-5, -1, -5))) {
                        float entityHitDistance;
                        if (this.m_9236_().m_8055_(pos2).m_60795_() || !((entityHitDistance = Math.max((float)Math.sqrt(((double)pos2.m_123343_() - this.m_20189_()) * ((double)pos2.m_123343_() - this.m_20189_()) + ((double)pos2.m_123341_() - this.m_20185_()) * ((double)pos2.m_123341_() - this.m_20185_())), 0.0f)) <= 5.0f) || !(entityHitDistance >= 2.0f)) continue;
                        Random random1 = new Random();
                        double distance = (double)0.12f * Math.ceil(entityHitDistance) + (double)random1.nextFloat(0.0f, 1.0f);
                        BlockPos.MutableBlockPos pos1 = pos2.m_122032_();
                        boolean canSummon = true;
                        for (int i = 0; i < Mth.m_14165_((double)distance); ++i) {
                            if (!canSummon || this.m_9236_().m_8055_(pos1.m_7494_()).m_60795_()) continue;
                            canSummon = false;
                        }
                        if (!canSummon) continue;
                        for (int j = 0; j < this.m_9236_().f_46441_.m_216339_(2, 3); ++j) {
                            Minecraft.m_91087_().f_91061_.m_107367_(pos2, Direction.UP);
                        }
                    }
                }
            }
            if (this.m_9236_().f_46443_) {
                this.setupAnimationStates();
            }
            while (this.rotHeadX - this.rotHeadX0 < -180.0f) {
                this.rotHeadX0 -= 360.0f;
            }
            while (this.rotHeadX - this.rotHeadX0 >= 180.0f) {
                this.rotHeadX0 += 360.0f;
            }
            while (this.rotHeadY - this.rotHeadY0 < -180.0f) {
                this.rotHeadY0 -= 360.0f;
            }
            while (this.rotHeadY - this.rotHeadY0 >= 180.0f) {
                this.rotHeadY0 += 360.0f;
            }
            if (this.fight != null) {
                this.fight.updateDragon(this);
            }
            if (this.m_9236_().f_46443_ && !this.isCharging()) {
                this.tickStep();
            }
        }
    }

    public void tickStep() {
        float animationProgress = this.f_267362_.m_267756_();
        long time = (long)(animationProgress * 50.0f * 2.0f);
        float seconds = Util.getElapsedSeconds(RexChickenAnim.walklegs, time);
        if (!this.step1Played && seconds >= 0.92f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BKSounds.REX_STEP2.get(), SoundSource.HOSTILE, 4.0f, 1.0f, false);
            this.step1Played = true;
        }
        if (!this.step2Played && seconds >= 1.63f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BKSounds.REX_STEP2.get(), SoundSource.HOSTILE, 4.0f, 1.0f, false);
            this.step2Played = true;
        }
        if (!this.lift1Played && seconds >= 0.21f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BKSounds.REX_STEP1.get(), SoundSource.HOSTILE, 4.0f, 1.0f, false);
            this.lift1Played = true;
        }
        if (!this.lift2Played && seconds >= 1.0f) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BKSounds.REX_STEP1.get(), SoundSource.HOSTILE, 4.0f, 1.0f, false);
            this.lift2Played = true;
        }
        if (seconds < 0.2f) {
            this.step1Played = false;
            this.step2Played = false;
            this.lift1Played = false;
            this.lift2Played = false;
        }
    }

    public void tickHead() {
        if (this.isLaser()) {
            this.m_20256_(Vec3.f_82478_);
            this.m_146884_(this.m_20182_());
            if (this.isLaserSemiCir()) {
                this.speedLaserModifier = Math.min(10.0f, this.speedLaserModifier + (this.isRage() ? 0.5f : 0.25f));
                this.rotHeadY = Mth.m_14036_((float)this.lerpRotation(this.rotHeadY, this.rotHeadY + this.speedLaserModifier, 10.0f), (float)-60.0f, (float)60.0f);
                if (this.rotHeadY >= 60.0f) {
                    this.setLaser(false);
                    this.setCirLaser(false);
                    this.cooldownLaser = 200;
                    this.lastBlockPosBeamExplosion = null;
                    this.lastBlockBeam = null;
                    if (!this.m_9236_().f_46443_) {
                        if (this.m_9236_().f_46441_.m_188499_()) {
                            this.restTime = (int)(50.0f + 50.0f * this.m_9236_().f_46441_.m_188501_());
                        }
                        this.m_9236_().m_7605_((Entity)this, (byte)33);
                    }
                }
            } else {
                this.speedLaserModifier = Math.min(10.0f, this.speedLaserModifier + (this.isRage() ? 0.2f : 0.1f));
                this.rotHeadX = Mth.m_14036_((float)this.lerpRotation(this.rotHeadX, this.rotHeadX - this.speedLaserModifier, 5.0f), (float)0.0f, (float)45.0f);
                if (this.rotHeadX <= 0.0f) {
                    this.setLaser(false);
                    this.setCirLaser(true);
                    this.cooldownLaser = 200;
                    this.lastBlockPosBeamExplosion = null;
                    this.lastBlockBeam = null;
                    if (!this.m_9236_().f_46443_) {
                        if (this.m_9236_().f_46441_.m_188499_()) {
                            this.restTime = (int)(50.0f + 50.0f * this.m_9236_().f_46441_.m_188501_());
                        }
                        this.m_9236_().m_7605_((Entity)this, (byte)33);
                    }
                }
            }
            if (this.rotHeadY == this.rotHeadY0 && this.rotHeadX == this.rotHeadX0) {
                this.applyLaserEffect(this.viewHeadY());
            } else {
                float diffY = Mth.m_14154_((float)(this.rotHeadY - this.rotHeadY0));
                float diffX = Mth.m_14154_((float)(this.rotHeadX - this.rotHeadX0));
                float maxDiff = Math.max(diffX, diffY);
                for (float rotExtra = 0.0f; rotExtra < maxDiff; rotExtra += 1.0f) {
                    this.applyLaserEffect(this.m_20171_(this.rotHeadX0 - Math.min(rotExtra, diffX), this.rotHeadY0 + this.m_146908_() + Math.min(rotExtra, diffY)));
                }
            }
        }
        if (this.isCharging() && this.isRage()) {
            Vec3 vec32 = this.m_20184_();
            double f5 = -Math.toDegrees(Math.atan2(vec32.f_82480_, Math.sqrt(vec32.f_82479_ * vec32.f_82479_ + vec32.f_82481_ * vec32.f_82481_)));
            double f6 = Math.toDegrees(Math.atan2(vec32.f_82481_, vec32.f_82479_)) - 90.0;
            this.f_20885_ = (float)f6;
            this.m_5616_((float)f6);
            this.f_20883_ = (float)f6;
            this.m_146922_((float)f6);
            this.m_146926_((float)f5);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.rotHeadX = 45.0f;
            this.rotHeadY = (float)f6 - this.m_146908_();
            this.applyLaserEffect(this.viewHeadY());
        }
    }

    private boolean isRage() {
        return this.m_21223_() <= this.m_21233_() * 0.5f;
    }

    public boolean m_147207_(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        return false;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
    }

    public void applyLaserEffect(Vec3 view) {
        Vec3 origin = this.getHeadPos();
        BlockHitResult blockEnd = this.m_9236_().m_45547_(new ClipContext(origin, origin.m_82549_(view.m_82490_(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        List<EntityHitResult> hits = this.getBeamEntityHitResult(this.m_9236_(), (Entity)this, origin, origin.m_82549_(view.m_82490_(100.0)), this.m_20191_().m_82400_(100.0), e -> !this.m_7306_((Entity)e) && !(e instanceof RobotChicken), 1.5f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (hits != null) {
                for (EntityHitResult hit : hits) {
                    LivingEntity entity;
                    Entity entity2 = hit.m_82443_();
                    if (!(entity2 instanceof LivingEntity) || !(entity = (LivingEntity)entity2).m_6469_(Util.electricDamageMob(serverLevel, (Mob)this), 4.0f)) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 3, 10));
                }
            }
        }
        this.lastBlockBeam = blockEnd.m_6662_() != HitResult.Type.MISS ? blockEnd.m_82425_() : null;
        if (!this.m_9236_().m_8055_(blockEnd.m_82425_()).m_60795_() && (this.lastBlockPosBeamExplosion == null || Mth.m_14116_((float)((float)blockEnd.m_82425_().m_203193_((Position)this.lastBlockPosBeamExplosion.m_252807_()))) > 2.0f)) {
            BlockPos end;
            this.lastBlockPosBeamExplosion = end = blockEnd.m_82425_();
            if (!this.m_9236_().f_46443_) {
                BeamExplosionEntity beamCracking = new BeamExplosionEntity((EntityType)BKEntityType.CRACKING_BEAM.get(), this.m_9236_(), (LivingEntity)this);
                beamCracking.m_146884_(end.m_252807_());
                this.m_9236_().m_7967_((Entity)beamCracking);
            }
        }
    }

    public List<EntityHitResult> getBeamEntityHitResult(Level p_150176_, Entity p_150177_, Vec3 p_150178_, Vec3 p_150179_, AABB p_150180_, Predicate<Entity> p_150181_, float p_150182_) {
        double d0 = Double.MAX_VALUE;
        ArrayList<EntityHitResult> results = new ArrayList<EntityHitResult>();
        for (Entity entity1 : p_150176_.m_6249_(p_150177_, p_150180_, p_150181_)) {
            AABB aabb = entity1.m_20191_().m_82400_((double)p_150182_);
            Optional optional = aabb.m_82371_(p_150178_, p_150179_);
            if (!optional.isPresent()) continue;
            results.add(new EntityHitResult(entity1));
        }
        return results.isEmpty() ? null : results;
    }

    private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
        float deltaYaw = Mth.m_14177_((float)(targetYaw - currentYaw));
        float clampedDelta = Mth.m_14036_((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
        return currentYaw + clampedDelta;
    }

    public boolean isLaserSemiCir() {
        return (Boolean)this.f_19804_.m_135370_(CIR_LASER);
    }

    public void setCirLaser(boolean flag) {
        this.f_19804_.m_135381_(CIR_LASER, (Object)flag);
    }

    public boolean isLaser() {
        return (Boolean)this.f_19804_.m_135370_(LASER);
    }

    public void setLaser(boolean flag) {
        this.f_19804_.m_135381_(LASER, (Object)flag);
        if (flag) {
            this.speedLaserModifier = 0.0f;
        }
    }

    protected InteractionResult m_6071_(Player p_21472_, InteractionHand p_21473_) {
        return super.m_6071_(p_21472_, p_21473_);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
        if (!this.isCharging()) {
            super.m_7324_(entity);
        }
    }

    public boolean m_7337_(Entity entity) {
        if (this.isCharging()) {
            return false;
        }
        return super.m_7337_(entity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LASER, (Object)false);
        this.f_19804_.m_135372_(CIR_LASER, (Object)false);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(SHIELD_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(DEATH, (Object)false);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("shieldAmount", this.getShieldAmount());
        for (RexPart<?> part : this.towers) {
            part.m_7380_(p_21484_);
        }
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setShieldAmount(p_21450_.m_128451_("shieldAmount"));
        for (RexPart<?> part : this.towers) {
            part.m_7378_(p_21450_);
        }
    }

    private void setupAnimationStates() {
        if (this.hurtShield > 0) {
            --this.hurtShield;
        }
        if (!this.isCharging() && !this.isDeath()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 83;
                this.idle.m_216977_(this.f_19797_);
                this.attack.m_216973_();
                this.prepareCharge.m_216973_();
            } else {
                --this.idleAnimationTimeout;
            }
        } else {
            this.idle.m_216973_();
            this.idleAnimationTimeout = 0;
        }
        this.idleDeath.m_246184_(this.isDeath(), this.f_19797_);
        this.charge.m_246184_(this.isCharging(), this.f_19797_);
    }

    public boolean isDeath() {
        return (Boolean)this.f_19804_.m_135370_(DEATH);
    }

    public void setDeath(boolean flag) {
        this.f_19804_.m_135381_(DEATH, (Object)flag);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean flag) {
        this.f_19804_.m_135381_(ATTACKING, (Object)flag);
        this.attackTimer = flag ? 40 : 0;
    }

    public boolean m_6128_() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        this.setShieldAmount(50);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean flag) {
        this.f_19804_.m_135381_(CHARGING, (Object)flag);
    }

    public void playAttack() {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        if (!this.m_9236_().f_46443_) {
            this.deathAnimTime = 26;
            this.m_9236_().m_7605_((Entity)this, (byte)9);
        }
        this.m_21153_(1.0f);
    }

    public void m_6043_() {
    }

    public void m_6074_() {
        super.m_6074_();
        this.m_146870_();
        if (this.fight != null) {
            this.fight.setDragonKilled(this);
        }
    }

    public boolean m_20147_() {
        return super.m_20147_() || this.isDeath() || this.deathAnimTime > 0;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 4) {
            this.idle.m_216973_();
            this.attack.m_216977_(this.f_19797_);
            this.idleAnimationTimeout = 40;
        } else if (p_21375_ == 8) {
            this.idle.m_216973_();
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)BKSounds.REX_START_CHARGE.get(), SoundSource.HOSTILE, 5.0f, 1.0f, false);
            this.prepareCharge.m_216977_(this.f_19797_);
            this.prepareChargeTimer = 23;
            this.idleAnimationTimeout = 23;
        } else if (p_21375_ == 9) {
            this.idle.m_216973_();
            this.stunned.m_216973_();
            this.charge.m_216973_();
            this.recovery.m_216973_();
            this.idleAnimationTimeout = 26;
            this.death.m_216977_(this.f_19797_);
            this.deathAnimTime = 26;
        } else if (p_21375_ == 12) {
            this.charge.m_216973_();
            this.idle.m_216973_();
            this.idleAnimationTimeout = 1000;
            this.stunnedTick = 300;
            this.stunned.m_216977_(this.f_19797_);
        } else if (p_21375_ == 16) {
            this.recovery.m_216973_();
        } else if (p_21375_ == 17) {
            this.stunned.m_216973_();
            this.idle.m_216973_();
            this.idleAnimationTimeout = 21;
            this.recovery.m_216977_(this.f_19797_);
            this.stunnedTick = 0;
            this.recoveryTimer = 21;
        } else if (p_21375_ == 18) {
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)BKSounds.REX_LASER_SHOOT.get(), SoundSource.HOSTILE, 4.0f, 1.0f, false);
            this.setLaser(true);
        } else if (p_21375_ == 19) {
            this.prepareLaser = 23;
        } else if (p_21375_ == 32) {
            this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)BKSounds.REX_SHIELD_ON.get(), SoundSource.HOSTILE, 10.0f, 1.0f, false);
            this.setShieldAmount(50);
        } else if (p_21375_ == 33) {
            this.lastBlockPosBeamExplosion = null;
            this.lastBlockBeam = null;
        } else if (p_21375_ == 34) {
            this.hurtShield = 10;
        }
        super.m_7822_(p_21375_);
    }

    private void initLaser() {
        if (!this.m_9236_().f_46443_) {
            this.prepareLaser = 23;
            this.m_9236_().m_7605_((Entity)this, (byte)19);
            if (this.m_5448_() != null) {
                PacketHandler.sendToAllTracking(new PacketActionRex(this.m_19879_(), this.m_5448_().m_19879_(), 0), (LivingEntity)this);
            }
        }
    }

    private void initCharge() {
        if (!this.m_9236_().f_46443_) {
            this.prepareChargeTimer = 23;
            this.m_9236_().m_7605_((Entity)this, (byte)8);
        }
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    public boolean m_7307_(Entity p_20355_) {
        return super.m_7307_(p_20355_) || p_20355_ == this || p_20355_ instanceof RexPart;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (this.m_6673_(p_21016_) || this.f_19802_ > 0) {
            return false;
        }
        p_21017_ = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)p_21016_, (float)p_21017_);
        if (this.m_7090_()) {
            int healthShieldActually = this.getShieldAmount();
            if (!p_21016_.m_276093_(Util.ELECTRIC_DAMAGE_PLAYER) && !p_21016_.m_276093_(Util.ELECTRIC_DAMAGE_MOB)) {
                p_21017_ *= 0.3f;
            }
            if ((float)healthShieldActually <= p_21017_) {
                this.setShieldAmount(0);
                this.regenerationShieldTimer = 300;
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)BKSounds.REX_SHIELD_OFF.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
            } else {
                this.setShieldAmount((int)((float)healthShieldActually - p_21017_));
                this.m_9236_().m_7605_((Entity)this, (byte)34);
            }
            return false;
        }
        if (this.m_21223_() > 1.0f) {
            this.f_19802_ = 10;
            return super.m_6469_(p_21016_, Math.min(p_21017_, 3.0f));
        }
        return false;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public int getShieldAmount() {
        return (Integer)this.f_19804_.m_135370_(SHIELD_AMOUNT);
    }

    public void setShieldAmount(int amount) {
        this.f_19804_.m_135381_(SHIELD_AMOUNT, (Object)amount);
    }

    public boolean m_7090_() {
        return this.getShieldAmount() > 0;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            super(p_25552_, p_25553_, p_25554_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && RexChicken.this.recoveryTimer <= 0 && RexChicken.this.stunnedTick <= 0 && !RexChicken.this.isLaser() && RexChicken.this.prepareLaser <= 0 && !RexChicken.this.isCharging() && RexChicken.this.prepareChargeTimer <= 0;
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.m_25565_() <= 0 && RexChicken.this.attackTimer <= 0) {
                this.m_25563_();
                this.f_25540_.m_21573_().m_26573_();
                RexChicken.this.restTime = 0;
            } else if (RexChicken.this.restTime <= 0 && !this.f_25540_.m_9236_().f_46443_) {
                if (RexChicken.this.cooldownCharge <= 0) {
                    RexChicken.this.initCharge();
                } else if (RexChicken.this.cooldownLaser <= 0) {
                    ((RexChicken)this.f_25540_).initLaser();
                }
            }
        }

        protected void m_25563_() {
            super.m_25563_();
            RexChicken.this.setAttacking(true);
            if (!RexChicken.this.m_9236_().f_46443_) {
                RexChicken.this.playAttack();
            }
        }
    }

    static class ChargedGoal
    extends Goal {
        private final RexChicken rex;
        private final double speedModifier;
        private Vec3 targetDirection;

        public ChargedGoal(RexChicken p_37936_, double p_37937_) {
            this.rex = p_37936_;
            this.speedModifier = p_37937_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.rex.isCharging();
        }

        public void m_8056_() {
            super.m_8056_();
            if (this.rex.m_5448_() != null) {
                this.targetDirection = this.rex.chargeDirection.m_82541_().m_82520_(this.triangle(0.0, 0.0017227500256709754, this.rex.m_9236_().f_46441_), this.triangle(0.0, 0.0017227500256709754, this.rex.m_9236_().f_46441_), this.triangle(0.0, 0.0017227500256709754, this.rex.m_9236_().f_46441_)).m_82490_(this.speedModifier);
                this.rex.m_20256_(this.targetDirection);
            }
        }

        public void m_8037_() {
            if (this.targetDirection != null) {
                this.targetDirection = this.targetDirection.m_82490_(1.0);
                this.rex.m_20256_(this.targetDirection);
            }
        }

        public double triangle(double p_216329_, double p_216330_, RandomSource random) {
            return p_216329_ + p_216330_ * (random.m_188500_() - random.m_188500_());
        }
    }
}

