/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.fight;

import com.TBK.crc.CRC;
import com.TBK.crc.common.Util;
import com.TBK.crc.common.registry.BKDimension;
import com.TBK.crc.common.registry.BKEntityType;
import com.TBK.crc.server.entity.PortalEntity;
import com.TBK.crc.server.entity.RexChicken;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CyberChickenFight {
    private Structure structure;
    private boolean prevCyberChickenDefeat = false;
    private boolean cyberChickenDefeat = false;
    private boolean needsStateScanning = true;
    private int chickenId = -1;
    private int ticksChickenSeen = 0;
    private UUID chickenUUID = null;
    private UUID portalUUID = null;
    private ServerLevel level;
    private final BlockPos origin;
    private final Predicate<Entity> validPlayer;
    public ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237115_((String)"entity.crc.rex_chicken"), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).m_7005_(true).m_7006_(false);
    private int ticksSinceLastPlayerScan = 0;

    public CyberChickenFight() {
        this.level = CRC.getServer().m_129880_(BKDimension.THE_FUTURE_LEVEL);
        this.origin = new BlockPos(0, 116, 0);
        this.validPlayer = EntitySelector.f_20402_.and(EntitySelector.m_20410_((double)this.origin.m_123341_(), (double)(128 + this.origin.m_123342_()), (double)this.origin.m_123343_(), (double)192.0));
        this.structure = new Structure();
    }

    public CyberChickenFight(CompoundTag data) {
        this.deserialise(data);
        this.level = CRC.getServer().m_129880_(BKDimension.THE_FUTURE_LEVEL);
        this.origin = new BlockPos(0, 140, 0);
        this.validPlayer = EntitySelector.f_20402_.and(EntitySelector.m_20410_((double)this.origin.m_123341_(), (double)(128 + this.origin.m_123342_()), (double)this.origin.m_123343_(), (double)192.0));
    }

    public void setDragonKilled(RexChicken p_64086_) {
        if (p_64086_.m_20148_().equals(this.chickenUUID)) {
            this.bossEvent.m_142711_(0.0f);
            this.bossEvent.m_8321_(false);
            this.spawnExitPortal(true);
            this.prevCyberChickenDefeat = true;
            this.cyberChickenDefeat = true;
        }
    }

    public void tick() {
        this.bossEvent.m_8321_(!this.cyberChickenDefeat);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossEvent.m_8324_().isEmpty()) {
            this.level.m_7726_().m_8387_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
            boolean flag = this.isArenaLoaded();
            if (this.needsStateScanning && flag) {
                this.scanState();
                this.needsStateScanning = false;
            }
            if (!this.cyberChickenDefeat && (this.chickenUUID == null || ++this.ticksChickenSeen >= 1200) && flag) {
                this.findOrCreateChicken();
                this.ticksChickenSeen = 0;
            }
        } else {
            this.level.m_7726_().m_8438_(TicketType.f_9443_, new ChunkPos(0, 0), 9, (Object)Unit.INSTANCE);
        }
    }

    private boolean isArenaLoaded() {
        ChunkPos chunkpos = new ChunkPos(this.origin);
        for (int i = -8 + chunkpos.f_45578_; i <= 8 + chunkpos.f_45578_; ++i) {
            for (int j = 8 + chunkpos.f_45579_; j <= 8 + chunkpos.f_45579_; ++j) {
                ChunkAccess chunkaccess = this.level.m_6522_(i, j, ChunkStatus.f_62326_, false);
                if (!(chunkaccess instanceof LevelChunk)) {
                    return false;
                }
                FullChunkStatus fullchunkstatus = ((LevelChunk)chunkaccess).m_287138_();
                if (fullchunkstatus.m_287205_(FullChunkStatus.BLOCK_TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void findOrCreateChicken() {
        List<? extends RexChicken> list = Util.getRexChickens(this.level);
        if (list.isEmpty()) {
            this.createNewRex();
        } else {
            this.chickenUUID = list.get(0).m_20148_();
        }
    }

    @javax.annotation.Nullable
    private RexChicken createNewRex() {
        this.level.m_46745_(new BlockPos(this.origin.m_123341_(), 128 + this.origin.m_123342_(), this.origin.m_123343_()));
        RexChicken rex = (RexChicken)((EntityType)BKEntityType.REX_CHICKEN.get()).m_20615_((Level)this.level);
        if (rex != null) {
            rex.m_7678_(this.origin.m_123341_(), this.origin.m_123342_(), this.origin.m_123343_(), this.level.f_46441_.m_188501_() * 360.0f, 0.0f);
            rex.setShieldAmount(50);
            this.level.m_7967_((Entity)rex);
            this.chickenUUID = rex.m_20148_();
        }
        return rex;
    }

    private void updatePlayers() {
        HashSet set = Sets.newHashSet();
        for (ServerPlayer serverplayer : this.level.m_8795_(this.validPlayer)) {
            this.bossEvent.m_6543_(serverplayer);
            set.add(serverplayer);
        }
        HashSet set1 = Sets.newHashSet((Iterable)this.bossEvent.m_8324_());
        set1.removeAll(set);
        for (ServerPlayer serverplayer1 : set1) {
            this.bossEvent.m_6539_(serverplayer1);
        }
    }

    public void updateDragon(RexChicken p_64097_) {
        if (p_64097_.m_20148_().equals(this.chickenUUID)) {
            this.bossEvent.m_142711_(p_64097_.m_21223_() / p_64097_.m_21233_());
            this.ticksChickenSeen = 0;
            if (p_64097_.m_8077_()) {
                this.bossEvent.m_6456_(p_64097_.m_5446_());
            }
        }
    }

    private void scanState() {
        List<? extends RexChicken> list = Util.getRexChickens(this.level);
        this.prevCyberChickenDefeat = this.hasPortalActive();
        if (list.isEmpty()) {
            this.cyberChickenDefeat = true;
        } else {
            RexChicken rex = list.get(0);
            this.chickenUUID = rex.m_20148_();
            this.cyberChickenDefeat = false;
        }
        if (!this.prevCyberChickenDefeat && this.cyberChickenDefeat) {
            this.cyberChickenDefeat = false;
        }
    }

    public boolean hasPortalActive() {
        List portals = this.level.m_45976_(PortalEntity.class, new AABB(new BlockPos(0, 114, 0)).m_82400_(100.0));
        return !portals.isEmpty();
    }

    private void spawnExitPortal(boolean p_64094_) {
        List portals = this.level.m_45976_(PortalEntity.class, new AABB(new BlockPos(0, 114, 0)).m_82400_(100.0));
        if (portals.isEmpty()) {
            PortalEntity portal = new PortalEntity((EntityType)BKEntityType.PORTAL.get(), (Level)this.level);
            portal.m_146884_(new BlockPos(0, 114, 0).m_252807_());
            this.level.m_7967_((Entity)portal);
            this.portalUUID = portal.m_20148_();
        }
    }

    public CompoundTag serialise() {
        CompoundTag data = new CompoundTag();
        data.m_128365_("Structure", (Tag)this.structure.serialise());
        data.m_128379_("prevChickenDefeat", this.prevCyberChickenDefeat);
        if (!this.prevCyberChickenDefeat && this.chickenUUID != null) {
            data.m_128362_("chickenUUID", this.chickenUUID);
        }
        return data;
    }

    public void deserialise(CompoundTag data) {
        this.structure = new Structure(data.m_128469_("Structure"));
        if (!data.m_128471_("prevChickenDefeat")) {
            if (data.m_128441_("chickenUUID")) {
                this.chickenUUID = data.m_128342_("chickenUUID");
            }
            this.prevCyberChickenDefeat = false;
            this.cyberChickenDefeat = false;
        } else {
            this.prevCyberChickenDefeat = true;
            this.cyberChickenDefeat = true;
        }
    }

    public static ServerLevel getDimension() {
        return CRC.getServer().m_129880_(BKDimension.THE_FUTURE_LEVEL);
    }

    public static ServerLevel getDimensionReturn() {
        return CRC.getServer().m_129880_(Level.f_46428_);
    }

    public void teleport(LivingEntity entity) {
        Vec3 vec = this.structure.getCentre().m_252807_();
        if (Util.isInFuture(entity)) {
            vec = ((Player)entity).m_21257_().orElse(this.level.m_220360_()).m_252807_();
            entity.m_264318_(CyberChickenFight.getDimensionReturn(), vec.f_82479_, vec.f_82480_, vec.f_82481_, new HashSet(), entity.m_146908_(), entity.m_146909_());
        } else {
            entity.m_264318_(CyberChickenFight.getDimension(), -50.0, 114.0, 0.0, new HashSet(), entity.m_146908_(), entity.m_146909_());
        }
    }

    public static class Structure {
        private boolean isPlaced;
        private BlockPos centre;

        public Structure(@Nullable BlockPos centre) {
            this.isPlaced = false;
            this.centre = centre;
        }

        public Structure() {
            this(new BlockPos(0, 143, 0));
        }

        public Structure(CompoundTag data) {
            this.deserialise(data);
        }

        public CompoundTag serialise() {
            CompoundTag data = new CompoundTag();
            data.m_128379_("isPlaced", this.isPlaced);
            if (this.centre != null) {
                data.m_128365_("Centre", (Tag)NbtUtils.m_129224_((BlockPos)this.centre));
            }
            return data;
        }

        public void deserialise(CompoundTag data) {
            this.isPlaced = data.m_128471_("isPlaced");
            if (data.m_128441_("Centre")) {
                this.centre = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Centre"));
            }
        }

        public boolean isPlaced() {
            return this.isPlaced;
        }

        private Optional<StructureTemplate> findStructure(ResourceLocation structure) {
            return CRC.getServer().m_236738_().m_230407_(structure);
        }

        public void verify() {
            if (!this.isPlaced()) {
                this.place();
            }
        }

        private void place() {
            this.place(CyberChickenFight.getDimension());
        }

        private void place(ServerLevel level) {
            if (level == null) {
                return;
            }
            for (ServerPlayer p : level.m_7654_().m_6846_().m_11314_()) {
                p.m_213846_((Component)Component.m_237113_((String)"Please wait while the structures is placed..."));
            }
            long start = System.currentTimeMillis();
            if (this.isPlaced()) {
                CRC.LOGGER.warn("Tried to place realm structures twice");
            }
            StructurePlaceSettings settings = new StructurePlaceSettings();
            this.placeComponent(start, level, -42, 111, 38, new ResourceLocation("crc", "arena_derecha0"), settings);
            this.placeComponent(start, level, -42, 111, 0, new ResourceLocation("crc", "arena_derecha1"), settings);
            this.placeComponent(start, level, -42, 111, -42, new ResourceLocation("crc", "arena_derecha2"), settings);
            this.placeComponent(start, level, 31, 111, -42, new ResourceLocation("crc", "arena_izquierda0"), settings);
            this.placeComponent(start, level, 31, 111, 0, new ResourceLocation("crc", "arena_izquierda1"), settings);
            this.placeComponent(start, level, 31, 111, 38, new ResourceLocation("crc", "arena_izquierda2"), settings);
            this.placeComponent(start, level, 0, 111, 38, new ResourceLocation("crc", "arena_medio0"), settings);
            this.placeComponent(start, level, 0, 111, 0, new ResourceLocation("crc", "arena_medio1"), settings);
            this.placeComponent(start, level, 0, 111, -42, new ResourceLocation("crc", "arena_medio2"), settings);
            this.isPlaced = true;
        }

        public void placeComponent(long start, ServerLevel level, int addX, int height, int addZ, ResourceLocation location, StructurePlaceSettings settings) {
            StructureTemplate component = this.findStructure(location).orElse(null);
            if (component == null) {
                CRC.LOGGER.error("Could not find realm component :" + location.toString());
                return;
            }
            Vec3i size = component.m_163801_();
            BlockPos offset = new BlockPos(-size.m_123341_() / 2 + addX, height, -size.m_123343_() / 2 + addZ);
            component.m_230328_((ServerLevelAccessor)level, offset, offset, settings, level.m_213780_(), 16);
            CRC.LOGGER.info("Placed " + this + " at " + offset + " in " + (System.currentTimeMillis() - start) + "ms");
        }

        public BlockPos getCentre() {
            this.verify();
            if (this.centre != null) {
                return this.centre;
            }
            this.centre = new BlockPos(0, 114, 0);
            CRC.LOGGER.info("Placed " + this + "ms");
            return this.centre;
        }

        public String toString() {
            return "RealmStructure{, isPlaced=" + this.isPlaced + ", centre=" + this.centre + "}";
        }
    }
}

