/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.manager;

import com.TBK.crc.UpgradeableParts;
import com.TBK.crc.common.item.CyberImplantItem;
import com.TBK.crc.server.upgrade.Upgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ImplantStore {
    public SimpleContainer store = new SimpleContainer(6);

    public ImplantStore() {
    }

    public ImplantStore(CompoundTag nbt) {
        this.fromTag(this.store, nbt.m_128437_("store", 10));
    }

    public void fromTag(SimpleContainer store, ListTag tags) {
        store.m_6211_();
        for (int i = 0; i < tags.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)tags.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            store.m_6836_(tags.m_128728_(i).m_128451_("index"), itemstack);
        }
    }

    public void save(CompoundTag tag) {
        tag.m_128365_("store", (Tag)this.createTag());
    }

    public ListTag createTag() {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.store.m_6643_(); ++i) {
            ItemStack itemstack = this.store.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("index", i);
            listtag.add((Object)itemstack.m_41739_(nbt));
        }
        return listtag;
    }

    public void setImplant(ItemStack implant, int index) {
        if (index != -1) {
            this.store.m_6836_(index, implant);
        }
    }

    public ItemStack getImplant(int index) {
        return this.store.m_8020_(index);
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.store.m_6643_(); ++i) {
            list.add(this.store.m_8020_(i));
        }
        return list;
    }

    public ItemStack getImplantForSkill(Upgrade skill) {
        return this.getItems().stream().filter(e -> {
            Item patt2238$temp = e.m_41720_();
            if (!(patt2238$temp instanceof CyberImplantItem)) return false;
            CyberImplantItem item = (CyberImplantItem)patt2238$temp;
            if (item.skill.name.equals(skill.name)) return true;
            if (!CyberImplantItem.getUpgrade(item, e.m_41784_()).contains(skill)) return false;
            return true;
        }).findFirst().orElse(null);
    }

    public ItemStack getArmForSkill(Upgrade skill) {
        CyberImplantItem implantItem;
        Item item = this.getImplant(0).m_41720_();
        return item instanceof CyberImplantItem && CyberImplantItem.getUpgrade(implantItem = (CyberImplantItem)item, this.getImplant(0).m_41784_()).stream().anyMatch(e -> e.name.equals(skill.name)) ? this.getImplant(0) : null;
    }

    public void setStoreForList(List<ItemStack> list) {
        this.store.m_6211_();
        for (int i = 0; i < list.size(); ++i) {
            this.store.m_6836_(i, list.get(i));
        }
    }

    private int getSlotForType(UpgradeableParts type) {
        switch (type) {
            case ARM: {
                return 0;
            }
            case EYE: {
                return 1;
            }
            case SYSTEMS: {
                return this.store.m_8020_(2).m_41619_() ? 2 : 3;
            }
            case LEGS: {
                return this.store.m_8020_(4).m_41619_() ? 4 : 5;
            }
        }
        return -1;
    }
}

