/*
 * Decompiled with CFR 0.152.
 */
package com.TBK.crc.server.upgrade;

import com.TBK.crc.server.capability.MultiArmCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class Upgrade {
    public static Upgrade NONE = new Upgrade("none", 30, false, false);
    public final String name;
    public final int cd;
    public boolean canReactive;
    public boolean isCasting;
    public List<String> refinements = new ArrayList<String>();

    public Upgrade(String name, int cd, boolean canReactive, boolean isCasting) {
        this.name = name;
        this.cd = cd;
        this.canReactive = canReactive;
        this.isCasting = isCasting;
    }

    public Upgrade(CompoundTag tag) {
        this.name = tag.m_128461_("name");
        this.cd = tag.m_128451_("cd");
        this.canReactive = tag.m_128471_("canReactive");
        this.isCasting = tag.m_128471_("isCasting");
        this.load(tag);
    }

    public void startCooldown(MultiArmCapability multiArmCapability) {
        ItemStack stack = multiArmCapability.implantStore.getImplantForSkill(this);
        if (stack != null) {
            multiArmCapability.getPlayer().m_36335_().m_41524_(stack.m_41720_(), this.cd);
        }
    }

    public boolean canActiveAbility(MultiArmCapability multiArmCapability) {
        return true;
    }

    public void startAbility(MultiArmCapability multiArmCapability) {
        if (multiArmCapability.getPlayer().m_9236_().f_46443_ && this.getStartSound() != null) {
            multiArmCapability.getPlayer().m_9236_().m_245747_(multiArmCapability.getPlayer().m_20183_(), this.getStartSound(), SoundSource.PLAYERS, this.getVolumeStartAbility(), 1.0f, false);
        }
    }

    public SoundEvent getStartSound() {
        return null;
    }

    public SoundEvent getStopSound() {
        return null;
    }

    public void stopAbility(MultiArmCapability multiArmCapability) {
        if (multiArmCapability.getPlayer().m_9236_().f_46443_ && this.getStopSound() != null) {
            multiArmCapability.getPlayer().m_9236_().m_245747_(multiArmCapability.getPlayer().m_20183_(), this.getStopSound(), SoundSource.PLAYERS, this.getVolumeStopAbility(), 1.0f, false);
        }
    }

    protected float getVolumeStopAbility() {
        return 1.0f;
    }

    protected float getVolumeStartAbility() {
        return 1.0f;
    }

    public void setRefinements(List<String> refinements) {
        this.refinements = refinements;
    }

    public void tick(MultiArmCapability multiArmCapability) {
    }

    public MultiArmCapability.SkillPose getPose() {
        return MultiArmCapability.SkillPose.NONE;
    }

    public void save(CompoundTag nbt) {
        nbt.m_128359_("name", this.name);
        nbt.m_128405_("cd", this.cd);
        nbt.m_128379_("canReactive", this.canReactive);
        nbt.m_128379_("isCasting", this.isCasting);
        ListTag tags = new ListTag();
        for (String name : this.refinements) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", name);
            tags.add((Object)tag);
        }
        nbt.m_128365_("refinements", (Tag)tags);
    }

    public void load(CompoundTag nbt) {
        ArrayList<String> list = new ArrayList<String>();
        if (nbt.m_128441_("refinements")) {
            ListTag tags = nbt.m_128437_("refinements", 10);
            for (int i = 0; i < tags.size(); ++i) {
                CompoundTag tag = tags.m_128728_(i);
                list.add(tag.m_128461_("name"));
            }
        }
        this.refinements = list;
    }

    public boolean isCanReActive() {
        return this.canReactive;
    }

    public boolean hasEffect(MultiArmCapability multiArmCapability, MobEffect effect) {
        return false;
    }

    public float[] getWindowsColor(MultiArmCapability multiArmCapability) {
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    public boolean canEffect(MultiArmCapability multiArmCapability, MobEffect effect) {
        return true;
    }

    public void swapArm(MultiArmCapability multiArmCapability, Upgrade otherArm) {
    }

    public void onAttack(MultiArmCapability multiArmCapability, LivingHurtEvent event) {
    }

    public void onHurt(MultiArmCapability multiArmCapability, LivingHurtEvent event) {
    }
}

