/*
 * Decompiled with CFR 0.152.
 */
package io.github.mintynoura.mintyblends.block.entity;

import io.github.mintynoura.mintyblends.block.KettleBlock;
import io.github.mintynoura.mintyblends.block.entity.ImplementedInventory;
import io.github.mintynoura.mintyblends.item.component.HerbComponent;
import io.github.mintynoura.mintyblends.item.component.HerbalBrewComponent;
import io.github.mintynoura.mintyblends.recipe.KettleBrewingRecipe;
import io.github.mintynoura.mintyblends.recipe.KettleBrewingRecipeInput;
import io.github.mintynoura.mintyblends.registry.ModBlockEntities;
import io.github.mintynoura.mintyblends.registry.ModComponents;
import io.github.mintynoura.mintyblends.registry.ModItems;
import io.github.mintynoura.mintyblends.registry.ModParticleTypes;
import io.github.mintynoura.mintyblends.registry.ModRecipes;
import io.github.mintynoura.mintyblends.registry.ModSoundEvents;
import io.github.mintynoura.mintyblends.screen.KettleScreenHandler;
import io.github.mintynoura.mintyblends.util.ModTags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_10124;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1275;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3913;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7917;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_9288;
import net.minecraft.class_9298;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class KettleBlockEntity
extends class_2586
implements ImplementedInventory,
class_1275,
ExtendedScreenHandlerFactory<class_2338> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int progress = 0;
    private int brewTime;
    private int litUses = 0;
    public static final int maxLitUses = 4;
    private static final int[] INGREDIENT_SLOTS = new int[]{0, 1, 2, 3};
    public static final int OUTPUT_SLOT = 4;
    @Nullable
    private class_2561 customName;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> KettleBlockEntity.this.progress;
                case 1 -> KettleBlockEntity.this.brewTime;
                case 2 -> KettleBlockEntity.this.litUses;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    KettleBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    KettleBlockEntity.this.brewTime = value;
                    break;
                }
                case 2: {
                    KettleBlockEntity.this.litUses = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public KettleBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.KETTLE_BLOCK_ENTITY, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2371<class_1799> getIngredients() {
        class_2371 ingredients = class_2371.method_37434((int)4);
        for (int i = 0; i < 4; ++i) {
            class_1799 itemStack = (class_1799)this.inventory.get(i);
            ingredients.add((Object)itemStack);
        }
        return ingredients;
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.inventory);
        this.progress = view.method_71424("kettle.progress", 0);
        this.brewTime = view.method_71424("kettle.brew_time", 0);
        this.litUses = view.method_71424("kettle.lit_uses", 0);
        this.customName = KettleBlockEntity.method_59894((class_11368)view, (String)"CustomName");
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.inventory);
        view.method_71465("kettle.progress", this.progress);
        view.method_71465("kettle.brew_time", this.brewTime);
        view.method_71465("kettle.lit_uses", this.litUses);
        view.method_71477("CustomName", class_8824.field_46597, (Object)this.customName);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this);
        super.method_66473(pos, oldState);
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : class_2561.method_48321((String)"mintyblends.container.kettle", (String)"Kettle");
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new KettleScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void light() {
        this.litUses = 4;
    }

    public boolean isLit() {
        return this.litUses > 0;
    }

    private boolean hasRecipe() {
        Optional<class_8786<KettleBrewingRecipe>> recipeEntry = this.getRecipe();
        return recipeEntry.isPresent();
    }

    private Optional<class_8786<KettleBrewingRecipe>> getRecipe() {
        if (this.field_11863 != null) {
            return this.field_11863.method_8503().method_3772().method_8132(ModRecipes.KETTLE_BREWING_RECIPE_TYPE, (class_9695)new KettleBrewingRecipeInput(this.getIngredients()), this.field_11863);
        }
        return Optional.empty();
    }

    private int getBrewingTime(class_8786<KettleBrewingRecipe> recipeEntry) {
        return ((KettleBrewingRecipe)recipeEntry.comp_1933()).getBrewingTime();
    }

    private boolean canCraftRecipe(class_7225.class_7874 registries, class_8786<KettleBrewingRecipe> recipe, KettleBrewingRecipeInput recipeInput, class_2371<class_1799> inventory) {
        if (recipe != null) {
            class_1799 itemStack = ((KettleBrewingRecipe)recipe.comp_1933()).craft(recipeInput, registries);
            if (itemStack.method_7960()) {
                return false;
            }
            class_1799 container = (class_1799)inventory.get(4);
            return class_1799.method_31577((class_1799)container, (class_1799)((KettleBrewingRecipe)recipe.comp_1933()).getContainer());
        }
        return false;
    }

    private boolean canBlend(KettleBrewingRecipeInput recipeInput, class_2371<class_1799> inventory) {
        class_1799 container = (class_1799)inventory.get(4);
        boolean hasContainer = false;
        boolean hasIngredients = false;
        if (class_1799.method_31577((class_1799)container, (class_1799)KettleBrewingRecipe.defaultContainer)) {
            hasContainer = true;
        }
        if (recipeInput.getStackCount() < 1) {
            return false;
        }
        for (int i = 0; i < recipeInput.method_59983(); ++i) {
            class_1799 itemStack = recipeInput.method_59984(i);
            if (itemStack.method_7960()) continue;
            if (!itemStack.method_31573(ModTags.Items.BLENDING_INGREDIENTS)) {
                return false;
            }
            hasIngredients = true;
        }
        return hasContainer && hasIngredients;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        boolean changed = (Boolean)state.method_11654((class_2769)KettleBlock.LIT) ^ this.isLit();
        if (changed) {
            state = (class_2680)state.method_11657((class_2769)KettleBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            world.method_8652(pos, state, 3);
        }
        if (this.isLit()) {
            if (this.hasRecipe() && this.canCraftRecipe((class_7225.class_7874)world.method_30349(), this.getRecipe().get(), new KettleBrewingRecipeInput(this.getIngredients()), this.inventory)) {
                ++this.progress;
                this.brewTime = this.getBrewingTime(this.getRecipe().get());
                KettleBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.progress == this.brewTime) {
                    this.craftRecipe(world.method_30349(), this.getRecipe().get(), new KettleBrewingRecipeInput(this.getIngredients()));
                    this.postCraft(world, state);
                }
            } else if (!this.hasRecipe() && this.canBlend(new KettleBrewingRecipeInput(this.getIngredients()), this.inventory)) {
                ++this.progress;
                this.brewTime = 200;
                KettleBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.progress == this.brewTime) {
                    this.blend(new KettleBrewingRecipeInput(this.getIngredients()));
                    this.postCraft(world, state);
                }
            } else {
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
    }

    private void craftRecipe(class_5455 dynamicRegistryManager, class_8786<KettleBrewingRecipe> recipe, KettleBrewingRecipeInput recipeInput) {
        int i;
        ArrayList<class_1799> recipeRemainders = new ArrayList<class_1799>();
        for (i = 0; i < recipeInput.method_59983(); ++i) {
            class_1792 item = recipeInput.method_59984(i).method_7909();
            recipeRemainders.add(item.method_7858());
        }
        for (i = 0; i <= 4; ++i) {
            this.method_5434(i, 1);
        }
        class_1799 result = ((KettleBrewingRecipe)recipe.comp_1933()).craft(recipeInput, (class_7225.class_7874)dynamicRegistryManager);
        this.method_5447(4, result);
        for (class_1799 remainder : recipeRemainders) {
            class_2347.method_10134((class_1937)this.field_11863, (class_1799)remainder, (int)6, (class_2350)class_2350.field_11036, (class_2374)class_243.method_24953((class_2382)this.field_11867));
        }
    }

    private void blend(KettleBrewingRecipeInput recipeInput) {
        int i;
        HashSet<class_1293> statusEffectSet = new HashSet<class_1293>();
        HashSet<class_2960> herbalEffectSet = new HashSet<class_2960>();
        HashSet<String> ingredientSet = new HashSet<String>();
        ArrayList<class_1799> recipeRemainders = new ArrayList<class_1799>();
        ArrayList consumeEffects = new ArrayList();
        for (i = 0; i < recipeInput.method_59983(); ++i) {
            class_1792 item = recipeInput.method_59984(i).method_7909();
            recipeRemainders.add(item.method_7858());
        }
        for (i = 0; i < recipeInput.method_59983(); ++i) {
            class_7917 suspiciousStewIngredient;
            class_1799 itemStack = recipeInput.method_59984(i);
            if (itemStack.method_7960() || !itemStack.method_31573(ModTags.Items.BLENDING_INGREDIENTS)) continue;
            if (itemStack.method_7909() != class_1802.field_8162) {
                ingredientSet.add(itemStack.method_7909().method_7876());
            }
            if ((itemStack.method_31573(class_3489.field_15543) || itemStack.method_31573(ModTags.Items.HERBS)) && (suspiciousStewIngredient = class_7917.method_47380((class_1935)itemStack.method_7909())) != null) {
                class_1293 statusEffect = new class_1293(((class_9298.class_8751)suspiciousStewIngredient.method_53233().comp_2416().getFirst()).method_53247());
                statusEffectSet.add(statusEffect);
            }
            if (itemStack.method_57826(ModComponents.HERB_COMPONENT)) {
                class_2960 herbalEffect = ((HerbComponent)itemStack.method_58694(ModComponents.HERB_COMPONENT)).herbalEffect();
                herbalEffectSet.add(herbalEffect);
            }
            if (!itemStack.method_57826(class_9334.field_53964)) continue;
            consumeEffects.addAll(((class_10124)itemStack.method_58694(class_9334.field_53964)).comp_3089());
        }
        HerbalBrewComponent herbalBrewComponent = new HerbalBrewComponent(List.copyOf(herbalEffectSet), List.copyOf(statusEffectSet), List.copyOf(ingredientSet));
        class_10124 consumableComponent = new class_10124(1.6f, class_1839.field_8946, (class_6880)class_3417.field_20613, false, consumeEffects);
        class_1799 herbalBrew = new class_1799((class_1935)ModItems.HERBAL_BREW);
        herbalBrew.method_57379(ModComponents.HERBAL_BREW_COMPONENT, (Object)herbalBrewComponent);
        herbalBrew.method_57379(class_9334.field_53964, (Object)consumableComponent);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.method_5434(i2, 1);
        }
        this.method_5447(4, herbalBrew);
        for (class_1799 remainder : recipeRemainders) {
            class_2347.method_10134((class_1937)this.field_11863, (class_1799)remainder, (int)6, (class_2350)class_2350.field_11036, (class_2374)class_243.method_24953((class_2382)this.field_11867));
        }
    }

    private void postCraft(class_1937 world, class_2680 state) {
        class_5819 random = world.method_8409();
        class_2350 direction = ((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10170();
        double h = random.method_43058() * 0.6 - 0.3;
        double i = direction.method_10166() == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * 0.52 : h;
        double k = direction.method_10166() == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * 0.52 : h;
        for (int count = 0; count < 3; ++count) {
            ((class_3218)world).method_65096((class_2394)ModParticleTypes.KETTLE_STEAM, (double)this.field_11867.method_10263() + 0.5 + i, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5 + k, 1, 0.0, 0.1, 0.0, 0.0);
        }
        if (this.litUses == 1) {
            world.method_43128(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, ModSoundEvents.BLOCK_KETTLE_EXTINGUISH, class_3419.field_15245, 0.7f + random.method_43057(), random.method_43057() * 0.7f + 0.5f);
        }
        --this.litUses;
        this.progress = 0;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        int[] nArray;
        if (side == class_2350.field_11036) {
            nArray = INGREDIENT_SLOTS;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 4;
        }
        return nArray;
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        this.customName = (class_2561)components.method_58694(class_9334.field_49631);
        ((class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.getItems());
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49631, (Object)this.customName);
        builder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493(this.getItems()));
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }
}

