/*
 * Decompiled with CFR 0.152.
 */
package io.github.mintynoura.mintyblends.compat.eiv;

import de.crafty.eiv.common.api.recipe.IEivRecipeViewType;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.RecipeViewScreen;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.rendering.AnimationTicker;
import io.github.mintynoura.mintyblends.compat.eiv.KettleBrewingServerRecipe;
import io.github.mintynoura.mintyblends.compat.eiv.KettleBrewingViewType;
import io.github.mintynoura.mintyblends.screen.KettleScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class KettleBrewingViewRecipe
implements IEivViewRecipe {
    private static final class_2960 PROGRESS_TEXTURE = class_2960.method_60655((String)"mintyblends", (String)"textures/gui/sprites/container/kettle/progress.png");
    private final List<SlotContent> ingredients = new ArrayList<SlotContent>();
    private final SlotContent container;
    private final SlotContent result;
    private final int brewingTime;
    private final AnimationTicker brewingTicker;

    public KettleBrewingViewRecipe(KettleBrewingServerRecipe serverRecipe) {
        serverRecipe.getIngredients().forEach(ingredient -> this.ingredients.add(SlotContent.of((class_1856)ingredient)));
        this.container = SlotContent.of((class_1799)serverRecipe.getContainer());
        this.result = SlotContent.of((class_1799)serverRecipe.getResult());
        this.brewingTime = serverRecipe.getBrewingTime();
        this.brewingTicker = AnimationTicker.create((class_2960)class_2960.method_60655((String)"mintyblends", (String)"brewing_ticker"), (int)this.brewingTime);
    }

    public IEivRecipeViewType getViewType() {
        return KettleBrewingViewType.INSTANCE;
    }

    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        for (int i = 0; i < this.ingredients.size() && i < this.getViewType().getSlotCount() - 1; ++i) {
            slotFillContext.bindSlot(i, this.ingredients.get(i));
        }
        slotFillContext.bindSlot(4, this.container);
        slotFillContext.bindSlot(5, this.result);
    }

    public List<SlotContent> getIngredients() {
        return this.ingredients;
    }

    public List<SlotContent> getResults() {
        return List.of(this.result);
    }

    public List<AnimationTicker> getAnimationTickers() {
        return List.of(this.brewingTicker);
    }

    public void renderRecipe(RecipeViewScreen screen, IEivViewRecipe.RecipePosition recipePosition, class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int brewProgress = Math.round(this.brewingTicker.getProgress() * 24.0f);
        guiGraphics.method_25290(class_10799.field_56883, PROGRESS_TEXTURE, 77, 20, 0.0f, 0.0f, brewProgress, 16, 24, 16);
    }

    public boolean supportsItemTransfer() {
        return true;
    }

    public List<Class<? extends class_465<?>>> getTransferClasses() {
        return Collections.singletonList(KettleScreen.class);
    }

    public void mapRecipeItems(IEivViewRecipe.RecipeTransferMap transferMap, class_465<?> screen) {
        for (int i = 0; i < this.ingredients.size() && i < this.getViewType().getSlotCount() - 1; ++i) {
            transferMap.linkSlots(i, i);
        }
        transferMap.linkSlots(4, 4);
    }
}

