/*
 * Decompiled with CFR 0.152.
 */
package io.github.mintynoura.mintyblends.item.component;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mintynoura.mintyblends.util.HerbalEffectType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10124;
import net.minecraft.class_10127;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9299;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public record HerbalBrewComponent(List<class_2960> herbalEffects, List<class_1293> potionEffects, List<String> ingredients) implements class_10127,
class_9299
{
    private final List<class_1293> potionEffects;
    public static final Codec<HerbalBrewComponent> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_2960.field_25139.listOf().optionalFieldOf("herbal_effects", List.of()).forGetter(HerbalBrewComponent::herbalEffects), (App)class_1293.field_48821.listOf().optionalFieldOf("potion_effects", List.of()).forGetter(HerbalBrewComponent::potionEffects), (App)Codec.STRING.listOf().optionalFieldOf("ingredients", List.of()).forGetter(HerbalBrewComponent::ingredients)).apply((Applicative)builder, HerbalBrewComponent::new));

    public List<class_1293> potionEffects() {
        return Lists.transform(this.potionEffects, class_1293::new);
    }

    public static class_5250 getEffectText(class_6880<class_1291> effect, int amplifier) {
        class_5250 mutableText = class_2561.method_43471((String)((class_1291)effect.comp_349()).method_5567());
        return amplifier > 0 ? class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, class_2561.method_43471((String)("potion.potency." + amplifier))}) : mutableText;
    }

    public Iterable<class_1293> getEffects() {
        return this.potionEffects;
    }

    public void forEachEffect(Consumer<class_1293> effectConsumer, float durationMultiplier) {
        for (class_1293 statusEffectInstance : this.potionEffects) {
            effectConsumer.accept(statusEffectInstance.method_66227(durationMultiplier));
        }
    }

    public void apply(class_1309 user, float durationMultiplier) {
        class_1937 class_19372 = user.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1657 playerEntity;
            class_3218 serverWorld = (class_3218)class_19372;
            class_1657 playerEntity2 = user instanceof class_1657 ? (playerEntity = (class_1657)user) : null;
            this.forEachEffect(effect -> {
                if (((class_1291)effect.method_5579().comp_349()).method_5561()) {
                    ((class_1291)effect.method_5579().comp_349()).method_5564(serverWorld, (class_1297)playerEntity2, (class_1297)playerEntity2, user, effect.method_5578(), 1.0);
                } else {
                    user.method_6092(effect);
                }
            }, durationMultiplier);
        }
    }

    public static void buildTooltip(Iterable<class_1293> effects, Consumer<class_2561> textConsumer, float durationMultiplier, float tickRate) {
        ArrayList list = Lists.newArrayList();
        boolean bl = true;
        for (class_1293 statusEffectInstance : effects) {
            bl = false;
            class_6880 registryEntry = statusEffectInstance.method_5579();
            int i = statusEffectInstance.method_5578();
            ((class_1291)registryEntry.comp_349()).method_55650(i, (attribute, modifier) -> list.add(new Pair(attribute, modifier)));
            class_5250 mutableText = HerbalBrewComponent.getEffectText((class_6880<class_1291>)registryEntry, i);
            if (!statusEffectInstance.method_48557(20)) {
                mutableText = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{mutableText, class_1292.method_5577((class_1293)statusEffectInstance, (float)durationMultiplier, (float)tickRate)});
            }
            textConsumer.accept((class_2561)mutableText.method_27692(((class_1291)registryEntry.comp_349()).method_18792().method_18793()));
        }
        if (bl) {
            textConsumer.accept((class_2561)class_2561.method_48321((String)"tooltip.mintyblends.no_effects", (String)"No Status Effects").method_27692(class_124.field_1080));
        }
        if (!list.isEmpty()) {
            textConsumer.accept(class_5244.field_39003);
            textConsumer.accept((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : list) {
                class_1322 entityAttributeModifier = (class_1322)pair.getSecond();
                double d = entityAttributeModifier.comp_2449();
                double e = entityAttributeModifier.comp_2450() != class_1322.class_1323.field_6330 && entityAttributeModifier.comp_2450() != class_1322.class_1323.field_6331 ? entityAttributeModifier.comp_2449() : entityAttributeModifier.comp_2449() * 100.0;
                if (d > 0.0) {
                    textConsumer.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + entityAttributeModifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(e), class_2561.method_43471((String)((class_1320)((class_6880)pair.getFirst()).comp_349()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d < 0.0)) continue;
                textConsumer.accept((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + entityAttributeModifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(e *= -1.0), class_2561.method_43471((String)((class_1320)((class_6880)pair.getFirst()).comp_349()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        if (!this.ingredients.isEmpty()) {
            textConsumer.accept((class_2561)class_2561.method_48321((String)"tooltip.mintyblends.ingredients", (String)"Ingredients:").method_27692(class_124.field_1080));
            for (String ingredient : this.ingredients) {
                textConsumer.accept((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43471((String)ingredient).method_27692(class_124.field_1062)));
            }
            textConsumer.accept(class_5244.field_39003);
        }
        HerbalBrewComponent.buildTooltip(this.getEffects(), textConsumer, ((Float)components.method_58695(class_9334.field_55879, (Object)Float.valueOf(1.0f))).floatValue(), context.method_59531());
    }

    public void method_62831(class_1937 world, class_1309 user, class_1799 stack, class_10124 consumable) {
        for (class_2960 herbalEffect : this.herbalEffects) {
            HerbalEffectType.applyHerb(user, herbalEffect);
        }
        this.apply(user, ((Float)stack.method_58695(class_9334.field_55879, (Object)Float.valueOf(1.0f))).floatValue());
    }
}

