/*
 * Decompiled with CFR 0.152.
 */
package io.github.mintynoura.mintyblends.block;

import io.github.mintynoura.mintyblends.registry.ModBlocks;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8237;
import org.jetbrains.annotations.Nullable;

public class HortensiaCropBlock
extends class_8237 {
    public static final int MAX_AGE = 4;
    public static final class_2758 AGE = class_2741.field_37654;
    public static final class_2754<class_2756> HALF = class_2320.field_10929;
    private final Function<class_2680, class_265> shapeFunction = this.createShapeFunction();

    public HortensiaCropBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    private Function<class_2680, class_265> createShapeFunction() {
        int[] is = new int[]{5, 10, 17, 22, 22};
        return this.method_33615(state -> {
            int i = 6 + is[(Integer)state.method_11654((class_2769)AGE)];
            return switch ((class_2756)state.method_11654(HALF)) {
                default -> throw new MatchException(null, null);
                case class_2756.field_12607 -> class_2248.method_66404((double)10.0, (double)-1.0, (double)Math.min(16, -1 + i));
                case class_2756.field_12609 -> class_2248.method_66404((double)10.0, (double)0.0, (double)Math.max(0, -1 + i - 16));
            };
        });
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapeFunction.apply(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    private static boolean canGrowAt(class_4538 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26215() || blockState.method_27852(ModBlocks.HORTENSIA_CROP);
    }

    private void tryGrow(class_3218 world, class_2680 state, class_2338 pos, int amount) {
        int i = Math.min((Integer)state.method_11654((class_2769)AGE) + amount, 4);
        if (this.canGrow((class_4538)world, pos, state, i)) {
            class_2680 blockState = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(i));
            world.method_8652(pos, blockState, 2);
            if (HortensiaCropBlock.isDoubleTallAtAge(i)) {
                world.method_8652(pos.method_10084(), (class_2680)blockState.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
            }
        }
    }

    private boolean canGrow(class_4538 world, class_2338 pos, class_2680 state, int age) {
        return !this.isFullyGrown(state) && HortensiaCropBlock.canPlaceAt(world, pos) && (!HortensiaCropBlock.isDoubleTallAtAge(age) || HortensiaCropBlock.canGrowAt(world, pos.method_10084()));
    }

    private static boolean canPlaceAt(class_4538 world, class_2338 pos) {
        return world.method_22335(pos, 0) >= 8;
    }

    private boolean isFullyGrown(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) >= 4;
    }

    private static boolean isDoubleTallAtAge(int age) {
        return age >= 2;
    }

    private static boolean isLowerHalf(class_2680 state) {
        return state.method_27852(ModBlocks.HORTENSIA_CROP) && state.method_11654(HALF) == class_2756.field_12607;
    }

    @Nullable
    private LowerHalfContext getLowerHalfContext(class_4538 world, class_2338 pos, class_2680 state) {
        if (HortensiaCropBlock.isLowerHalf(state)) {
            return new LowerHalfContext(pos, state);
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        return HortensiaCropBlock.isLowerHalf(blockState) ? new LowerHalfContext(blockPos, blockState) : null;
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext(world, pos, state);
        return lowerHalfContext != null && this.canGrow(world, lowerHalfContext.pos, lowerHalfContext.state, (Integer)lowerHalfContext.state.method_11654((class_2769)AGE) + 1);
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        LowerHalfContext lowerHalfContext = this.getLowerHalfContext((class_4538)world, pos, state);
        if (lowerHalfContext != null) {
            this.tryGrow(world, lowerHalfContext.state, lowerHalfContext.pos, 1);
        }
    }

    record LowerHalfContext(class_2338 pos, class_2680 state) {
    }
}

