/*
 * Decompiled with CFR 0.152.
 */
package io.github.mintynoura.mintyblends.block;

import com.mojang.serialization.MapCodec;
import io.github.mintynoura.mintyblends.block.entity.KettleBlockEntity;
import io.github.mintynoura.mintyblends.registry.ModBlockEntities;
import io.github.mintynoura.mintyblends.registry.ModParticleTypes;
import io.github.mintynoura.mintyblends.registry.ModSoundEvents;
import java.util.Map;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1778;
import net.minecraft.class_1786;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class KettleBlock
extends class_2237 {
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2746 LIT = class_2741.field_12548;
    private static final class_265 BASE_SHAPE = class_259.method_17786((class_265)class_2248.method_66404((double)10.0, (double)0.0, (double)6.0), (class_265[])new class_265[]{class_2248.method_66404((double)8.0, (double)6.05, (double)14.0), class_2248.method_66404((double)4.0, (double)14.0, (double)15.0)});
    private static final Map<class_2350, class_265> OUTLINE_SHAPES_BY_DIRECTION = class_259.method_66501((class_265)class_259.method_17786((class_265)class_259.method_1081((double)0.125, (double)0.5, (double)0.4375, (double)0.25, (double)0.8125, (double)0.5625), (class_265[])new class_265[]{class_259.method_1081((double)0.8125, (double)0.5, (double)0.4375, (double)0.9375, (double)0.8125, (double)0.5625), class_259.method_1081((double)0.75, (double)0.5, (double)0.4375, (double)0.8125, (double)0.625, (double)0.5625), class_259.method_1081((double)0.9375, (double)0.6875, (double)0.4375, (double)1.0, (double)0.8125, (double)0.5625), BASE_SHAPE}));
    public static final MapCodec<KettleBlock> CODEC = KettleBlock.method_54094(KettleBlock::new);

    public KettleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean canBeLit(class_2680 state, class_1937 world, class_2338 pos) {
        return KettleBlock.tryLight(state, world, pos);
    }

    private static boolean tryLight(class_2680 state, class_1937 world, class_2338 pos) {
        KettleBlockEntity blockEntity = (KettleBlockEntity)world.method_8321(pos);
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            blockEntity.light();
            return true;
        }
        return false;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPES_BY_DIRECTION.get(state.method_11654(FACING));
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BASE_SHAPE;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KettleBlockEntity(pos, state);
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        KettleBlockEntity screenHandlerFactory;
        class_1799 heldStack = player.method_5998(hand);
        boolean isFireCharge = heldStack.method_7909() instanceof class_1778;
        boolean isFlintAndSteel = heldStack.method_7909() instanceof class_1786;
        KettleBlockEntity blockEntity = (KettleBlockEntity)world.method_8321(pos);
        if ((isFireCharge || isFlintAndSteel) && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            blockEntity.light();
            if (isFireCharge) {
                world.method_8396((class_1297)player, pos, class_3417.field_15013, class_3419.field_15245, 1.0f, (world.method_8409().method_43057() - world.method_8409().method_43057()) * 0.2f + 1.0f);
                player.method_5998(hand).method_7934(1);
            } else {
                world.method_8396((class_1297)player, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
                player.method_5998(hand).method_61653(1, player);
            }
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            return class_1269.field_5812;
        }
        if (!world.method_8608() && (screenHandlerFactory = blockEntity) != null) {
            player.method_17355((class_3908)screenHandlerFactory);
        }
        return class_1269.field_5812;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            if (random.method_43057() < 0.11f) {
                world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, ModSoundEvents.BLOCK_KETTLE_AMBIENT, class_3419.field_15245, 0.5f + random.method_43057(), random.method_43057() * 0.7f + 0.5f, false);
            }
            if (random.method_43057() < 0.05f) {
                class_2350 direction = ((class_2350)state.method_11654(FACING)).method_10170();
                double h = random.method_43058() * 0.6 - 0.3;
                double i = direction.method_10166() == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * 0.52 : h;
                double k = direction.method_10166() == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * 0.52 : h;
                world.method_8406((class_2394)ModParticleTypes.KETTLE_STEAM, (double)pos.method_10263() + 0.5 + i, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5 + k, 0.0, 0.07, 0.0);
            }
        }
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, LIT});
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.method_8608()) {
            return null;
        }
        return KettleBlock.method_31618(type, ModBlockEntities.KETTLE_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }
}

