/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.menu;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.trading.Content;
import com.tom.trading.menu.AbstractFilteredMenu;
import com.tom.trading.menu.VendingMachineTradingMenu;
import com.tom.trading.menu.slot.PhantomSlot;
import com.tom.trading.network.NetworkHandler;
import com.tom.trading.screen.widget.IOMode;
import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.DataSlots;
import com.tom.trading.util.IDataReceiver;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_8942;

public class VendingMachineConfigMenu
extends AbstractFilteredMenu
implements IDataReceiver {
    private VendingMachineBlockEntityBase machine;
    protected final class_1661 pinv;
    public int inputCfg;
    public int outputCfg;
    public int autoCfg;
    public int matchNBT;
    public int creativeMode;
    public Runnable updateGui;

    public VendingMachineConfigMenu(int pContainerId, class_1661 pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (class_1263)new class_1277(9), (class_1263)new class_1277(9), (class_1263)new class_1277(8));
        this.method_17362(DataSlots.set(c -> {
            this.inputCfg = c;
        }).onUpdate(this::updateGui));
        this.method_17362(DataSlots.set(c -> {
            this.outputCfg = c;
        }).onUpdate(this::updateGui));
        this.method_17362(DataSlots.set(c -> {
            this.matchNBT = c;
        }));
        this.method_17362(DataSlots.set(c -> {
            this.autoCfg = c;
        }).onUpdate(this::updateGui));
        this.method_17362(DataSlots.set(c -> {
            this.creativeMode = c;
        }).onUpdate(this::updateGui));
    }

    public VendingMachineConfigMenu(int pContainerId, class_1661 pPlayerInventory, VendingMachineBlockEntityBase machine) {
        this(pContainerId, pPlayerInventory, (class_1263)machine.getInputs(), (class_1263)machine.getOutputs(), (class_1263)machine.getConfig());
        this.machine = machine;
        this.method_17362(DataSlots.get(machine::getInputSides));
        this.method_17362(DataSlots.get(machine::getOutputSides));
        this.method_17362(DataSlots.get(machine::getMatchNBT));
        this.method_17362(DataSlots.get(machine::getAutoSides));
        this.method_17362(DataSlots.get(() -> machine.isCreativeMode() ? 1 : 0));
    }

    private VendingMachineConfigMenu(int pContainerId, class_1661 pPlayerInventory, class_1263 input, class_1263 output, final class_1263 config) {
        super(Content.VENDING_MACHINE_CONFIG_MENU.get(), pContainerId, pPlayerInventory);
        int j;
        int i;
        this.pinv = pPlayerInventory;
        for (i = 0; i < 4; ++i) {
            this.method_7621(new PhantomSlot(config, i, 8 + i % 2 * 18, 35 + i / 2 * 18));
        }
        for (i = 0; i < 4; ++i) {
            this.method_7621(new PhantomSlot(config, i + 4, 76 + i % 2 * 18, 35 + i / 2 * 18));
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.method_7621(new class_1735(input, j + i * 4, 8 + j * 18, 82 + i * 18){

                    public boolean method_7680(class_1799 pStack) {
                        for (int i = 0; i < 4; ++i) {
                            class_1799 o = config.method_5438(i + 4).method_7972();
                            if (!VendingMachineConfigMenu.this.compareItemStack(o, pStack, i + 4)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.method_7621(new class_1735(this, output, j + i * 4, 98 + j * 18, 82 + i * 18){

                    public boolean method_7680(class_1799 pStack) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.method_7621(new class_1735((class_1263)pPlayerInventory, k, 8 + k * 18, 187));
        }
    }

    public boolean compareItemStack(class_1799 pStack, class_1799 pOther, int slot) {
        if ((this.matchNBT & 1 << slot) != 0) {
            return class_1799.method_31577((class_1799)pStack, (class_1799)pOther);
        }
        return class_1799.method_7984((class_1799)pStack, (class_1799)pOther);
    }

    @Override
    public class_1799 method_7601(class_1657 pPlayer, int pIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(pIndex);
        if (slot instanceof PhantomSlot) {
            slot.method_7673(class_1799.field_8037);
            return class_1799.field_8037;
        }
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (pIndex >= 8 && pIndex < 26) {
                if (!this.method_7616(itemstack1, 26, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (pIndex >= 26) {
                boolean in = false;
                for (int i = 0; i < 4; ++i) {
                    class_1799 o = ((class_1735)this.field_7761.get(i + 4)).method_7677().method_7972();
                    if (!this.compareItemStack(o, slot.method_7677(), i + 4)) continue;
                    in = true;
                    break;
                }
                if (!in) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(itemstack1, 8, 17, false)) {
                    return class_1799.field_8037;
                }
            }
        }
        return itemstack;
    }

    public boolean method_7597(class_1657 pPlayer) {
        return this.machine != null ? this.machine.isInRange(pPlayer) && this.machine.canAccess(pPlayer) : true;
    }

    @Override
    public void method_7593(int slotId, int dragType, class_1713 pClickType, class_1657 pPlayer) {
        class_1735 slot;
        class_1735 class_17352 = slot = slotId > -1 && slotId < this.field_7761.size() ? (class_1735)this.field_7761.get(slotId) : null;
        if (slot instanceof PhantomSlot) {
            slot.method_7673(this.method_34255().method_7972());
            return;
        }
        super.method_7593(slotId, dragType, pClickType, pPlayer);
    }

    public boolean method_7604(class_1657 pPlayer, int pId) {
        if (pId == 64) {
            pPlayer.method_17355(new class_3908(){

                public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
                    return new VendingMachineTradingMenu(pContainerId, pPlayerInventory, VendingMachineConfigMenu.this.machine);
                }

                public class_2561 method_5476() {
                    return VendingMachineConfigMenu.this.machine.method_5476();
                }
            });
            return true;
        }
        if ((pId & 0xE0) == 32) {
            if (pPlayer.method_31549().field_7477) {
                this.machine.setCreativeMode((pId & 1) != 0);
            }
        } else if ((pId & 0x60) == 96) {
            int slot = pId & 0xF;
            boolean c = (pId & 0x10) != 0;
            this.machine.setMatchNBT(slot, c);
            return true;
        }
        return false;
    }

    @Override
    public void receive(class_11368 tag) {
        if (this.pinv.field_7546.method_7325()) {
            return;
        }
        tag.method_71420("setItemCount").ifPresent(t -> {
            class_1735 slot;
            int slotId = t.method_71424("id", 0);
            byte count = t.method_71421("count", (byte)0);
            class_1735 class_17352 = slot = slotId > -1 && slotId < this.field_7761.size() ? (class_1735)this.field_7761.get(slotId) : null;
            if (slot instanceof PhantomSlot) {
                class_1799 s = slot.method_7677().method_7972();
                s.method_7939(class_3532.method_15340((int)count, (int)1, (int)s.method_7914()));
                slot.method_7673(s);
            }
        });
        tag.method_71441("setName").ifPresent(s -> this.machine.setCustomName((class_2561)class_2561.method_43470((String)s)));
        tag.method_71426("setSide", SidesObject.CODEC).ifPresent(e -> this.machine.setSides(e.dir().ordinal(), e.newState().ordinal(), e.auto()));
        super.receive(tag);
    }

    public void setConfigCount(class_1735 slot, int count) {
        class_2487 tag = new class_2487();
        class_2487 t = new class_2487();
        tag.method_10566("setItemCount", (class_2520)t);
        t.method_10569("id", slot.field_7874);
        t.method_10567("count", (byte)count);
        NetworkHandler.sendDataToServer(tag);
    }

    public void setName(String name) {
        class_2487 tag = new class_2487();
        tag.method_10582("setName", name);
        NetworkHandler.sendDataToServer(tag);
    }

    public void setSides(BlockFaceDirection dir, IOMode newState, boolean auto) {
        class_11362 tag = class_11362.method_71458((class_8942)class_8942.field_60348);
        tag.method_71468("setSide", SidesObject.CODEC, (Object)new SidesObject(dir, newState, auto));
        NetworkHandler.sendDataToServer(tag.method_71475());
    }

    private void updateGui() {
        if (this.updateGui != null) {
            this.updateGui.run();
        }
    }

    public record SidesObject(BlockFaceDirection dir, IOMode newState, boolean auto) {
        public static final MapCodec<SidesObject> MAP_CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)BlockFaceDirection.CODEC.fieldOf("dir").forGetter(SidesObject::dir), (App)IOMode.CODEC.fieldOf("mode").forGetter(SidesObject::newState), (App)Codec.BOOL.fieldOf("auto").forGetter(SidesObject::auto)).apply((Applicative)b, SidesObject::new));
        public static final Codec<SidesObject> CODEC = MAP_CODEC.codec();
    }
}

