/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.tile;

import com.tom.trading.Content;
import com.tom.trading.block.VendingMachineBlock;
import com.tom.trading.menu.VendingMachineConfigMenu;
import com.tom.trading.menu.VendingMachineTradingMenu;
import com.tom.trading.tile.OwnableBlockEntity;
import com.tom.trading.tile.VendingMachineBlockEntity;
import com.tom.trading.util.BasicContainer;
import com.tom.trading.util.BlockFaceDirection;
import com.tom.trading.util.TradeResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1265;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_6862;
import net.minecraft.class_8824;

public abstract class VendingMachineBlockEntityBase
extends OwnableBlockEntity
implements class_3908,
class_1275 {
    private BasicContainer config = new BasicContainer(8);
    private BasicContainer inputs = new BasicContainer(8);
    private BasicContainer outputs = new BasicContainer(8);
    private int inputSides;
    private int outputSides;
    private int autoSides;
    private int matchNBT = 255;
    private class_2561 name;
    private Boolean hasInputs;
    private boolean creativeMode;

    public VendingMachineBlockEntityBase(class_2338 pPos, class_2680 pBlockState) {
        super((class_2591)Content.VENDING_MACHINE_TILE.get(), pPos, pBlockState);
        this.inputs.method_5489(c -> {
            this.hasInputs = null;
        });
        this.config.method_5489(c -> {
            this.hasInputs = null;
        });
        class_1265 l = c -> this.method_5431();
        this.config.method_5489(l);
        this.inputs.method_5489(l);
        this.outputs.method_5489(l);
    }

    @Override
    public void method_11014(class_11368 pTag) {
        super.method_11014(pTag);
        this.inputs.loadItems((class_11368.class_11369<class_11343>)pTag.method_71437("Inputs", class_11343.field_60354));
        this.outputs.loadItems((class_11368.class_11369<class_11343>)pTag.method_71437("Outputs", class_11343.field_60354));
        this.config.loadItems((class_11368.class_11369<class_11343>)pTag.method_71437("Config", class_11343.field_60354));
        this.inputSides = pTag.method_71424("inputSides", 0);
        this.outputSides = pTag.method_71424("outputSides", 0);
        this.autoSides = pTag.method_71424("autoSides", 0);
        this.matchNBT = pTag.method_71424("matchNBT", 255);
        this.creativeMode = pTag.method_71433("Creative", false);
        this.name = VendingMachineBlockEntityBase.method_59894((class_11368)pTag, (String)"CustomName");
    }

    @Override
    protected void method_11007(class_11372 pTag) {
        super.method_11007(pTag);
        this.inputs.storeItems((class_11372.class_11373<class_11343>)pTag.method_71467("Inputs", class_11343.field_60354));
        this.outputs.storeItems((class_11372.class_11373<class_11343>)pTag.method_71467("Outputs", class_11343.field_60354));
        this.config.storeItems((class_11372.class_11373<class_11343>)pTag.method_71467("Config", class_11343.field_60354));
        pTag.method_71465("inputSides", this.inputSides);
        pTag.method_71465("outputSides", this.outputSides);
        pTag.method_71465("autoSides", this.autoSides);
        pTag.method_71465("matchNBT", this.matchNBT);
        pTag.method_71472("Creative", this.creativeMode);
        pTag.method_71477("CustomName", class_8824.field_46597, (Object)this.name);
    }

    public BasicContainer getInputs() {
        return this.inputs;
    }

    public BasicContainer getOutputs() {
        return this.outputs;
    }

    public Runnable consumeInputs(List<class_1799> items) {
        return this.consumeInputs((class_1263)this.inputs, 4, items);
    }

    public Runnable consumeInputs(class_1263 inputs, int start, List<class_1799> items) {
        class_1799[] modArray = new class_1799[inputs.method_5439()];
        for (int i = 0; i < modArray.length; ++i) {
            modArray[i] = inputs.method_5438(i).method_7972();
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (int i = 0; i < 4; ++i) {
            class_1799 o = this.config.method_5438(i + start);
            int rem = o.method_7947();
            if (rem > 0) {
                for (int j = 0; j < modArray.length; ++j) {
                    class_1799 s = modArray[j];
                    if (s.method_7960() || !this.compareItemStack(s, o, i + start)) continue;
                    int d = Math.min(rem, s.method_7947());
                    int fj = j;
                    actions.add(() -> inputs.method_5434(fj, d));
                    items.add(s.method_7971(d));
                    if ((rem -= d) < 1) break;
                }
            }
            if (rem <= 0) continue;
            return null;
        }
        return () -> actions.forEach(Runnable::run);
    }

    public Runnable addOutput(List<class_1799> items) {
        return this.addOutput((class_1263)this.outputs, items, false);
    }

    private Runnable addOutput(class_1263 outputs, List<class_1799> items, boolean drop) {
        class_1799[] modArray = new class_1799[outputs.method_5439()];
        for (int i = 0; i < modArray.length; ++i) {
            modArray[i] = outputs.method_5438(i).method_7972();
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (int i = 0; i < items.size(); ++i) {
            int j;
            class_1799 o = items.get(i).method_7972();
            for (j = 0; j < modArray.length; ++j) {
                if (class_1799.method_31577((class_1799)o, (class_1799)modArray[j])) {
                    class_1799 s = modArray[j];
                    int m = Math.min(outputs.method_5444(), o.method_7914());
                    int c = Math.min(o.method_7947(), m - s.method_7947());
                    if (c > 0) {
                        class_1799 ins = o.method_7972();
                        ins.method_7939(c);
                        o.method_7934(c);
                        s.method_7933(c);
                        actions.add(() -> {
                            class_1799 is = class_2614.method_11260(null, (class_1263)outputs, (class_1799)ins, null);
                            if (!is.method_7960() && drop) {
                                class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)is);
                            }
                        });
                    }
                }
                if (o.method_7960()) break;
            }
            if (!o.method_7960()) {
                for (j = 0; j < modArray.length; ++j) {
                    class_1799 s2;
                    if (!modArray[j].method_7960()) continue;
                    modArray[j] = s2 = o.method_7972();
                    o.method_7939(0);
                    actions.add(() -> {
                        class_1799 is = class_2614.method_11260(null, (class_1263)outputs, (class_1799)s2, null);
                        if (!is.method_7960() && drop) {
                            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)is);
                        }
                    });
                }
            }
            if (o.method_7960()) continue;
            return null;
        }
        return () -> actions.forEach(Runnable::run);
    }

    public boolean canInput(class_1799 stack, class_2350 dir) {
        return this.canInputFrom(dir) && this.canInputItem(stack);
    }

    public boolean canInputItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            class_1799 o = this.config.method_5438(i + 4).method_7972();
            if (!this.compareItemStack(stack, o, i + 4)) continue;
            return true;
        }
        return false;
    }

    public boolean compareItemStack(class_1799 stack, class_1799 template, int slot) {
        if (template.method_7909() == Content.TAG_FILTER.get()) {
            class_6862 tag = (class_6862)template.method_58694(Content.TAG_COMPONENT.get());
            if (tag == null) {
                return false;
            }
            return stack.method_31573(tag);
        }
        if ((this.matchNBT & 1 << slot) != 0) {
            return class_1799.method_31577((class_1799)stack, (class_1799)template);
        }
        return class_1799.method_7984((class_1799)stack, (class_1799)template);
    }

    public boolean canInputFrom(class_2350 dir) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.inputSides & 1 << d.ordinal()) != 0;
    }

    public boolean canOutput(class_2350 dir) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.outputSides & 1 << d.ordinal()) != 0;
    }

    public boolean isAutoSide(class_2350 dir) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(VendingMachineBlock.FACING);
        BlockFaceDirection d = BlockFaceDirection.getHorizontalFace(facing, dir);
        if (d == BlockFaceDirection.FRONT) {
            return false;
        }
        return (this.autoSides & 1 << d.ordinal()) != 0;
    }

    public boolean isInRange(class_1657 pPlayer) {
        return !this.field_11865 && pPlayer.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
        if (this.canAccess(pPlayer)) {
            return new VendingMachineConfigMenu(pContainerId, pPlayerInventory, this);
        }
        return new VendingMachineTradingMenu(pContainerId, pPlayerInventory, this);
    }

    public void setCustomName(class_2561 pName) {
        this.name = pName;
        this.method_5431();
    }

    public class_2561 method_5477() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 method_5797() {
        return this.name;
    }

    protected class_2561 getDefaultName() {
        return Content.VENDING_MACHINE.get().method_9518();
    }

    public BasicContainer getConfig() {
        return this.config;
    }

    public int getInputSides() {
        return this.inputSides;
    }

    public int getOutputSides() {
        return this.outputSides;
    }

    public int getAutoSides() {
        return this.autoSides;
    }

    public int getMatchNBT() {
        return this.matchNBT;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public int getTradingState() {
        if (this.hasInputs == null) {
            this.hasInputs = this.creativeMode || this.consumeInputs(new ArrayList<class_1799>()) != null;
        }
        return this.hasInputs != false ? 1 : 0;
    }

    public void setSides(int id, int config, boolean auto) {
        this.inputSides = (config & 1) != 0 ? (this.inputSides |= 1 << id) : (this.inputSides &= ~(1 << id));
        this.outputSides = (config & 2) != 0 ? (this.outputSides |= 1 << id) : (this.outputSides &= ~(1 << id));
        this.autoSides = auto && config != 0 ? (this.autoSides |= 1 << id) : (this.autoSides &= ~(1 << id));
        this.method_5431();
    }

    public void setMatchNBT(int slot, boolean config) {
        this.matchNBT = config ? (this.matchNBT |= 1 << slot) : (this.matchNBT &= ~(1 << slot));
    }

    public TradeResult tradeWith(class_1263 c) {
        if (this.creativeMode) {
            ArrayList<class_1799> playerItems = new ArrayList<class_1799>();
            Runnable commitGetPlayer = this.consumeInputs(c, 0, playerItems);
            if (commitGetPlayer == null) {
                return TradeResult.TRADER_MISSING_INPUT;
            }
            ArrayList<class_1799> machineItems = new ArrayList<class_1799>();
            for (int i = 4; i < 8; ++i) {
                class_1799 o = this.config.method_5438(i);
                int rem = o.method_7947();
                if (rem <= 0 || o.method_7909() == Content.TAG_FILTER.get()) continue;
                machineItems.add(o.method_7972());
            }
            Runnable commitGive = this.addOutput(c, machineItems, true);
            if (commitGive == null) {
                return TradeResult.TRADER_NO_SPACE;
            }
            commitGetPlayer.run();
            commitGive.run();
            return TradeResult.SUCCESS;
        }
        ArrayList<class_1799> playerItems = new ArrayList<class_1799>();
        ArrayList<class_1799> machineItems = new ArrayList<class_1799>();
        Runnable commitGetPlayer = this.consumeInputs(c, 0, playerItems);
        if (commitGetPlayer == null) {
            return TradeResult.TRADER_MISSING_INPUT;
        }
        Runnable commitGetInv = this.consumeInputs(machineItems);
        if (commitGetInv == null) {
            return TradeResult.MACHINE_MISSING_INPUT;
        }
        Runnable commitGive = this.addOutput(c, machineItems, true);
        if (commitGive == null) {
            return TradeResult.TRADER_NO_SPACE;
        }
        Runnable commitStore = this.addOutput(playerItems);
        if (commitStore == null) {
            return TradeResult.MACHINE_NO_SPACE;
        }
        commitGetPlayer.run();
        commitGetInv.run();
        commitGive.run();
        commitStore.run();
        return TradeResult.SUCCESS;
    }

    @Override
    public boolean canAccess(class_1657 p) {
        if (this.creativeMode && !p.method_31549().field_7477) {
            return false;
        }
        return super.canAccess(p);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T beIn) {
        if (!(beIn instanceof VendingMachineBlockEntity)) {
            return;
        }
        VendingMachineBlockEntity be = (VendingMachineBlockEntity)beIn;
        if (level.method_75260() % 20L != (long)(Math.abs(pos.hashCode()) % 20)) {
            return;
        }
        for (class_2350 d : class_2350.values()) {
            if (!be.isAutoSide(d)) continue;
            if (be.canInputFrom(d)) {
                be.pullItemsFrom(pos.method_10093(d), d.method_10153());
            }
            if (!be.canOutput(d)) continue;
            be.pushItemsTo(pos.method_10093(d), d.method_10153());
        }
    }

    public void setCreativeMode(boolean b) {
        this.creativeMode = b;
        this.hasInputs = null;
        this.method_5431();
    }

    public void method_66473(class_2338 pos, class_2680 state) {
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.getInputs());
        class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.getOutputs());
    }
}

