/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading;

import com.tom.trading.Platform;
import com.tom.trading.block.VendingMachineBlock;
import com.tom.trading.item.TagFilterItem;
import com.tom.trading.menu.VendingMachineConfigMenu;
import com.tom.trading.menu.VendingMachineTradingMenu;
import com.tom.trading.tile.VendingMachineBlockEntity;
import com.tom.trading.tile.VendingMachineBlockEntityBase;
import com.tom.trading.util.GameObject;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class Content {
    public static final GameObject<VendingMachineBlock> VENDING_MACHINE = Content.blockWithItem("vending_machine", VendingMachineBlock::new, p -> p.mapColor(MapColor.METAL).sound(SoundType.METAL).requiresCorrectToolForDrops().strength(5.0f).lightLevel(s -> 8));
    public static final GameObject<TagFilterItem> TAG_FILTER = Content.itemNoTab("tag_filter", TagFilterItem::new, p -> p);
    public static final GameObject.GameObjectBlockEntity<VendingMachineBlockEntityBase> VENDING_MACHINE_TILE = Content.blockEntity("vending_machine.tile", VendingMachineBlockEntity::new, VENDING_MACHINE);
    public static final GameObject<MenuType<VendingMachineTradingMenu>> VENDING_MACHINE_TRADING_MENU = Content.menu("vending_machine.menu_trading", VendingMachineTradingMenu::new);
    public static final GameObject<MenuType<VendingMachineConfigMenu>> VENDING_MACHINE_CONFIG_MENU = Content.menu("vending_machine.menu_config", VendingMachineConfigMenu::new);
    public static final GameObject<DataComponentType<TagKey<Item>>> TAG_COMPONENT = Platform.DATA_COMPONENT_TYPES.register("tag", () -> DataComponentType.builder().persistent(TagKey.codec((ResourceKey)Registries.ITEM)).build());

    private static <B extends Block> GameObject<B> blockWithItem(String name, Function<BlockBehaviour.Properties, B> create, UnaryOperator<BlockBehaviour.Properties> defaultProps) {
        return Content.blockWithItem(name, create, BlockItem::new, defaultProps, UnaryOperator.identity());
    }

    private static <B extends Block, I extends Item> GameObject<B> blockWithItem(String name, Function<BlockBehaviour.Properties, B> create, BiFunction<Block, Item.Properties, I> createItem, UnaryOperator<BlockBehaviour.Properties> defaultProps, UnaryOperator<Item.Properties> defaultItemProps) {
        GameObject<Block> re = Platform.BLOCKS.register(name, k -> (Block)create.apply((BlockBehaviour.Properties)defaultProps.apply(BlockBehaviour.Properties.of().setId(k))));
        Content.item(name, p -> (Item)createItem.apply((Block)re.get(), (Item.Properties)p), p -> (Item.Properties)defaultItemProps.apply(p.useBlockDescriptionPrefix()));
        return re;
    }

    private static <I extends Item> GameObject<I> item(String name, Function<Item.Properties, I> fact, UnaryOperator<Item.Properties> defaultProps) {
        return Content.itemNoTab(name, p -> Platform.addItemToTab((Item)fact.apply((Item.Properties)p)), defaultProps);
    }

    private static <I extends Item> GameObject<I> itemNoTab(String name, Function<Item.Properties, I> fact, UnaryOperator<Item.Properties> defaultProps) {
        return Platform.ITEMS.register(name, k -> (Item)fact.apply((Item.Properties)defaultProps.apply(new Item.Properties().setId(k))));
    }

    @SafeVarargs
    private static <BE extends BlockEntity> GameObject.GameObjectBlockEntity<BE> blockEntity(String name, GameObject.GameRegistryBE.BEFactory<? extends BE> create, GameObject<? extends Block> ... blocks) {
        return Platform.BLOCK_ENTITY.registerBE(name, create, blocks);
    }

    private static <M extends AbstractContainerMenu> GameObject<MenuType<M>> menu(String name, MenuType.MenuSupplier<M> create) {
        return Platform.MENU_TYPE.register(name, () -> new MenuType(create, FeatureFlags.VANILLA_SET));
    }

    public static void init() {
    }
}

