/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading;

import com.tom.trading.Content;
import com.tom.trading.util.GameObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Platform {
    public static final GameObject.GameRegistry<Item> ITEMS = new GameObject.GameRegistry(Registries.ITEM);
    public static final GameObject.GameRegistry<Block> BLOCKS = new GameObject.GameRegistry(Registries.BLOCK);
    public static final GameObject.GameRegistryBE BLOCK_ENTITY = new GameObject.GameRegistryBE();
    public static final GameObject.GameRegistry<MenuType<?>> MENU_TYPE = new GameObject.GameRegistry(Registries.MENU);
    public static final DeferredRegister<CreativeModeTab> TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"toms_trading_network");
    public static final GameObject.GameRegistry<DataComponentType<?>> DATA_COMPONENT_TYPES = new GameObject.GameRegistry(Registries.DATA_COMPONENT_TYPE);
    private static List<Item> tabItems = new ArrayList<Item>();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> STORAGE_MOD_TAB = TAB.register("tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.toms_trading_network.tab")).icon(() -> new ItemStack((ItemLike)Content.VENDING_MACHINE.get())).displayItems((p, out) -> tabItems.forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0))).build());

    public static <I extends Item> I addItemToTab(I item) {
        tabItems.add(item);
        return item;
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
        BLOCK_ENTITY.register(bus);
        MENU_TYPE.register(bus);
        DATA_COMPONENT_TYPES.register(bus);
        TAB.register(bus);
    }

    public static <M extends AbstractContainerMenu> MenuType<M> createMenuType(MenuType.MenuSupplier<M> create) {
        return new MenuType(create, FeatureFlags.VANILLA_SET);
    }

    public static TagKey<Item> getItemTag(ResourceLocation name) {
        return ItemTags.create((ResourceLocation)name);
    }
}

