/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading;

import com.tom.trading.Content;
import com.tom.trading.Platform;
import com.tom.trading.TradingNetworkModClient;
import com.tom.trading.block.AlwaysActivatableBlock;
import com.tom.trading.network.NetworkHandler;
import com.tom.trading.tile.OwnableBlockEntity;
import com.tom.trading.tile.VendingMachineBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toms_trading_network")
public class TradingNetworkMod {
    public static final String MODID = "toms_trading_network";
    public static final Logger LOGGER = LogManager.getLogger((String)"toms_trading_network");

    public TradingNetworkMod(IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::enqueueIMC);
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            TradingNetworkModClient.preInit(bus);
        }
        bus.addListener(this::doClientStuff);
        bus.addListener(this::registerCapabilities);
        bus.register(NetworkHandler.class);
        NeoForge.EVENT_BUS.register((Object)this);
        Content.init();
        Platform.register(bus);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Tom's Trading Network Setup starting");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        TradingNetworkModClient.clientSetup();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        AlwaysActivatableBlock aab;
        Block block;
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (!event.getEntity().isSecondaryUseActive() && (block = state.getBlock()) instanceof AlwaysActivatableBlock && (aab = (AlwaysActivatableBlock)block).onActivate(state, event.getLevel(), event.getPos(), event.getEntity(), event.getHand(), event.getHitVec())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBreak(BlockEvent.BreakEvent event) {
        OwnableBlockEntity o;
        BlockEntity be = event.getLevel().getBlockEntity(event.getPos());
        if (be instanceof OwnableBlockEntity && !(o = (OwnableBlockEntity)be).canAccess(event.getPlayer()) && !event.getPlayer().hasPermissions(2)) {
            event.setCanceled(true);
        }
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> {
                try {
                    return Class.forName("com.tom.trading.top.TheOneProbeHandler").getDeclaredMethod("create", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return null;
                }
            });
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.Item.BLOCK, (BlockEntityType)Content.VENDING_MACHINE_TILE.get(), (be, side) -> ((VendingMachineBlockEntity)((Object)be)).getInventory((Direction)side));
    }
}

