/*
 * Decompiled with CFR 0.152.
 */
package com.tom.trading.jade;

import com.tom.trading.jade.JadePlugin;
import com.tom.trading.util.BasicContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.ResizeableElement;

public enum VendingMachineComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public ResourceLocation getUid() {
        return JadePlugin.VENDING_MACHINE;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().contains("config")) {
            BasicContainer c = new BasicContainer(8);
            ValueInput in = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)accessor.getServerData());
            c.loadItems((ValueInput.TypedInputList<ItemStackWithSlot>)in.listOrEmpty("config", ItemStackWithSlot.CODEC));
            byte state = in.getByteOr("state", (byte)0);
            if (accessor.showDetails()) {
                ITooltip t = JadeUI.tooltip();
                t.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.cost"));
                for (int i = 0; i < 4; ++i) {
                    ItemStack is = c.getItem(i);
                    if (is.isEmpty()) continue;
                    ResizeableElement icon = JadeUI.item((ItemStack)is, (float)1.0f).size(18, 18).offset(0, -1);
                    t.add((LayoutElement)icon);
                    is.getTooltipLines(Item.TooltipContext.of((Level)accessor.getLevel()), accessor.getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL).forEach(arg_0 -> ((ITooltip)t).add(arg_0));
                }
                BoxStyle b = BoxStyle.transparent().clone();
                b.borderWidth = 1;
                tooltip.add((LayoutElement)JadeUI.box((ITooltip)t, (BoxStyle)b));
                t = JadeUI.tooltip();
                t.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.result"));
                for (int i = 4; i < 8; ++i) {
                    ItemStack is = c.getItem(i);
                    if (is.isEmpty()) continue;
                    ResizeableElement icon = JadeUI.item((ItemStack)is, (float)1.0f).size(18, 18).offset(0, -1);
                    t.add((LayoutElement)icon);
                    is.getTooltipLines(Item.TooltipContext.of((Level)accessor.getLevel()), accessor.getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL).forEach(arg_0 -> ((ITooltip)t).add(arg_0));
                }
                b = BoxStyle.transparent().clone();
                b.borderWidth = 1;
                tooltip.add((LayoutElement)JadeUI.box((ITooltip)t, (BoxStyle)b));
            } else {
                tooltip.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.cost"));
                tooltip.add((Component)Component.empty());
                for (int i = 0; i < c.getContainerSize(); ++i) {
                    ItemStack is = c.getItem(i);
                    if (!is.isEmpty()) {
                        ResizeableElement icon = JadeUI.item((ItemStack)is, (float)0.5f).size(10, 10).offset(0, -1);
                        tooltip.append((LayoutElement)icon);
                    }
                    if (i != 3) continue;
                    tooltip.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.result"));
                    tooltip.add((Component)Component.empty());
                }
            }
            if (state == 0) {
                tooltip.add((Component)Component.translatable((String)"label.toms_trading_network.vending_machine.noItems"));
            }
        } else {
            tooltip.append((Component)Component.translatable((String)"jade.toms_trading_network.noServerInfo"));
        }
    }
}

